/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.remote.internal.core;

import java.util.List;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.core.IRemoteProcessBuilder;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.IRemoteServicesDescriptor;
import org.eclipse.ptp.remote.internal.core.LocalConnection;
import org.eclipse.ptp.remote.internal.core.LocalConnectionManager;
import org.eclipse.ptp.remote.internal.core.LocalFileManager;
import org.eclipse.ptp.remote.internal.core.LocalProcessBuilder;

public class LocalServices
implements IRemoteServices {
    public static final String LocalServicesId = "org.eclipse.ptp.remote.LocalServices";
    private IRemoteFileManager fFileMgr = null;
    private final IRemoteConnectionManager fConnMgr = new LocalConnectionManager(this);
    private final IRemoteServicesDescriptor fDescriptor;

    public LocalServices(IRemoteServicesDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    @Override
    public boolean canCreateConnections() {
        return this.fDescriptor.canCreateConnections();
    }

    @Override
    public IRemoteConnectionManager getConnectionManager() {
        return this.fConnMgr;
    }

    @Override
    public IRemoteFileManager getFileManager(IRemoteConnection conn) {
        if (!(conn instanceof LocalConnection)) {
            return null;
        }
        if (this.fFileMgr == null) {
            this.fFileMgr = new LocalFileManager((LocalConnection)conn);
        }
        return this.fFileMgr;
    }

    @Override
    public String getId() {
        return this.fDescriptor.getId();
    }

    @Override
    public String getName() {
        return this.fDescriptor.getName();
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, List<String> command) {
        return new LocalProcessBuilder(conn, command);
    }

    @Override
    public IRemoteProcessBuilder getProcessBuilder(IRemoteConnection conn, String ... command) {
        return new LocalProcessBuilder(conn, command);
    }

    @Override
    public String getScheme() {
        return this.fDescriptor.getScheme();
    }

    public Object getServicesExtension(IRemoteConnection conn, Class extension) {
        return null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isInitialized() {
        return true;
    }
}

