/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CTabFolderTab
extends ExampleTab {
    protected static final int MAX_ITEMS = 3;
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String CTAB_IMAGE_PATH = "resources/newfolder_wiz.gif";
    private Image ctabImage;
    private CTabFolder folder;
    private boolean showClose;
    private boolean unselectedCloseVisible;
    private boolean setImage;
    private boolean unselectedImageVisible;
    private boolean showTopRightControl;
    private boolean minVisible;
    private boolean maxVisible;
    private int selFgIndex;
    private int selBgIndex;
    private int tabHeight = -1;
    private boolean showSelectionBgGradient = false;
    private boolean showSelectionBgImage = false;
    private boolean customFontOnItem;
    private static Font customFont = Graphics.getFont((String)"Courier", (int)12, (int)2);
    private Button[] tabRadios;

    public CTabFolderTab(CTabFolder parent) {
        super(parent, "CTabFolder");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("FLAT", 0x800000);
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createStyleButton("CLOSE", 64);
        this.createStyleButton("SINGLE", 4);
        this.createStyleButton("MULTI", 2);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFontChooser();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createSelectionFgColorButton();
        this.createSelectionBgColorButton();
        this.createSelectionBgGradientButton();
        this.createSelectionBgImageButton();
        this.createBgImageButton();
        this.createTabHeightControl(this.styleComp);
        this.createTopRightControl(this.styleComp);
        final Button cbMin = this.createPropertyButton("Minimize visible", 32);
        cbMin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.minVisible = cbMin.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        final Button cbMax = this.createPropertyButton("Maximize visible", 32);
        cbMax.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.maxVisible = cbMax.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        this.tabRadios = new Button[3];
        int i = 0;
        while (i < 3) {
            final int index = i;
            String rbText = "Select " + this.folder.getItem(index).getText();
            this.tabRadios[i] = this.createPropertyButton(rbText, 16);
            this.tabRadios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button radio = (Button)event.getSource();
                    if (radio.getSelection()) {
                        CTabFolderTab.this.folder.setSelection(index);
                    }
                }
            });
            ++i;
        }
        this.tabRadios[0].setSelection(true);
        String text = "Set Image";
        Button cbSetImage = this.createPropertyButton(text, 32);
        cbSetImage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.setImage = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        text = "UnselectedImageVisible";
        Button cbUnselectedImageVisible = this.createPropertyButton(text, 32);
        cbUnselectedImageVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.unselectedImageVisible = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        text = "UnselectedCloseVisible";
        Button cbUnselectedCloseVisible = this.createPropertyButton(text, 32);
        cbUnselectedCloseVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.unselectedCloseVisible = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        text = "showClose on Tab 2";
        Button cbShowClose = this.createPropertyButton(text, 32);
        cbShowClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.showClose = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        text = "Custom font on Tab 2";
        Button cbCustomFont = this.createPropertyButton(text, 32);
        cbCustomFont.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.customFontOnItem = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        text = "Switch tabPosition";
        Button btnSwitchTabPosition = this.createPropertyButton(text, 8);
        btnSwitchTabPosition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean isTop = CTabFolderTab.this.folder.getTabPosition() == 128;
                CTabFolderTab.this.folder.setTabPosition(isTop ? 1024 : 128);
            }
        });
        Button borderVisibleButton = this.createPropertyButton("Switch borderVisible", 8);
        borderVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.folder.setBorderVisible(!CTabFolderTab.this.folder.getBorderVisible());
            }
        });
        Button btnAddTabItem = new Button(parent, 8);
        btnAddTabItem.setText("Add Item (SWT.NONE)");
        btnAddTabItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.createTabItem(0);
            }
        });
        Button btnAddCloseableTabItem = new Button(parent, 8);
        btnAddCloseableTabItem.setText("Add Item (SWT.CLOSE)");
        btnAddCloseableTabItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.createTabItem(64);
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        this.folder = new CTabFolder(parent, this.getStyle());
        this.folder.setLayoutData((Object)new GridData(300, 300));
        int i = 0;
        while (i < 3) {
            this.createTabItem(0);
            ++i;
        }
        this.folder.setSelection(0);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabItem item = (CTabItem)event.item;
                if (CTabFolderTab.this.tabRadios != null) {
                    int index = item.getParent().indexOf(item);
                    int i = 0;
                    while (i < 3) {
                        CTabFolderTab.this.tabRadios[i].setSelection(index == i);
                        ++i;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.registerControl((Control)this.folder);
        if (this.tabHeight >= 0) {
            this.folder.setTabHeight(this.tabHeight);
        }
        this.updateContextMenu();
        this.updateTopRightControl();
        this.updateProperties();
        this.updateSelFgColor();
        this.updateSelBgGradient();
        this.updateSelBgColor();
        this.updateSelBgImage();
    }

    private void createTabItem(int style) {
        CTabItem item = new CTabItem(this.folder, style);
        int count = this.folder.getItemCount();
        item.setText("Tab " + count);
        if (this.setImage) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.ctabImage = Graphics.getImage((String)CTAB_IMAGE_PATH, (ClassLoader)classLoader);
            item.setImage(this.ctabImage);
        } else {
            item.setImage(null);
        }
        if (count != 3) {
            Text content = new Text((Composite)this.folder, 66);
            if (count % 2 != 0) {
                content.setBackground(BG_COLOR_BROWN);
                content.setForeground(FG_COLOR_BLUE);
            }
            content.setText("Some Content " + count);
            item.setControl((Control)content);
        }
    }

    private void createTabHeightControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Tab Height");
        final Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(this.folder.getTabHeight());
        spinner.setMinimum(0);
        spinner.setMaximum(100);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CTabFolderTab.this.tabHeight = spinner.getSelection();
                CTabFolderTab.this.folder.setTabHeight(CTabFolderTab.this.tabHeight);
            }
        });
    }

    private void createTopRightControl(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Top Right Control");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.showTopRightControl = button.getSelection();
                CTabFolderTab.this.updateTopRightControl();
            }
        });
    }

    private Button createSelectionFgColorButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Selection Foreground");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.selFgIndex = (CTabFolderTab.this.selFgIndex + 1) % CTabFolderTab.this.fgColors.length;
                CTabFolderTab.this.updateSelFgColor();
            }
        });
        return button;
    }

    private Button createSelectionBgColorButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Selection Background");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.selBgIndex = (CTabFolderTab.this.selBgIndex + 1) % CTabFolderTab.this.bgColors.length;
                CTabFolderTab.this.updateSelBgColor();
            }
        });
        return button;
    }

    private Button createSelectionBgGradientButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Selection Background Gradient");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.showSelectionBgGradient = button.getSelection();
                CTabFolderTab.this.updateSelBgGradient();
            }
        });
        return button;
    }

    private Button createSelectionBgImageButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("Selection Background Image");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.showSelectionBgImage = button.getSelection();
                CTabFolderTab.this.updateSelBgImage();
            }
        });
        return button;
    }

    private void updateProperties() {
        CTabItem[] items = this.folder.getItems();
        int i = 0;
        while (i < items.length) {
            if (this.setImage) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                this.ctabImage = Graphics.getImage((String)CTAB_IMAGE_PATH, (ClassLoader)classLoader);
                items[i].setImage(this.ctabImage);
            } else {
                items[i].setImage(null);
            }
            ++i;
        }
        if (items.length > 1) {
            items[1].setShowClose(this.showClose);
            items[1].setFont((Font)(this.customFontOnItem ? customFont : null));
        }
        this.folder.setMinimizeVisible(this.minVisible);
        this.folder.setMaximizeVisible(this.maxVisible);
        this.folder.setUnselectedCloseVisible(this.unselectedCloseVisible);
        this.folder.setUnselectedImageVisible(this.unselectedImageVisible);
    }

    private void updateTopRightControl() {
        if (this.showTopRightControl) {
            Label label = new Label((Composite)this.folder, 0);
            label.setText("topRight");
            Display display = label.getDisplay();
            label.setBackground(display.getSystemColor(14));
            this.folder.setTopRight((Control)label);
        } else {
            Control topRight = this.folder.getTopRight();
            if (topRight != null && !topRight.isDisposed()) {
                topRight.dispose();
            }
            this.folder.setTopRight(null);
        }
    }

    private void updateSelFgColor() {
        for (Control control : this.controls) {
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            folder.setSelectionForeground(this.fgColors[this.selFgIndex]);
        }
    }

    private void updateSelBgColor() {
        for (Control control : this.controls) {
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            folder.setSelectionBackground(this.bgColors[this.selBgIndex]);
        }
    }

    private void updateSelBgGradient() {
        for (Control control : this.controls) {
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            if (this.showSelectionBgGradient) {
                Color[] gradientColors = new Color[]{BGG_COLOR_BLUE, BGG_COLOR_GREEN, BGG_COLOR_BLUE};
                int[] percents = new int[]{50, 100};
                folder.setSelectionBackground(gradientColors, percents);
                continue;
            }
            folder.setSelectionBackground(null, null);
        }
    }

    private void updateSelBgImage() {
        for (Control control : this.controls) {
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            Image image = Util.loadImage(control.getDisplay(), "resources/pattern.png");
            if (this.showSelectionBgImage) {
                folder.setSelectionBackground(image);
                continue;
            }
            folder.setSelectionBackground(null);
        }
    }

    private void updateContextMenu() {
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu folderMenu = new Menu((Control)this.folder);
            MenuItem folderMenuItem = new MenuItem(folderMenu, 8);
            folderMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the CTabFolder";
                    MessageDialog.openInformation((Shell)CTabFolderTab.this.folder.getShell(), (String)"Information", (String)message);
                }
            });
            folderMenuItem.setText("CTabFolder context menu item");
            this.folder.setMenu(folderMenu);
        }
    }
}

