/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.preferences;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.recommenders.completion.rcp.calls.l10n.Messages;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.CallsCompletionProposalComputer;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.completion.rcp.calls.preferences.ModelLabelProvider;
import org.eclipse.recommenders.internal.completion.rcp.calls.preferences.PackageFragmentRootLabelProvider;
import org.eclipse.recommenders.internal.completion.rcp.calls.preferences.VersionLabelProvider;
import org.eclipse.recommenders.internal.completion.rcp.calls.wiring.CallsCompletionPlugin;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.rcp.ClasspathEntryInfo;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.rcp.RCPUtils;
import org.eclipse.recommenders.utils.rcp.internal.ContentAssistEnablementBlock;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CallPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    public static final String ID_MAX_PROPOSALS = "recommenders.calls.max_proposals";
    public static final String ID_MIN_PROBABILITY = "recommenders.calls.min_probability";
    private final IClasspathEntryInfoProvider cpeInfoProvider;
    private final IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore;
    private List<Tuple<ClasspathEntryInfo, ModelArchiveMetadata<?, ?>>> mappings;
    final IModelRepository repository;
    private ContentAssistEnablementBlock enablement;
    private IntegerFieldEditor maxProposals;
    private IntegerFieldEditor minProbability;
    private Text rootName;
    private Text rootVersion;
    private Text rootFingerprint;
    private Text modelCoordinate;
    private ComboViewer modelStatus;
    private TableViewer tableViewer;
    private WritableValue mValue;
    private WritableValue rValue;

    @Inject
    public CallPreferencePage(IClasspathEntryInfoProvider cpeInfoProvider, IModelArchiveStore<IType, IObjectMethodCallsNet> modelStore, IModelRepository repository) {
        this.cpeInfoProvider = cpeInfoProvider;
        this.modelStore = modelStore;
        this.repository = repository;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CallsCompletionPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.PREFPAGE_DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createConfigurationBlock(composite);
        this.createModelInformationBlock(composite);
        return composite;
    }

    private void createConfigurationBlock(Composite composite) {
        this.enablement = new ContentAssistEnablementBlock(composite, Messages.PREFPAGE_ENABLE_CALL_COMPLETION, CallsCompletionProposalComputer.CATEGORY_ID);
        Composite group = new Composite(composite, 0);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.maxProposals = this.createIntegerField(group, ID_MAX_PROPOSALS, Messages.PREFPAGE_MAX_NUMBER_OF_PROPOSALS, 1, 100);
        this.minProbability = this.createIntegerField(group, ID_MIN_PROBABILITY, Messages.PREFPAGE_MIN_PROBABILITY_OF_PROPOSAL, 1, 100);
    }

    private IntegerFieldEditor createIntegerField(Composite parent, String name, String text, int min, int max) {
        IntegerFieldEditor editor = new IntegerFieldEditor(name, text, parent);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.setPage((DialogPage)this);
        editor.setValidRange(min, max);
        editor.setPropertyChangeListener((IPropertyChangeListener)this);
        editor.load();
        return editor;
    }

    private void createModelInformationBlock(Composite composite) {
        new Label(composite, 0).setText(Messages.PREFPAGE_TABLE_DESCRIPTION);
        this.computeMappings();
        SashForm form = new SashForm(composite, 256);
        form.setLayout((Layout)new FillLayout());
        this.createTable((Composite)form);
        this.createDetails(form);
        this.bindValues();
        form.setWeights(new int[]{50, 50});
    }

    private void computeMappings() {
        this.mappings = Lists.newLinkedList();
        for (File root : this.cpeInfoProvider.getFiles()) {
            Optional opt = this.cpeInfoProvider.getInfo(root);
            if (!opt.isPresent()) continue;
            ClasspathEntryInfo cpei = (ClasspathEntryInfo)opt.get();
            ModelArchiveMetadata metadata = this.modelStore.findOrCreateMetadata(root);
            Tuple entry = Tuple.newTuple((Object)cpei, (Object)metadata);
            this.mappings.add(entry);
        }
    }

    private void bindValues() {
        DataBindingContext ctx = new DataBindingContext();
        this.rValue = new WritableValue();
        this.bindValue(ctx, (Widget)this.rootName, ClasspathEntryInfo.class, "symbolicName", (IObservableValue)this.rValue);
        this.bindValue(ctx, (Widget)this.rootFingerprint, ClasspathEntryInfo.class, "fingerprint", (IObservableValue)this.rValue);
        this.bindValue(ctx, (Widget)this.rootVersion, ClasspathEntryInfo.class, "version", (IObservableValue)this.rValue);
        this.mValue = new WritableValue();
        this.bindValue(ctx, (Widget)this.modelCoordinate, ModelArchiveMetadata.class, "coordinate", (IObservableValue)this.mValue);
        IViewerObservableValue widgetValue = ViewerProperties.singlePostSelection().observe((Viewer)this.modelStatus);
        IObservableValue modelValue = BeanProperties.value(ModelArchiveMetadata.class, (String)"status").observeDetail((IObservableValue)this.mValue);
        ctx.bindValue((IObservableValue)widgetValue, modelValue);
    }

    private void bindValue(DataBindingContext ctx, Widget widget, Class<?> clazz, String property, IObservableValue value) {
        ISWTObservableValue widgetValue = WidgetProperties.text((int)24).observe(widget);
        IObservableValue modelValue = BeanProperties.value(clazz, (String)property).observeDetail(value);
        ctx.bindValue((IObservableValue)widgetValue, modelValue);
    }

    private void createDetails(SashForm form) {
        Composite parent = new Composite((Composite)form, 0);
        parent.setLayout((Layout)new GridLayout());
        GridDataFactory f = GridDataFactory.fillDefaults().grab(true, false);
        Group rootContainer = new Group(parent, 16);
        rootContainer.setText(Messages.PREFPAGE_PACKAGE_ROOT_INFO);
        rootContainer.setLayout((Layout)new GridLayout(2, false));
        rootContainer.setLayoutData((Object)f.create());
        this.createLabel((Composite)rootContainer, Messages.PREFPAGE_PACKAGE_ROOT_NAME);
        this.rootName = this.createText((Composite)rootContainer, 2056);
        this.createLabel((Composite)rootContainer, Messages.PREFPAGE_PACKAGE_ROOT_VERSION);
        this.rootVersion = this.createText((Composite)rootContainer, 2056);
        this.createLabel((Composite)rootContainer, Messages.PREFPAGE_PACKAGE_ROOT_FINGERPRINT);
        this.rootFingerprint = this.createText((Composite)rootContainer, 2056);
        Group modelContainer = new Group(parent, 16);
        modelContainer.setText(Messages.PREFPAGE_MODEL_INFO);
        modelContainer.setLayout((Layout)new GridLayout(2, false));
        modelContainer.setLayoutData((Object)f.create());
        this.createLabel((Composite)modelContainer, Messages.PREFPAGE_MODEL_CCORDINATE);
        this.modelCoordinate = this.createText((Composite)modelContainer, 2048);
        this.createLabel((Composite)modelContainer, Messages.PREFPAGE_MODEL_RESOLUTION_STATUS);
        this.modelStatus = new ComboViewer((Composite)modelContainer, 2048);
        this.modelStatus.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.modelStatus.setInput((Object)ModelArchiveMetadata.ModelArchiveResolutionStatus.values());
    }

    private void createTable(Composite container) {
        ScrolledComposite sc = new ScrolledComposite(container, 768);
        sc.setLayoutData((Object)new GridLayout());
        sc.setExpandHorizontal(true);
        Composite tContainer = new Composite((Composite)sc, 0);
        tContainer.setSize(200, 500);
        this.tableViewer = new TableViewer(tContainer, 65536);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Tuple t1 = (Tuple)Checks.cast((Object)e1);
                File f1 = ((ModelArchiveMetadata)t1.getSecond()).getLocation();
                Tuple t2 = (Tuple)Checks.cast((Object)e2);
                File f2 = ((ModelArchiveMetadata)t2.getSecond()).getLocation();
                return CompareToBuilder.reflectionCompare((Object)f1, (Object)f2);
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Optional e = RCPUtils.first((ISelection)event.getSelection());
                CallPreferencePage.this.mValue.setValue(((Tuple)e.get()).getSecond());
                CallPreferencePage.this.rValue.setValue(((Tuple)e.get()).getFirst());
            }
        });
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        Image versionImage = this.loadImage("/icons/obj16/file_version.png");
        Image versionUnknownImage = this.loadImage("/icons/obj16/file_version_unknown.png");
        Image modelImage = this.loadImage("/icons/obj16/model.png");
        Image modelUnknownImage = this.loadImage("/icons/obj16/model_unknown.png");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
        TableViewerColumn column = this.createTableViewerColumn(this.tableViewer, Messages.PREFPAGE_TABLE_COLUMN_FILE, 200, 0);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnWeightData(100));
        column.setLabelProvider((CellLabelProvider)new PackageFragmentRootLabelProvider());
        column = this.createTableViewerColumn(this.tableViewer, "", 20, 1);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(20));
        column.setLabelProvider((CellLabelProvider)new VersionLabelProvider(versionUnknownImage, versionImage));
        column = this.createTableViewerColumn(this.tableViewer, "", 20, 2);
        tableColumnLayout.setColumnData((Widget)column.getColumn(), (ColumnLayoutData)new ColumnPixelData(20));
        column.setLabelProvider((CellLabelProvider)new ModelLabelProvider(this.repository, modelImage, modelUnknownImage));
        tContainer.setLayout((Layout)tableColumnLayout);
        this.tableViewer.setInput(this.mappings);
        sc.setContent((Control)tContainer);
    }

    protected Text createText(Composite parent, int style) {
        Text text = new Text(parent, style);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).align(4, 1).create());
        return text;
    }

    protected Image loadImage(String name) {
        ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.completion.rcp.calls", (String)name);
        return desc.createImage();
    }

    protected Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(false);
        column.setMoveable(false);
        return viewerColumn;
    }

    protected void performDefaults() {
        this.maxProposals.loadDefault();
        this.minProbability.loadDefault();
    }

    public boolean performOk() {
        this.maxProposals.store();
        this.minProbability.store();
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        this.enablement.loadSelection();
        super.setVisible(visible);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            this.setValid(this.maxProposals.isValid() && this.minProbability.isValid());
        }
    }
}

