/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.templates;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.completion.rcp.templates.PatternRecommendation;
import org.eclipse.swt.graphics.Image;

public final class JavaTemplateProposal
extends TemplateProposal
implements Comparable<JavaTemplateProposal> {
    private final PatternRecommendation patternRecommendation;

    public JavaTemplateProposal(Template template, DocumentTemplateContext context, Image image, PatternRecommendation patternRecommendation) {
        super(template, (TemplateContext)context, JavaTemplateProposal.calculateReplacementRegion(context), image);
        this.patternRecommendation = patternRecommendation;
        this.computeStyledDisplayString();
        this.setRelevance((int)((long)this.getRelevance() + Math.round(patternRecommendation.getProbability() * 100.0)));
    }

    private static IRegion calculateReplacementRegion(DocumentTemplateContext context) {
        return new Region(context.getCompletionOffset(), context.getCompletionLength());
    }

    private void computeStyledDisplayString() {
        StyledString styledString = new StyledString();
        styledString.append(String.format("dynamic '%s'", this.getTemplate().getDescription()));
        styledString.append(" - ", StyledString.QUALIFIER_STYLER);
        styledString.append(this.getTemplate().getName().replace("pattern", "Pattern #"), StyledString.QUALIFIER_STYLER);
        styledString.append(String.format(" - %d %%", Math.round(this.patternRecommendation.getProbability() * 100.0)), StyledString.COUNTER_STYLER);
        this.setDisplayString(styledString);
    }

    @Override
    public int compareTo(JavaTemplateProposal o) {
        int compareClassName = this.compareByClassName(o);
        if (compareClassName == 0) {
            return this.compareByProbability(o);
        }
        return -compareClassName;
    }

    private int compareByProbability(JavaTemplateProposal o) {
        return Double.valueOf(this.patternRecommendation.getProbability()).compareTo(o.patternRecommendation.getProbability());
    }

    private int compareByClassName(JavaTemplateProposal o) {
        return this.patternRecommendation.getType().getClassName().compareTo(o.patternRecommendation.getType().getClassName());
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replaceOffset = this.getReplaceOffset();
            if (offset >= replaceOffset) {
                String content = document.get(replaceOffset, offset - replaceOffset);
                String className = this.patternRecommendation.getType().getClassName();
                return StringUtils.startsWithIgnoreCase((CharSequence)className, (CharSequence)content);
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }
}

