/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaAllCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.recommenders.completion.rcp.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.completion.rcp.SessionProcessor;
import org.eclipse.recommenders.internal.completion.rcp.IProcessableProposalFactory;
import org.eclipse.recommenders.internal.completion.rcp.proposals.ProcessableProposalFactory;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Checks;

public abstract class ProcessableCompletionProposalComputer
extends JavaAllCompletionProposalComputer
implements ICompletionListener,
ICompletionListenerExtension2 {
    public static final CompletionProposal NULL_PROPOSAL = new CompletionProposal();
    public IProcessableProposalFactory proposalFactory;
    public IRecommendersCompletionContextFactory contextFactory;
    public Set<SessionProcessor> processors;
    public JavaContentAssistInvocationContext jdtContext;
    public IRecommendersCompletionContext crContext;
    public ContentAssistantFacade contentAssist;

    public ProcessableCompletionProposalComputer(IProcessableProposalFactory proposalFactory, IRecommendersCompletionContextFactory contextFactory) {
        this(proposalFactory, contextFactory, Sets.newLinkedHashSet());
    }

    public ProcessableCompletionProposalComputer(IProcessableProposalFactory proposalFactory, IRecommendersCompletionContextFactory contextFactory, Set<SessionProcessor> computers) {
        this.proposalFactory = proposalFactory;
        this.contextFactory = contextFactory;
        this.processors = computers;
    }

    public void sessionStarted() {
        this.unregisterCompletionListener();
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        LinkedList res = Lists.newLinkedList();
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return res;
        }
        this.storeContext(context);
        this.registerCompletionListener();
        this.fireStartSession(this.crContext);
        for (Map.Entry<IJavaCompletionProposal, CompletionProposal> pair : this.crContext.getProposals().entrySet()) {
            IJavaCompletionProposal proposal = ProcessableProposalFactory.create(pair.getValue(), pair.getKey(), this.jdtContext, this.proposalFactory);
            res.add(proposal);
            if (!(proposal instanceof IProcessableProposal)) continue;
            this.fireProcessProposal((IProcessableProposal)proposal);
        }
        this.fireEndComputation(res);
        this.fireAboutToShow(res);
        return res;
    }

    private void storeContext(ContentAssistInvocationContext context) {
        this.jdtContext = (JavaContentAssistInvocationContext)Checks.cast((Object)context);
        this.crContext = this.contextFactory.create(this.jdtContext);
    }

    private void registerCompletionListener() {
        ITextViewer v = this.jdtContext.getViewer();
        if (!(v instanceof SourceViewer)) {
            return;
        }
        SourceViewer sv = (SourceViewer)v;
        this.contentAssist = sv.getContentAssistantFacade();
        this.contentAssist.addCompletionListener((ICompletionListener)this);
    }

    protected void fireStartSession(IRecommendersCompletionContext crContext) {
        for (SessionProcessor p : this.processors) {
            p.startSession(crContext);
        }
    }

    protected void fireProcessProposal(IProcessableProposal proposal) {
        for (SessionProcessor p : this.processors) {
            try {
                p.process(proposal);
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"session processor '%s' failed with exception.", (Object[])new Object[]{p.getClass()});
            }
        }
        proposal.getProposalProcessorManager().prefixChanged(this.crContext.getPrefix());
    }

    protected void fireEndComputation(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.processors) {
            try {
                p.endSession(proposals);
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"session processor '%s' failed with exception.", (Object[])new Object[]{p.getClass()});
            }
        }
    }

    protected void fireAboutToShow(List<ICompletionProposal> proposals) {
        for (SessionProcessor p : this.processors) {
            try {
                p.aboutToShow(proposals);
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"session processor '%s' failed with exception.", (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void assistSessionEnded(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
        for (SessionProcessor p : this.processors) {
            try {
                p.selected(proposal);
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"session processor '%s' failed with exception.", (Object[])new Object[]{p.getClass()});
            }
        }
    }

    public void applied(ICompletionProposal proposal) {
        for (SessionProcessor p : this.processors) {
            try {
                p.applied(proposal);
            }
            catch (Exception e) {
                RecommendersPlugin.logError((Exception)e, (String)"session processor '%s' failed with exception.", (Object[])new Object[]{p.getClass()});
            }
        }
        this.unregisterCompletionListener();
    }

    private void unregisterCompletionListener() {
        if (this.contentAssist != null) {
            this.contentAssist.removeCompletionListener((ICompletionListener)this);
        }
    }
}

