/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.collect.Sets;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.completion.rcp.SessionProcessor;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SessionProcessorDescriptor
implements Comparable<SessionProcessorDescriptor> {
    private static final String PREF_NODE_ID_SESSIONPROCESSORS = "org.eclipse.recommenders.completion.rcp.sessionprocessors";
    private static final String DISABLED = "disabled";
    private static final String EXT_POINT_SESSION_PROCESSORS = "org.eclipse.recommenders.completion.rcp.sessionprocessors";
    private String id;
    private String name;
    private Image icon;
    private int priority;
    private boolean enabled;
    private SessionProcessor processor;

    public static SessionProcessorDescriptor[] parseExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.recommenders.completion.rcp.sessionprocessors");
        Set<String> disabledProcessors = SessionProcessorDescriptor.getDisabledProcessors();
        PriorityQueue<SessionProcessorDescriptor> queue = new PriorityQueue<SessionProcessorDescriptor>();
        try {
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                try {
                    String pluginId = elem.getContributor().getName();
                    String id = elem.getAttribute("id");
                    String name = elem.getAttribute("name");
                    String iconPath = elem.getAttribute("icon");
                    String priorityString = elem.getAttribute("priority");
                    int priority = priorityString == null ? 10 : Integer.parseInt(priorityString);
                    Image icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)iconPath).createImage();
                    SessionProcessor processor = (SessionProcessor)elem.createExecutableExtension("class");
                    boolean enable = !disabledProcessors.contains(id);
                    SessionProcessorDescriptor d = new SessionProcessorDescriptor(id, name, icon, priority, enable, processor);
                    queue.add(d);
                }
                catch (Exception e) {
                    RecommendersPlugin.logError((Exception)e, (String)"Exception during extension point parsing", (Object[])new Object[0]);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"Exception during extension point parsing", (Object[])new Object[0]);
        }
        SessionProcessorDescriptor[] res = queue.toArray(new SessionProcessorDescriptor[0]);
        return res;
    }

    private static Set<String> getDisabledProcessors() {
        String prefs = SessionProcessorDescriptor.getSessionProcessorPreferences().get(DISABLED, "");
        return Sets.newHashSet((Object[])StringUtils.split((String)prefs));
    }

    private static void saveDisabledProcessors(Set<String> disabledProcessors) {
        String join = StringUtils.join((Object[])new Set[]{disabledProcessors});
        SessionProcessorDescriptor.getSessionProcessorPreferences().put(DISABLED, join);
    }

    private static IEclipsePreferences getSessionProcessorPreferences() {
        return InstanceScope.INSTANCE.getNode("org.eclipse.recommenders.completion.rcp.sessionprocessors");
    }

    public SessionProcessorDescriptor(String id, String name, Image icon, int priority, boolean enabled, SessionProcessor processor) {
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.priority = priority;
        this.enabled = enabled;
        this.processor = processor;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Image getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    public SessionProcessor getProcessor() {
        return this.processor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        Set<String> disabledProcessors = SessionProcessorDescriptor.getDisabledProcessors();
        if (enable) {
            disabledProcessors.remove(this.id);
        } else {
            disabledProcessors.add(this.id);
        }
        SessionProcessorDescriptor.saveDisabledProcessors(disabledProcessors);
    }

    @Override
    public int compareTo(SessionProcessorDescriptor o) {
        String other = String.valueOf(o.priority) + o.id;
        String self = String.valueOf(this.priority) + this.id;
        return self.compareTo(other);
    }
}

