/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.providers;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.TreeMultimap;
import com.google.common.eventbus.EventBus;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class StaticHooksFinder
extends ExtdocProvider {
    private final EventBus workspaceBus;

    @Inject
    public StaticHooksFinder(EventBus workspaceBus) {
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public void onPackageRootSelection(IPackageFragmentRoot root, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        TreeMultimap index = TreeMultimap.create((Comparator)new TypeNameComparator(), (Comparator)new MethodNameComparator());
        try {
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                if (e.getElementType() == 4) {
                    IPackageFragment pkg = (IPackageFragment)e;
                    this.findStaticHooks(pkg, (TreeMultimap<IType, IMethod>)index);
                    pkg.close();
                }
                ++n2;
            }
        }
        catch (Exception x) {
            RecommendersPlugin.logError((Exception)x, (String)"Failed to determine static members for %s", (Object[])new Object[]{root.getElementName()});
        }
        this.runSyncInUiThread(new HooksRendererRunnable(index, parent));
    }

    @JavaSelectionSubscriber
    public void onPackageSelection(IPackageFragment pkg, JavaSelectionEvent event, Composite parent) throws ExecutionException {
        TreeMultimap index = TreeMultimap.create((Comparator)new TypeNameComparator(), (Comparator)new MethodNameComparator());
        try {
            this.findStaticHooks(pkg, (TreeMultimap<IType, IMethod>)index);
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"Failed to determine static members for package %s", (Object[])new Object[]{pkg.getElementName()});
        }
        this.runSyncInUiThread(new HooksRendererRunnable(index, parent));
    }

    private void findStaticHooks(IPackageFragment pkg, TreeMultimap<IType, IMethod> index) throws JavaModelException {
        IClassFile f;
        IClassFile[] iClassFileArray = pkg.getClassFiles();
        int n = iClassFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iClassFileArray[n2];
            this.findStaticHooks(index, (ITypeRoot)f);
            ++n2;
        }
        iClassFileArray = pkg.getCompilationUnits();
        n = iClassFileArray.length;
        n2 = 0;
        while (n2 < n) {
            f = iClassFileArray[n2];
            this.findStaticHooks(index, (ITypeRoot)f);
            ++n2;
        }
    }

    private void findStaticHooks(TreeMultimap<IType, IMethod> index, ITypeRoot root) throws JavaModelException {
        IType type = root.findPrimaryType();
        if (type == null) {
            return;
        }
        if (!type.isClass()) {
            return;
        }
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod m = iMethodArray[n2];
            if (JdtFlags.isStatic((IMember)m) && JdtFlags.isPublic((IMember)m) && !JdtUtils.isInitializer((IMethod)m)) {
                index.put((Object)type, (Object)m);
            }
            ++n2;
        }
    }

    private final class HooksRendererRunnable
    implements Runnable {
        private final TreeMultimap<IType, IMethod> index;
        private final Composite parent;
        private StyledText styledText;

        private HooksRendererRunnable(TreeMultimap<IType, IMethod> index, Composite parent) {
            this.index = index;
            this.parent = parent;
        }

        @Override
        public void run() {
            Composite container = ExtdocUtils.createComposite(this.parent, 1);
            if (this.index.isEmpty()) {
                ExtdocUtils.createLabel(container, "No public static method found in selected package (-root)", true);
            }
            LinkedList typeRanges = Lists.newLinkedList();
            StringBuilder sb = new StringBuilder();
            for (IType type : this.index.keySet()) {
                String typeLabel = type.getFullyQualifiedName();
                int typeLabelBegin = sb.length();
                sb.append(typeLabel);
                int typeLabelEnd = sb.length();
                StyleRange styleRange = new StyleRange();
                styleRange.rise = -12;
                styleRange.start = typeLabelBegin;
                styleRange.length = typeLabelEnd - typeLabelBegin;
                styleRange.fontStyle = 1;
                styleRange.data = type;
                styleRange.font = JFaceResources.getHeaderFont();
                typeRanges.add(styleRange);
                sb.append(IOUtils.LINE_SEPARATOR);
                for (IMethod method : this.index.get((Object)type)) {
                    sb.append("    ");
                    int methodLabelBegin = sb.length();
                    String methodLabel = JavaElementLabels.getElementLabel((IJavaElement)method, (long)33L);
                    sb.append(methodLabel);
                    int methodLabelEnd = sb.length();
                    StyleRange methodStyleRange = new StyleRange();
                    methodStyleRange.start = methodLabelBegin;
                    methodStyleRange.length = methodLabelEnd - methodLabelBegin;
                    methodStyleRange.data = method;
                    methodStyleRange.underline = true;
                    methodStyleRange.font = JFaceResources.getDialogFont();
                    methodStyleRange.foreground = Display.getDefault().getSystemColor(9);
                    typeRanges.add(methodStyleRange);
                    sb.append(IOUtils.LINE_SEPARATOR);
                }
            }
            this.styledText = new StyledText(container, 0);
            this.styledText.setRedraw(false);
            this.styledText.setLayoutData((Object)new GridData(4, 4, true, true));
            ExtdocUtils.setInfoBackgroundColor((Control)this.styledText);
            ExtdocUtils.setInfoForegroundColor((Control)this.styledText);
            this.styledText.setEditable(false);
            this.styledText.setText(sb.toString());
            this.styledText.setStyleRanges(typeRanges.toArray(new StyleRange[0]));
            final Cursor c1 = Display.getDefault().getSystemCursor(0);
            final Cursor c2 = Display.getDefault().getSystemCursor(21);
            this.styledText.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    Optional opt = HooksRendererRunnable.this.getSelectedMethod(event.x, event.y);
                    if (opt.isPresent()) {
                        JavaSelectionEvent sEvent = new JavaSelectionEvent((IJavaElement)opt.get(), JavaSelectionEvent.JavaSelectionLocation.METHOD_DECLARATION);
                        StaticHooksFinder.this.workspaceBus.post((Object)sEvent);
                    }
                }
            });
            this.styledText.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    Optional opt = HooksRendererRunnable.this.getSelectedMethod(e.x, e.y);
                    if (opt.isPresent()) {
                        HooksRendererRunnable.this.styledText.setCursor(c2);
                    } else {
                        HooksRendererRunnable.this.styledText.setCursor(c1);
                    }
                }
            });
            this.styledText.addMouseTrackListener(new MouseTrackListener(){

                public void mouseHover(MouseEvent e) {
                }

                public void mouseExit(MouseEvent e) {
                    System.out.println(e);
                }

                public void mouseEnter(MouseEvent e) {
                    System.out.println(e);
                }
            });
            this.styledText.setRedraw(true);
        }

        private Optional<StyleRange> getSelectedStyleRange(int x, int y) {
            try {
                int offset = this.styledText.getOffsetAtLocation(new Point(x, y));
                StyleRange style = this.styledText.getStyleRangeAtOffset(offset);
                return Optional.fromNullable((Object)style);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Optional.absent();
            }
        }

        private Optional<IMethod> getSelectedMethod(int x, int y) {
            Optional<StyleRange> range = this.getSelectedStyleRange(x, y);
            if (!range.isPresent()) {
                return Optional.absent();
            }
            Object data = ((StyleRange)range.get()).data;
            if (data instanceof IMethod) {
                return Optional.of((Object)((IMethod)data));
            }
            return Optional.absent();
        }
    }

    private final class MethodNameComparator
    implements Comparator<IMethod> {
        private MethodNameComparator() {
        }

        @Override
        public int compare(IMethod o1, IMethod o2) {
            String s1 = JavaElementLabels.getElementLabel((IJavaElement)o1, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
            String s2 = JavaElementLabels.getElementLabel((IJavaElement)o2, (long)JavaElementLabels.ALL_FULLY_QUALIFIED);
            return s1.compareTo(s2);
        }
    }

    private final class TypeNameComparator
    implements Comparator<IType> {
        private TypeNameComparator() {
        }

        @Override
        public int compare(IType arg0, IType arg1) {
            String s0 = arg0.getFullyQualifiedName();
            String s1 = arg1.getFullyQualifiedName();
            return s0.compareTo(s1);
        }
    }
}

