/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.wiring;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.rcp.providers.CachingAstProvider;
import org.eclipse.recommenders.internal.rcp.providers.ClasspathEntryInfoProvider;
import org.eclipse.recommenders.internal.rcp.providers.JavaModelEventsProvider;
import org.eclipse.recommenders.internal.rcp.providers.JavaSelectionProvider;
import org.eclipse.recommenders.internal.rcp.repo.ModelRepository;
import org.eclipse.recommenders.internal.rcp.repo.ModelRepositoryIndex;
import org.eclipse.recommenders.internal.rcp.repo.ServiceBasedProxySelector;
import org.eclipse.recommenders.internal.rcp.wiring.RepositoryUrlChangeListener;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.rcp.repo.IModelRepositoryIndex;
import org.eclipse.recommenders.rcp.repo.ModelRepositoryService;
import org.eclipse.recommenders.utils.Executors;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.ast.ASTNodeUtils;
import org.eclipse.recommenders.utils.rcp.ast.ASTStringUtils;
import org.eclipse.recommenders.utils.rcp.ast.BindingUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.sonatype.aether.repository.ProxySelector;

public class RecommendersModule
extends AbstractModule
implements Module {
    protected void configure() {
        this.configureJavaElementResolver();
        this.configureAstProvider();
        this.bindRepository();
        this.initalizeSingletonServices();
        this.bindShutdownListener();
    }

    @Singleton
    @Provides
    protected IClasspathEntryInfoProvider configurePackageFragmentRootInfoProvider(EventBus bus, IWorkspaceRoot workspace) {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        File stateLocation = new File(Platform.getStateLocation((Bundle)bundle).toFile(), "v0.5-package-root-infos.json");
        final ClasspathEntryInfoProvider cpeInfoProvider = new ClasspathEntryInfoProvider(stateLocation, workspace, bus);
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                try {
                    cpeInfoProvider.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        });
        bus.register((Object)cpeInfoProvider);
        return cpeInfoProvider;
    }

    private void configureJavaElementResolver() {
        this.bind(JavaElementResolver.class).in(Scopes.SINGLETON);
        this.requestStaticInjection(new Class[]{ASTStringUtils.class});
        this.requestStaticInjection(new Class[]{ASTNodeUtils.class});
        this.requestStaticInjection(new Class[]{BindingUtils.class});
    }

    private void configureAstProvider() {
        CachingAstProvider p = new CachingAstProvider();
        JavaCore.addElementChangedListener((IElementChangedListener)p);
        this.bind(IAstProvider.class).toInstance((Object)p);
    }

    private void bindRepository() {
        this.bind(RepositoryUrlChangeListener.class).asEagerSingleton();
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        File stateLocation = Platform.getStateLocation((Bundle)bundle).toFile();
        File repo = new File(stateLocation, "repository");
        repo.mkdirs();
        RecommendersPlugin plugin = RecommendersPlugin.getDefault();
        IPreferenceStore store = plugin.getPreferenceStore();
        String url = store.getString(RecommendersPlugin.P_REPOSITORY_URL);
        this.bind(File.class).annotatedWith(LocalModelRepositoryLocation.class).toInstance((Object)repo);
        this.bind(String.class).annotatedWith(RemoteModelRepositoryLocation.class).toInstance((Object)url);
        this.bind(IModelRepository.class).to(ModelRepository.class).in(Scopes.SINGLETON);
        File index = new File(stateLocation, "index");
        index.mkdirs();
        this.bind(File.class).annotatedWith(ModelRepositoryIndexLocation.class).toInstance((Object)index);
        this.bind(IModelRepositoryIndex.class).to(ModelRepositoryIndex.class).in(Scopes.SINGLETON);
        this.bind(ModelRepositoryService.class).asEagerSingleton();
    }

    private void bindShutdownListener() {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(final I i) {
                        if (i instanceof Closeable && i.getClass().isAnnotationPresent(AutoCloseOnWorkbenchShutdown.class)) {
                            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                                    try {
                                        ((Closeable)i).close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    return true;
                                }

                                public void postShutdown(IWorkbench workbench) {
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    private void initalizeSingletonServices() {
        this.bind(ServicesInitializer.class).asEagerSingleton();
    }

    @Singleton
    @Provides
    protected JavaModelEventsProvider provideJavaModelEventsProvider(EventBus bus, IWorkspaceRoot workspace) {
        JavaModelEventsProvider p = new JavaModelEventsProvider(bus, workspace);
        JavaCore.addElementChangedListener((IElementChangedListener)p);
        return p;
    }

    @Singleton
    @Provides
    protected EventBus provideWorkspaceEventBus() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor pool = Executors.coreThreadsTimoutExecutor((int)(numberOfCores + 1), (int)1, (String)"Recommenders-Bus-Thread-", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        AsyncEventBus bus = new AsyncEventBus("Code Recommenders asychronous Workspace Event Bus", (Executor)pool);
        return bus;
    }

    @Provides
    @Singleton
    protected JavaSelectionProvider provideJavaSelectionProvider(EventBus bus) {
        final JavaSelectionProvider provider = new JavaSelectionProvider(bus);
        new UIJob("Registering workbench selection listener."){
            {
                super($anonymous0);
                this.schedule();
            }

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow ww = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                ISelectionService service = (ISelectionService)ww.getService(ISelectionService.class);
                service.addPostSelectionListener((ISelectionListener)provider);
                return Status.OK_STATUS;
            }
        };
        return provider;
    }

    @Provides
    protected IWorkspaceRoot provideWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Provides
    protected ProxySelector provideProxyService() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        ServiceTracker tracker = new ServiceTracker(bundle.getBundleContext(), IProxyService.class.getName(), null);
        tracker.open();
        IProxyService service = (IProxyService)tracker.getService();
        tracker.close();
        return new ServiceBasedProxySelector(service);
    }

    @Provides
    protected IWorkspace provideWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    @Provides
    protected Display provideDisplay() {
        Display d = Display.getCurrent();
        if (d == null) {
            d = Display.getDefault();
        }
        return d;
    }

    @Provides
    protected IWorkbench provideWorkbench() {
        return PlatformUI.getWorkbench();
    }

    @Provides
    protected IWorkbenchPage provideActiveWorkbenchPage(IWorkbench wb) {
        if (this.isRunningInUiThread()) {
            return wb.getActiveWorkbenchWindow().getActivePage();
        }
        return this.runUiFinder().activePage;
    }

    private ActivePageFinder runUiFinder() {
        ActivePageFinder finder = new ActivePageFinder();
        try {
            if (this.isRunningInUiThread()) {
                finder.call();
            } else {
                FutureTask<IWorkbenchPage> task = new FutureTask<IWorkbenchPage>(finder);
                Display.getDefault().asyncExec(task);
                task.get(2L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            RecommendersPlugin.logError(e, "Could not run 'active page finder' that early!", new Object[0]);
        }
        return finder;
    }

    private boolean isRunningInUiThread() {
        return Display.getCurrent() != null;
    }

    @Provides
    protected IJavaModel provideJavaModel() {
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    @Provides
    protected JavaModelManager provideJavaModelManger() {
        return JavaModelManager.getJavaModelManager();
    }

    @Provides
    protected IExtensionRegistry provideRegistry() {
        return Platform.getExtensionRegistry();
    }

    private final class ActivePageFinder
    implements Callable<IWorkbenchPage> {
        private IWorkbench workbench;
        private IWorkbenchWindow activeWorkbenchWindow;
        private IWorkbenchPage activePage;

        private ActivePageFinder() {
        }

        @Override
        public IWorkbenchPage call() throws Exception {
            this.workbench = PlatformUI.getWorkbench();
            this.activeWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            this.activePage = this.activeWorkbenchWindow.getActivePage();
            return this.activePage;
        }
    }

    @BindingAnnotation
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AutoCloseOnWorkbenchShutdown {
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LocalModelRepositoryLocation {
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ModelRepositoryIndexLocation {
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteModelRepositoryLocation {
    }

    public static class ServicesInitializer {
        public final IClasspathEntryInfoProvider pgkInfoProvider;

        @Inject
        private ServicesInitializer(IModelRepository repo, IModelRepositoryIndex index, IAstProvider astProvider, JavaModelEventsProvider eventsProvider, JavaSelectionProvider selectionProvider, IClasspathEntryInfoProvider pgkInfoProvider) {
            this.pgkInfoProvider = pgkInfoProvider;
            index.open();
        }
    }
}

