/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.names;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.IVariableName;
import org.eclipse.recommenders.utils.names.VmMethodName;

public class VmVariableName
implements IVariableName {
    private static final long serialVersionUID = 5067244907255465328L;
    private static Map<String, VmVariableName> index = new MapMaker().weakValues().makeMap();
    private String identifier;

    public static synchronized VmVariableName get(String variableName) {
        VmVariableName res = index.get(variableName);
        if (res == null) {
            res = new VmVariableName(variableName);
            index.put(variableName, res);
        }
        return res;
    }

    protected VmVariableName(String vmVariableName) {
        this.identifier = vmVariableName;
        Checks.ensureIsNotNull(this.identifier);
        Checks.ensureIsNotNull(this.getDeclaringMethod());
    }

    @Override
    public String getName() {
        return StringUtils.substringAfterLast((String)this.identifier, (String)"#");
    }

    @Override
    public IMethodName getDeclaringMethod() {
        String declaringType = StringUtils.substringBeforeLast((String)this.identifier, (String)"#");
        return VmMethodName.get(declaringType);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public int compareTo(IVariableName other) {
        return this.identifier.compareTo(other.getIdentifier());
    }
}

