/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.sapphire.modeling.LoggingService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensionsLocator {
    protected static final String DEFAULT_PATH = "META-INF/sapphire-extension.xml";
    private static ExtensionsLocator instance;

    public static final synchronized ExtensionsLocator instance() {
        if (instance == null) {
            final ClassLoader cl = ExtensionsLocator.class.getClassLoader();
            Class<?> implClass = null;
            try {
                implClass = cl.loadClass("org.eclipse.sapphire.modeling.ExtensionsLocatorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (implClass != null) {
                try {
                    Factory factory = (Factory)implClass.newInstance();
                    if (factory.applicable()) {
                        instance = factory.create();
                    }
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            if (instance == null) {
                instance = new ExtensionsLocator(){

                    @Override
                    public List<Handle> find() {
                        ArrayList<1> handles = new ArrayList<1>();
                        try {
                            Enumeration<URL> urls = cl.getResources(ExtensionsLocator.DEFAULT_PATH);
                            while (urls.hasMoreElements()) {
                                final URL url = urls.nextElement();
                                if (url == null) continue;
                                Handle handle = new Handle(){

                                    @Override
                                    public URL extension() {
                                        return url;
                                    }

                                    @Override
                                    public URL findResource(String name) {
                                        return cl.getResource(name);
                                    }

                                    @Override
                                    public <T> Class<T> findClass(String name) {
                                        try {
                                            return cl.loadClass(name);
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            return null;
                                        }
                                    }
                                };
                                handles.add(handle);
                            }
                        }
                        catch (IOException e) {
                            LoggingService.log(e);
                        }
                        return Collections.unmodifiableList(handles);
                    }
                };
            }
        }
        return instance;
    }

    public abstract List<Handle> find();

    public static abstract class Factory {
        public abstract boolean applicable();

        public abstract ExtensionsLocator create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Handle {
        public abstract URL extension();

        public abstract URL findResource(String var1);

        public abstract <T> Class<T> findClass(String var1);
    }
}

