/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelMetadataItem;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.Image;
import org.eclipse.sapphire.modeling.annotations.Listeners;
import org.eclipse.sapphire.modeling.internal.MemoryResource;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.localization.LocalizationUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.ElementMetaModelServiceContext;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelElementType
extends ModelMetadataItem {
    private final Class<?> typeClass;
    private Class<?> implClass = null;
    private Constructor<?> implClassConstructor = null;
    private boolean implClassLoaded = false;
    private final List<ModelElementType> baseTypes;
    private final List<ModelProperty> properties;
    private final LocalizationService localizationService;
    private ImageData image;
    private boolean imageInitialized;
    private final ListenerContext listeners;
    private ServiceContext serviceContext;

    public ModelElementType(Class<?> typeClass) {
        this.typeClass = typeClass;
        this.properties = new ArrayList<ModelProperty>();
        this.localizationService = LocalizationSystem.service(this.typeClass);
        ReadOnlyListFactory<ModelElementType> baseTypesFactory = ReadOnlyListFactory.create();
        Class<?>[] classArray = this.typeClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> baseInterface = classArray[n2];
            ModelElementType baseType = ModelElementType.read(baseInterface, false);
            if (baseType != null) {
                baseTypesFactory.add(baseType);
            }
            ++n2;
        }
        this.baseTypes = baseTypesFactory.export();
        this.listeners = new ListenerContext();
        Listeners listenersAnnotation = this.getAnnotation(Listeners.class);
        if (listenersAnnotation != null) {
            Class<? extends Listener>[] classArray2 = listenersAnnotation.value();
            int n3 = classArray2.length;
            n = 0;
            while (n < n3) {
                Class<? extends Listener> cl = classArray2[n];
                try {
                    this.listeners.attach(cl.newInstance());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                ++n;
            }
        }
    }

    public static ModelElementType read(ClassLoader classLoader, String qualifiedTypeName) {
        try {
            return ModelElementType.read(classLoader.loadClass(qualifiedTypeName));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ModelElementType read(Class<?> modelElementClass) {
        return ModelElementType.read(modelElementClass, true);
    }

    public static ModelElementType read(Class<?> modelElementClass, boolean throwExceptionIfNotFound) {
        Field[] fieldArray = modelElementClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().equals("TYPE")) {
                try {
                    Object fieldValue = field.get(null);
                    if (!(fieldValue instanceof ModelElementType)) break;
                    return (ModelElementType)fieldValue;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++n2;
        }
        if (throwExceptionIfNotFound) {
            throw new IllegalArgumentException("Did not find TYPE field on " + modelElementClass.getName());
        }
        return null;
    }

    public Class<?> getModelElementClass() {
        return this.typeClass;
    }

    public String getSimpleName() {
        return this.typeClass.getSimpleName();
    }

    public String getQualifiedName() {
        return this.typeClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getImplClass() {
        ModelElementType modelElementType = this;
        synchronized (modelElementType) {
            if (!this.implClassLoaded) {
                this.implClassLoaded = true;
                String implClassQualifiedName = ModelElementType.getImplClassName(this.typeClass);
                if (implClassQualifiedName != null) {
                    try {
                        this.implClass = this.typeClass.getClassLoader().loadClass(implClassQualifiedName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    if (this.implClass != null) {
                        try {
                            this.implClassConstructor = this.implClass.getConstructor(IModelParticle.class, ModelProperty.class, Resource.class);
                        }
                        catch (NoSuchMethodException e) {
                            LoggingService.log(e);
                            this.implClass = null;
                        }
                    }
                }
            }
            return this.implClass;
        }
    }

    public static String getImplClassName(Class<?> elementTypeClass) {
        if (elementTypeClass == null) {
            throw new IllegalArgumentException();
        }
        return ModelElementType.getImplClassName(elementTypeClass.getName(), elementTypeClass.getAnnotation(GenerateImpl.class));
    }

    public static String getImplClassName(String elementTypeClassName, GenerateImpl generateImplAnnotation) {
        if (elementTypeClassName == null) {
            throw new IllegalArgumentException();
        }
        if (generateImplAnnotation != null) {
            return ModelElementType.getImplClassName(elementTypeClassName, generateImplAnnotation.packageName(), generateImplAnnotation.className());
        }
        return null;
    }

    public static String getImplClassName(String elementTypeClassName, String preferredImplPackageName, String preferredImplClassName) {
        if (elementTypeClassName == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder implClassQualifiedName = new StringBuilder();
        String elementTypePackageName = null;
        int lastDotSeparator = elementTypeClassName.lastIndexOf(46);
        if (lastDotSeparator != -1) {
            elementTypePackageName = elementTypeClassName.substring(0, lastDotSeparator);
        }
        if (preferredImplPackageName == null || preferredImplPackageName.length() == 0) {
            if (elementTypePackageName != null) {
                implClassQualifiedName.append(elementTypePackageName);
                implClassQualifiedName.append('.');
            }
            implClassQualifiedName.append("internal");
        } else {
            implClassQualifiedName.append(preferredImplPackageName);
        }
        implClassQualifiedName.append('.');
        if (preferredImplClassName == null || preferredImplClassName.length() == 0) {
            String simpleTypeClassName;
            String fullTypeClassName = elementTypePackageName == null ? elementTypeClassName : elementTypeClassName.substring(elementTypePackageName.length() + 1);
            int lastSeparator = fullTypeClassName.lastIndexOf(36);
            if (lastSeparator == -1) {
                simpleTypeClassName = fullTypeClassName;
            } else {
                int simpleTypeClassNameStart = lastSeparator + 1;
                implClassQualifiedName.append(fullTypeClassName.substring(0, simpleTypeClassNameStart));
                simpleTypeClassName = fullTypeClassName.substring(simpleTypeClassNameStart);
            }
            if (simpleTypeClassName.charAt(0) == 'I' && simpleTypeClassName.length() > 1 && Character.isUpperCase(simpleTypeClassName.charAt(1))) {
                implClassQualifiedName.append(simpleTypeClassName.substring(1));
            } else {
                implClassQualifiedName.append(simpleTypeClassName);
                implClassQualifiedName.append("Impl");
            }
        } else {
            implClassQualifiedName.append(preferredImplClassName);
        }
        return implClassQualifiedName.toString();
    }

    public <T extends IModelElement> T instantiate(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        this.getImplClass();
        if (this.implClassConstructor != null) {
            IModelElement element;
            try {
                element = (IModelElement)this.implClassConstructor.newInstance(parent, parentProperty, resource);
            }
            catch (Exception e) {
                String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
                throw new RuntimeException(msg, e);
            }
            return (T)element;
        }
        String msg = NLS.bind(Resources.cannotInstantiate, this.getSimpleName());
        throw new RuntimeException(msg);
    }

    public <T extends IModelElement> T instantiate(Resource resource) {
        return this.instantiate(null, null, resource);
    }

    public <T extends IModelElement> T instantiate() {
        return this.instantiate(null, null, new MemoryResource(this));
    }

    public List<ModelProperty> properties() {
        TreeMap<String, ModelProperty> properties = new TreeMap<String, ModelProperty>();
        Class<?>[] classArray = this.typeClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cl = classArray[n2];
            ModelElementType t = ModelElementType.read(cl, false);
            if (t != null) {
                for (ModelProperty property : t.properties()) {
                    properties.put(property.getName(), property);
                }
            }
            ++n2;
        }
        for (ModelProperty property : this.properties) {
            properties.put(property.getName(), property);
        }
        return new ArrayList<ModelProperty>(properties.values());
    }

    public <T extends ModelProperty> T property(String name) {
        for (ModelProperty property : this.properties()) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            return (T)property;
        }
        return null;
    }

    void addProperty(ModelProperty property) {
        this.properties.add(property);
    }

    @Override
    protected void initAnnotations(ReadOnlyListFactory<Annotation> annotations) {
        annotations.add((Annotation[])this.typeClass.getDeclaredAnnotations());
    }

    @Override
    public <A extends Annotation> List<A> getAnnotations(Class<A> type) {
        ReadOnlyListFactory<A> annotationsListFactory = ReadOnlyListFactory.create();
        annotationsListFactory.add((Collection<A>)super.getAnnotations(type));
        for (ModelElementType baseType : this.baseTypes) {
            annotationsListFactory.add((Collection<A>)baseType.getAnnotations(type));
        }
        return annotationsListFactory.export();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> type) {
        A annotation = super.getAnnotation(type);
        if (annotation == null) {
            for (ModelElementType baseType : this.baseTypes) {
                annotation = baseType.getAnnotation(type);
                if (annotation != null) break;
            }
        }
        return annotation;
    }

    public Class<?> findAnnotationHostClass(Annotation annotation) {
        if (this.typeClass.getAnnotation(annotation.annotationType()) == annotation) {
            return this.typeClass;
        }
        for (ModelElementType baseType : this.baseTypes) {
            Class<?> cl = baseType.findAnnotationHostClass(annotation);
            if (cl == null) continue;
            return cl;
        }
        return null;
    }

    @Override
    protected String getDefaultLabel() {
        String className = this.typeClass.getName();
        int start = className.lastIndexOf(46) + 1;
        int startPlusOne = start + 1;
        if (className.charAt(start) == 'I' && startPlusOne < className.length() && Character.isUpperCase(className.charAt(startPlusOne))) {
            start = startPlusOne;
        }
        if (start > 0) {
            className = className.substring(start);
        }
        return LocalizationUtil.transformCamelCaseToLabel(className);
    }

    @Override
    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public ImageData image() {
        if (!this.imageInitialized) {
            Image imageAnnotation = this.getAnnotation(Image.class);
            if (imageAnnotation != null) {
                try {
                    this.image = ImageData.createFromClassLoader(this.findAnnotationHostClass(imageAnnotation), imageAnnotation.path());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
            this.imageInitialized = true;
        }
        return this.image;
    }

    public final void attach(Listener listener) {
        this.listeners.attach(listener);
    }

    final void broadcast(Event event) {
        this.listeners.broadcast(event);
    }

    public <S extends Service> S service(Class<S> serviceType) {
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    public <S extends Service> List<S> services(Class<S> serviceType) {
        return this.services().services(serviceType);
    }

    public synchronized ServiceContext services() {
        if (this.serviceContext == null) {
            this.serviceContext = new ElementMetaModelServiceContext(this);
        }
        return this.serviceContext;
    }

    protected static abstract class ModelPropertyInitListener {
        protected ModelPropertyInitListener() {
        }

        public abstract void propertyInitialized(ModelProperty var1);
    }

    private static final class Resources
    extends NLS {
        public static String cannotInstantiate;

        static {
            Resources.initializeMessages(ModelElementType.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

