/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ResourceStore;

public final class SharedModelsCache {
    private static final Map<Object, SoftReference<IModelElement>> cache = new HashMap<Object, SoftReference<IModelElement>>();

    public static synchronized IModelElement retrieve(Object key) {
        SoftReference<IModelElement> cachedModelRef = cache.get(key);
        if (cachedModelRef != null) {
            Resource resource;
            IModelElement model = cachedModelRef.get();
            if (!(model == null || (resource = model.resource()) != null && resource.isOutOfDate())) {
                return model;
            }
            cache.remove(key);
        }
        return null;
    }

    public static synchronized void store(Object key, IModelElement modelElement) {
        cache.put(key, new SoftReference<IModelElement>(modelElement));
    }

    public static final class StandardKey {
        private final ResourceStore resourceStore;
        private final ModelElementType modelElementType;

        public StandardKey(ResourceStore resourceStore, ModelElementType modelElementType) {
            this.resourceStore = resourceStore;
            this.modelElementType = modelElementType;
        }

        public int hashCode() {
            return this.resourceStore.hashCode() ^ this.modelElementType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StandardKey) {
                StandardKey key = (StandardKey)obj;
                return this.resourceStore.equals(key.resourceStore) && this.modelElementType.equals(key.modelElementType);
            }
            return false;
        }
    }
}

