/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.StandardLocalizationService;

public class UrlResourceStore
extends ByteArrayResourceStore {
    private final URL url;
    private final URI uri;

    public UrlResourceStore(URL url) throws ResourceStoreException {
        URI uri = null;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {}
        this.url = url;
        this.uri = uri;
        try {
            InputStream in = this.url.openStream();
            try {
                this.setContents(in);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    public void validateSave() {
        throw new ValidateEditException();
    }

    public boolean equals(Object obj) {
        if (obj instanceof UrlResourceStore) {
            UrlResourceStore ums = (UrlResourceStore)obj;
            if (this.uri == null || ums.uri == null) {
                return this.url.toString().equals(ums.url.toString());
            }
            return this.uri.equals(ums.uri);
        }
        return false;
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : this.url.toString().hashCode();
    }

    protected LocalizationService initLocalizationService(Locale locale) {
        return new StandardLocalizationService(locale){

            @Override
            protected boolean load(Locale locale, Map<String, String> keyToText) {
                String origFileUrlString = UrlResourceStore.this.url.toString();
                int lastDot = origFileUrlString.lastIndexOf(46);
                if (lastDot != -1) {
                    boolean bl;
                    String resFileUrlString = origFileUrlString.substring(0, lastDot);
                    String localeString = locale.toString();
                    if (localeString.length() > 0) {
                        resFileUrlString = String.valueOf(resFileUrlString) + "_" + localeString;
                    }
                    resFileUrlString = String.valueOf(resFileUrlString) + ".properties";
                    URL resFileUrl = null;
                    try {
                        resFileUrl = new URL(resFileUrlString);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return false;
                    }
                    InputStream stream = resFileUrl.openStream();
                    try {
                        bl = 1.parse(stream, keyToText);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                    return bl;
                }
                return false;
            }
        };
    }
}

