/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.util.NLS;

public abstract class AggregateFunction
extends Function {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AggregateFunctionResult
    extends FunctionResult {
        private IModelElement lastListParentElement;
        private String lastListenerModelPath;
        private Listener listener;

        public AggregateFunctionResult(Function function, FunctionContext context) {
            super(function, context);
        }

        @Override
        protected final Object evaluate() {
            Object collection = this.operand(0).value();
            ArrayList<Object> items = new ArrayList<Object>();
            if (collection != null) {
                if (collection instanceof ModelElementList) {
                    ValueProperty listEntryProperty;
                    ModelElementList list = (ModelElementList)collection;
                    ListProperty listProperty = list.getParentProperty();
                    ModelElementType listEntryType = listProperty.getType();
                    if (this.operands().size() > 1) {
                        String listEntryPropertyName = this.cast(this.operand(1).value(), String.class);
                        Object t = listEntryType.property(listEntryPropertyName);
                        if (t == null) {
                            throw new FunctionException(NLS.bind(Resources.missingProperty, listEntryType.getSimpleName(), listEntryPropertyName));
                        }
                        if (!(t instanceof ValueProperty)) {
                            throw new FunctionException(NLS.bind(Resources.notValueProperty, listEntryType.getSimpleName(), listEntryPropertyName));
                        }
                        listEntryProperty = (ValueProperty)t;
                    } else {
                        ValueProperty prop = null;
                        for (ModelProperty modelProperty : listEntryType.properties()) {
                            if (!(modelProperty instanceof ValueProperty)) continue;
                            prop = (ValueProperty)modelProperty;
                            break;
                        }
                        if (prop == null) {
                            throw new FunctionException(NLS.bind(Resources.noValueProperties, listEntryType.getSimpleName()));
                        }
                        listEntryProperty = prop;
                    }
                    for (IModelElement item : list) {
                        items.add(item.read(listEntryProperty).getContent());
                    }
                    IModelElement listParentElement = list.parent();
                    String string = String.valueOf(listProperty.getName()) + "/" + listEntryProperty.getName();
                    if (this.lastListParentElement != listParentElement || !this.lastListenerModelPath.equals(string)) {
                        if (this.lastListParentElement != null) {
                            this.lastListParentElement.detach(this.listener, this.lastListenerModelPath);
                        }
                        this.lastListParentElement = listParentElement;
                        this.lastListenerModelPath = string;
                        if (this.listener == null) {
                            this.listener = new FilteredListener<PropertyContentEvent>(){

                                @Override
                                protected void handleTypedEvent(PropertyContentEvent event) {
                                    AggregateFunctionResult.this.refresh();
                                }
                            };
                        }
                        listParentElement.attach(this.listener, string);
                    }
                } else if (collection instanceof Object[]) {
                    Object[] objectArray = (Object[])collection;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object item = objectArray[n2];
                        items.add(item);
                        ++n2;
                    }
                } else if (collection instanceof Collection) {
                    items.addAll((Collection)collection);
                }
            }
            return this.evaluate(items);
        }

        protected abstract Object evaluate(List<Object> var1);

        @Override
        public void dispose() {
            super.dispose();
            if (this.lastListParentElement != null) {
                this.lastListParentElement.detach(this.listener, this.lastListenerModelPath);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String missingProperty;
        public static String notValueProperty;
        public static String noValueProperties;

        static {
            Resources.initializeMessages(AggregateFunction.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

