/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.sapphire.modeling.el.AggregateFunction;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;

public final class MinFunction
extends AggregateFunction {
    public String name() {
        return "Min";
    }

    public final FunctionResult evaluate(FunctionContext context) {
        return new AggregateFunction.AggregateFunctionResult(this, context){

            @Override
            protected Object evaluate(List<Object> items) {
                BigDecimal min = null;
                for (Object item : items) {
                    if (item == null) continue;
                    BigDecimal itemAsDecimal = this.cast(item, BigDecimal.class);
                    if (min == null) {
                        min = itemAsDecimal;
                        continue;
                    }
                    if (itemAsDecimal.compareTo(min) >= 0) continue;
                    min = itemAsDecimal;
                }
                return min;
            }
        };
    }
}

