/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.util.MiscUtil;

public final class PropertyAccessFunction
extends Function {
    public static PropertyAccessFunction create(Function element, Function property) {
        PropertyAccessFunction literal = new PropertyAccessFunction();
        literal.init(element, property);
        return literal;
    }

    public static PropertyAccessFunction create(Function element, String property) {
        return PropertyAccessFunction.create(element, Literal.create(property));
    }

    public static PropertyAccessFunction create(Function property) {
        PropertyAccessFunction literal = new PropertyAccessFunction();
        literal.init(property);
        return literal;
    }

    public static PropertyAccessFunction create(String property) {
        return PropertyAccessFunction.create(Literal.create(property));
    }

    public String name() {
        return ".";
    }

    public boolean operator() {
        return true;
    }

    public int precedence() {
        return 1;
    }

    public FunctionResult evaluate(final FunctionContext context) {
        return new FunctionResult(this, context){
            private Object lastElement;
            private String lastPropertyName;
            private FunctionResult lastPropertyValueResult;
            private Listener lastPropertyValueListener;

            protected void init() {
                super.init();
                this.lastPropertyValueListener = new Listener(){

                    public void handle(Event event) {
                        this.refresh();
                    }
                };
            }

            protected Object evaluate() {
                String property;
                Object element;
                if (this.operands().size() == 1) {
                    element = context;
                    property = this.cast(this.operand(0).value(), String.class);
                } else {
                    element = this.operand(0).value();
                    property = this.cast(this.operand(1).value(), String.class);
                }
                if (!(this.lastPropertyValueResult == null || this.lastElement == element && MiscUtil.equal(this.lastPropertyName, property))) {
                    this.lastElement = null;
                    this.lastPropertyName = null;
                    this.lastPropertyValueResult.dispose();
                    this.lastPropertyValueResult = null;
                }
                if (property != null && this.lastPropertyName == null) {
                    this.lastElement = element;
                    this.lastPropertyName = property;
                    this.lastPropertyValueResult = this.context().property(element, property);
                    this.lastPropertyValueResult.attach(this.lastPropertyValueListener);
                }
                return this.lastPropertyValueResult == null ? null : this.lastPropertyValueResult.value();
            }

            public void dispose() {
                super.dispose();
                if (this.lastPropertyValueResult != null) {
                    this.lastPropertyValueResult.dispose();
                }
            }
        };
    }

    public void toString(StringBuilder buf, boolean topLevel) {
        if (this.operands().size() == 1) {
            buf.append((String)((Literal)this.operand(0)).value());
        } else {
            this.operand(0).toString(buf, false);
            Function p = this.operand(1);
            if (p instanceof Literal) {
                buf.append('.');
                ((Literal)p).toString(buf, false);
            } else {
                buf.append("[ ");
                p.toString(buf, false);
                buf.append(" ]");
            }
        }
    }
}

