/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.util.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.NamedValues;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DefaultValueService;

public class SapphireCommonUtil {
    public static final String getDefaultValueLabel(IModelElement element, ValueProperty property) {
        String defaultValue;
        DefaultValueService defaultValueService = element.service(property, DefaultValueService.class);
        if (defaultValueService != null && (defaultValue = defaultValueService.value()) != null) {
            return SapphireCommonUtil.getValueLabel(element, property, defaultValue);
        }
        return null;
    }

    public static final String getValueLabel(IModelElement element, ValueProperty property, String value) {
        String valueLabel = value;
        if (property.isOfType(Enum.class)) {
            EnumValueType enumValueType = new EnumValueType(property.getTypeClass());
            Enum<?>[] enumArray = enumValueType.getItems();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum<?> item = enumArray[n2];
                if (item.toString().equals(value)) {
                    valueLabel = enumValueType.getLabel(item, true, CapitalizationType.NO_CAPS, false);
                    break;
                }
                ++n2;
            }
        } else {
            ValueKeyword keyword = property.getKeyword(value);
            if (keyword != null) {
                valueLabel = keyword.toDisplayString();
            } else if (property.hasAnnotation(NamedValues.class)) {
                LocalizationService localization = property.getLocalizationService();
                NamedValues.NamedValue[] namedValueArray = property.getAnnotation(NamedValues.class).namedValues();
                int n = namedValueArray.length;
                int n3 = 0;
                while (n3 < n) {
                    NamedValues.NamedValue x = namedValueArray[n3];
                    if (value.equals(x.value())) {
                        String namedValueLabel = localization.text(x.label(), CapitalizationType.NO_CAPS, false);
                        valueLabel = String.valueOf(namedValueLabel) + " (" + x.value() + ")";
                        break;
                    }
                    ++n3;
                }
            }
        }
        if (!(property.isOfType(Integer.class) || property.isOfType(Long.class) || property.isOfType(Float.class) || property.isOfType(Double.class) || property.isOfType(BigInteger.class) || property.isOfType(BigDecimal.class) || property.isOfType(Boolean.class))) {
            valueLabel = "\"" + valueLabel + "\"";
        }
        return valueLabel;
    }

    public static final String normalizeForDisplay(ValueProperty property, String value) {
        String result = property.encodeKeywords(property.decodeKeywords(value));
        ValueKeyword keyword = property.getKeyword(result);
        if (keyword != null) {
            result = keyword.toDisplayString();
        }
        return result;
    }
}

