/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.sapphire.modeling.Path;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.services.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelativePathService
extends Service {
    public abstract List<Path> roots();

    public boolean enclosed() {
        return true;
    }

    public Path convertToRelative(Path path) {
        block4: {
            if (path == null) break block4;
            if (this.enclosed()) {
                for (Path root : this.roots()) {
                    if (!root.isPrefixOf(path)) continue;
                    return path.makeRelativeTo(root);
                }
            } else {
                String pathDevice = path.getDevice();
                for (Path root : this.roots()) {
                    if (!MiscUtil.equal(pathDevice, root.getDevice())) continue;
                    return path.makeRelativeTo(root);
                }
            }
        }
        return null;
    }

    public final Path convertToRelative(String path) {
        if (path != null) {
            return this.convertToRelative(new Path(path));
        }
        return null;
    }

    public Path convertToAbsolute(Path path) {
        if (path != null) {
            if (this.enclosed() && path.segmentCount() > 0 && path.segment(0).equals("..")) {
                return null;
            }
            Path absolute = null;
            for (Path root : this.roots()) {
                try {
                    File file = root.append(path).toFile().getCanonicalFile();
                    absolute = new Path(file.getPath());
                    if (!file.exists()) continue;
                    break;
                }
                catch (IOException iOException) {}
            }
            return absolute;
        }
        return null;
    }

    public final Path convertToAbsolute(String path) {
        if (path != null) {
            return this.convertToAbsolute(new Path(path));
        }
        return null;
    }
}

