/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.CountConstraint;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class CountConstraintValidationService
extends ValidationService {
    private CountConstraint constraint;

    protected void init() {
        super.init();
        this.constraint = this.context(ModelProperty.class).getAnnotation(CountConstraint.class);
    }

    public Status validate() {
        ModelElementList list = (ModelElementList)this.context(IModelElement.class).read(this.context(ModelProperty.class));
        int count = list.size();
        String message = null;
        if (count < this.constraint.min()) {
            message = this.constraint.min() == 1 ? Resources.bind(Resources.countConstraintTooFewAtLeastOne, this.context(ModelProperty.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false)) : Resources.bind(Resources.countConstraintTooFew, this.context(ModelProperty.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false), String.valueOf(this.constraint.min()));
        } else if (count > this.constraint.max()) {
            message = Resources.bind(Resources.countConstraintTooMany, this.context(ModelProperty.class).getType().getLabel(true, CapitalizationType.NO_CAPS, false), String.valueOf(this.constraint.max()));
        }
        if (message == null) {
            return Status.createOkStatus();
        }
        return Status.createErrorStatus(message);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ListProperty property = context.find(ListProperty.class);
            return property != null && property.hasAnnotation(CountConstraint.class);
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new CountConstraintValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String countConstraintTooFew;
        public static String countConstraintTooFewAtLeastOne;
        public static String countConstraintTooMany;

        static {
            Resources.initializeMessages(CountConstraintValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

