/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.localization.LocalizationSystem;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ValidationService;

public final class MalformedValueValidationService
extends ValidationService {
    private String valueTypeName;

    public Status validate() {
        Value value = this.context(IModelElement.class).read(this.context(ValueProperty.class));
        if (value.isMalformed()) {
            if (this.valueTypeName == null) {
                Class<?> type = value.getProperty().getTypeClass();
                this.valueTypeName = LocalizationSystem.service(type).label(type, CapitalizationType.NO_CAPS, false);
            }
            String msg = NLS.bind(Resources.cannotParseValueMessage, this.valueTypeName, value.getText());
            return Status.createErrorStatus(msg);
        }
        return Status.createOkStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && !String.class.isAssignableFrom(property.getTypeClass());
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new MalformedValueValidationService();
        }
    }

    private static final class Resources
    extends NLS {
        public static String cannotParseValueMessage;

        static {
            Resources.initializeMessages(MalformedValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

