/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.PossibleValues;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.PossibleValuesService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PossibleValuesServiceFactory
extends ServiceFactory {
    @Override
    public boolean applicable(ServiceContext context, Class<? extends Service> service) {
        ValueProperty property = context.find(ValueProperty.class);
        return property != null && property.hasAnnotation(PossibleValues.class);
    }

    @Override
    public Service create(ServiceContext context, Class<? extends Service> service) {
        PossibleValuesServiceExt svc = null;
        PossibleValues annotation = context.find(ValueProperty.class).getAnnotation(PossibleValues.class);
        if (annotation != null) {
            if (annotation.values().length > 0) {
                svc = new PossibleValuesServiceStatic(annotation.values(), annotation.invalidValueMessage(), annotation.invalidValueSeverity(), annotation.caseSensitive());
            }
            if (svc == null && annotation.property().length() > 0) {
                svc = new PossibleValuesServiceFromModel(new ModelPath(annotation.property()), annotation.invalidValueMessage(), annotation.invalidValueSeverity(), annotation.caseSensitive());
            }
        }
        return svc;
    }

    private static abstract class PossibleValuesServiceExt
    extends PossibleValuesService {
        private final String invalidValueMessageTemplate;
        private final Status.Severity invalidValueSeverity;
        private final boolean caseSensitive;

        public PossibleValuesServiceExt(String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
            this.invalidValueMessageTemplate = invalidValueMessageTemplate == null || invalidValueMessageTemplate.length() == 0 ? null : invalidValueMessageTemplate;
            this.invalidValueSeverity = invalidValueSeverity;
            this.caseSensitive = caseSensitive;
        }

        public String getInvalidValueMessage(String invalidValue) {
            if (this.invalidValueMessageTemplate == null) {
                return super.getInvalidValueMessage(invalidValue);
            }
            return NLS.bind(this.invalidValueMessageTemplate, invalidValue);
        }

        public Status.Severity getInvalidValueSeverity(String invalidValue) {
            return this.invalidValueSeverity;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PossibleValuesServiceFromModel
    extends PossibleValuesServiceExt {
        private final ModelPath path;
        private Set<String> values;

        public PossibleValuesServiceFromModel(ModelPath path, String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
            super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
            this.path = path;
            this.values = Collections.emptySet();
        }

        @Override
        protected void init() {
            super.init();
            final IModelElement element = this.context(IModelElement.class);
            final FilteredListener<PropertyContentEvent> listener = new FilteredListener<PropertyContentEvent>(){

                @Override
                protected void handleTypedEvent(PropertyContentEvent event) {
                    PossibleValuesServiceFromModel.this.refresh();
                }
            };
            element.attach((Listener)listener, this.path);
            this.refresh();
            element.attach(new FilteredListener<ElementDisposeEvent>(){

                @Override
                protected void handleTypedEvent(ElementDisposeEvent event) {
                    element.detach(listener, PossibleValuesServiceFromModel.this.path);
                }
            });
        }

        @Override
        protected void fillPossibleValues(SortedSet<String> values) {
            values.addAll(this.values);
        }

        private void refresh() {
            SortedSet<String> newValues = this.context(IModelElement.class).read(this.path);
            if (!this.values.equals(newValues)) {
                this.values = Collections.unmodifiableSet(newValues);
                this.broadcast();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PossibleValuesServiceStatic
    extends PossibleValuesServiceExt {
        private final List<String> values;

        public PossibleValuesServiceStatic(String[] values, String invalidValueMessageTemplate, Status.Severity invalidValueSeverity, boolean caseSensitive) {
            super(invalidValueMessageTemplate, invalidValueSeverity, caseSensitive);
            ArrayList<String> list = new ArrayList<String>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item != null) {
                    list.add(item);
                }
                ++n2;
            }
            this.values = Collections.unmodifiableList(list);
        }

        @Override
        protected void fillPossibleValues(SortedSet<String> values) {
            values.addAll(this.values);
        }
    }
}

