/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.annotations.DefaultValue;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.DefaultValueService;
import org.eclipse.sapphire.services.DefaultValueServiceData;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;

public final class StandardDefaultValueService
extends DefaultValueService {
    private FunctionResult functionResult;

    protected void initDefaultValueService() {
        String expr;
        DefaultValue annotation = this.context(ModelProperty.class).getAnnotation(DefaultValue.class);
        if (annotation != null && (expr = annotation.text()).length() > 0) {
            Function function = null;
            try {
                function = ExpressionLanguageParser.parse(expr);
            }
            catch (Exception e) {
                LoggingService.log(e);
                function = null;
            }
            if (function != null) {
                function = FailSafeFunction.create(function, Literal.create(String.class));
                ModelElementFunctionContext context = new ModelElementFunctionContext(this.context(IModelElement.class));
                this.functionResult = function.evaluate(context);
                Listener listener = new Listener(){

                    public void handle(Event event) {
                        StandardDefaultValueService.this.refresh();
                    }
                };
                this.functionResult.attach(listener);
            }
        }
    }

    protected DefaultValueServiceData compute() {
        if (this.functionResult == null) {
            return new DefaultValueServiceData(null);
        }
        return new DefaultValueServiceData((String)this.functionResult.value());
    }

    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                LoggingService.log(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Factory
    extends ServiceFactory {
        @Override
        public boolean applicable(ServiceContext context, Class<? extends Service> service) {
            DefaultValue annotation;
            ModelProperty property = context.find(ModelProperty.class);
            return property != null && (annotation = property.getAnnotation(DefaultValue.class)) != null && annotation.text().length() > 0;
        }

        @Override
        public Service create(ServiceContext context, Class<? extends Service> service) {
            return new StandardDefaultValueService();
        }
    }
}

