/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.util;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <E> E findPrecedingItem(List<E> list, E item) {
        E lastSeenItem = null;
        for (E x : list) {
            if (x == item) {
                return lastSeenItem;
            }
            lastSeenItem = x;
        }
        return null;
    }

    public static <E> E findTrailingItem(List<E> list, E item) {
        boolean takeNextItem = false;
        for (E x : list) {
            if (takeNextItem) {
                return x;
            }
            if (x != item) continue;
            takeNextItem = true;
        }
        return null;
    }

    public static <T> boolean equalsBasedOnEntryIdentity(List<T> a, List<T> b) {
        int bSize;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int aSize = a.size();
        if (aSize == (bSize = b.size())) {
            int i = 0;
            while (i < aSize) {
                if (a.get(i) != b.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

