/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal.util;

import org.eclipse.sapphire.sdk.build.processor.internal.util.AccessModifier;
import org.eclipse.sapphire.sdk.build.processor.internal.util.BaseModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.IndentingPrintWriter;
import org.eclipse.sapphire.sdk.build.processor.internal.util.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldModel
extends BaseModel {
    private String name;
    private TypeReference type;
    private AccessModifier accessModifier = AccessModifier.PRIVATE;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private Object value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeReference getType() {
        return this.type;
    }

    public void setType(TypeReference type) {
        this.type = type;
    }

    public void setType(Class<?> type) {
        this.setType(new TypeReference(type.getName()));
    }

    public AccessModifier getAccessModifier() {
        return this.accessModifier;
    }

    public void setAccessModifier(AccessModifier accessModifier) {
        this.accessModifier = accessModifier;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public void write(IndentingPrintWriter pw) {
        this.accessModifier.write(pw);
        if (this.isStatic) {
            pw.print("static ");
        }
        if (this.isFinal) {
            pw.print("final ");
        }
        pw.print(this.type.getSimpleName());
        pw.print(' ');
        pw.print(this.name);
        if (this.value != null) {
            pw.print(" = ");
            pw.print(this.value);
        }
        pw.print(';');
        pw.println();
    }
}

