/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireAction;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.SapphireActionHandlerFactory;
import org.eclipse.sapphire.ui.SapphireActionHandlerFilter;
import org.eclipse.sapphire.ui.SapphireActionLocationHint;
import org.eclipse.sapphire.ui.SapphireCondition;
import org.eclipse.sapphire.ui.SapphireExtensionSystem;
import org.eclipse.sapphire.ui.def.ActionContextRef;
import org.eclipse.sapphire.ui.def.ActionContextsHostDef;
import org.eclipse.sapphire.ui.def.ActionDef;
import org.eclipse.sapphire.ui.def.ActionHandlerDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFactoryDef;
import org.eclipse.sapphire.ui.def.ActionHandlerFilterDef;
import org.eclipse.sapphire.ui.def.ISapphireConditionHostDef;
import org.eclipse.sapphire.ui.def.PartDef;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;
import org.eclipse.sapphire.ui.util.TopologicalSorter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireActionGroup {
    private final ISapphirePart part;
    private final String context;
    private final List<SapphireAction> actions;

    public SapphireActionGroup(ISapphirePart part, String context) {
        this.part = part;
        this.context = context;
        this.actions = new CopyOnWriteArrayList<SapphireAction>();
        PartDef partDef = this.part.definition();
        this.createActions(SapphireExtensionSystem.getActions());
        if (partDef != null) {
            this.createActions((List<ActionDef>)partDef.getActions());
        }
        this.createActionHandlers(SapphireExtensionSystem.getActionHandlers());
        this.createActionHandlersFromFactories(SapphireExtensionSystem.getActionHandlerFactories());
        if (partDef != null) {
            this.createActionHandlers((List<ActionHandlerDef>)partDef.getActionHandlers());
            this.createActionHandlersFromFactories((List<ActionHandlerFactoryDef>)partDef.getActionHandlerFactories());
            this.createActionHandlerFilters((List<ActionHandlerFilterDef>)partDef.getActionHandlerFilters());
        }
    }

    public ISapphirePart getPart() {
        return this.part;
    }

    public String getContext() {
        return this.context;
    }

    public List<SapphireAction> getActiveActions() {
        TopologicalSorter<SapphireAction> sorter = new TopologicalSorter<SapphireAction>();
        for (SapphireAction action : this.actions) {
            if (!action.hasActiveHandlers()) continue;
            TopologicalSorter.Entity actionEntity = sorter.entity(action.getId(), action);
            for (SapphireActionLocationHint locationHint : action.getLocationHints()) {
                actionEntity.constraint(locationHint.toString());
            }
        }
        return Collections.unmodifiableList(sorter.sort());
    }

    public List<SapphireAction> getActions() {
        LinkedHashMap<String, ArrayList<SapphireAction>> buckets = new LinkedHashMap<String, ArrayList<SapphireAction>>();
        for (SapphireAction action : this.actions) {
            String group = MiscUtil.normalizeToEmptyString((String)action.getGroup());
            ArrayList<SapphireAction> bucket = (ArrayList<SapphireAction>)buckets.get(group);
            if (bucket == null) {
                bucket = new ArrayList<SapphireAction>();
                buckets.put(group, bucket);
            }
            bucket.add(action);
        }
        TopologicalSorter<SapphireAction> sorter = new TopologicalSorter<SapphireAction>();
        for (List bucket : buckets.values()) {
            for (SapphireAction action : bucket) {
                TopologicalSorter.Entity actionEntity = sorter.entity(action.getId(), action);
                for (SapphireActionLocationHint locationHint : action.getLocationHints()) {
                    actionEntity.constraint(locationHint.toString());
                }
            }
        }
        return Collections.unmodifiableList(sorter.sort());
    }

    public void addAction(SapphireAction action) {
        this.actions.add(action);
    }

    public void removeAction(SapphireAction action) {
        this.actions.remove(action);
    }

    public SapphireAction getAction(String id) {
        for (SapphireAction action : this.actions) {
            if (!id.equalsIgnoreCase(action.getId())) continue;
            return action;
        }
        return null;
    }

    public boolean isEmpty() {
        for (SapphireAction action : this.actions) {
            if (!action.hasActiveHandlers()) continue;
            return false;
        }
        return true;
    }

    public void addFilter(SapphireActionHandlerFilter filter) {
        for (SapphireAction action : this.actions) {
            action.addFilter(filter);
        }
    }

    public void removeFilter(SapphireActionHandlerFilter filter) {
        for (SapphireAction action : this.actions) {
            action.removeFilter(filter);
        }
    }

    public void dispose() {
        for (SapphireAction action : this.actions) {
            action.dispose();
        }
    }

    private void createActions(List<ActionDef> defs) {
        for (ActionDef def : defs) {
            if (!this.isForContext(def) || !this.checkCondition(def)) continue;
            SapphireAction action = new SapphireAction();
            action.init(this, def);
            this.addAction(action);
        }
    }

    private void createActionHandlers(List<ActionHandlerDef> defs) {
        for (ActionHandlerDef def : defs) {
            SapphireAction action = this.getAction((String)def.getAction().getContent());
            if (action == null || !this.isForContext(def) || !this.checkCondition(def)) continue;
            try {
                Class implClass;
                JavaType implType = (JavaType)def.getImplClass().resolve();
                if (implType == null || (implClass = implType.artifact()) == null) continue;
                SapphireActionHandler handler = (SapphireActionHandler)implClass.newInstance();
                handler.init(action, def);
                action.addHandler(handler);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private void createActionHandlersFromFactories(List<ActionHandlerFactoryDef> defs) {
        for (ActionHandlerFactoryDef def : defs) {
            SapphireAction action = this.getAction((String)def.getAction().getContent());
            if (action == null || !this.isForContext(def) || !this.checkCondition(def)) continue;
            try {
                Class implClass;
                JavaType implType = (JavaType)def.getImplClass().resolve();
                if (implType == null || (implClass = implType.artifact()) == null) continue;
                SapphireActionHandlerFactory factory = (SapphireActionHandlerFactory)implClass.newInstance();
                factory.init(action, def);
                action.addHandlerFactory(factory);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    private void createActionHandlerFilters(List<ActionHandlerFilterDef> defs) {
        for (ActionHandlerFilterDef def : defs) {
            if (!this.isForContext(def)) continue;
            try {
                JavaType implClass = (JavaType)def.getImplClass().resolve();
                if (implClass == null) continue;
                SapphireActionHandlerFilter filter = (SapphireActionHandlerFilter)implClass.artifact().newInstance();
                this.addFilter(filter);
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkCondition(ISapphireConditionHostDef def) {
        SapphireCondition condition;
        Class conditionClass;
        JavaType conditionType = (JavaType)def.getConditionClass().resolve();
        if (conditionType == null || (conditionClass = conditionType.artifact()) == null || (condition = SapphireCondition.create(this.part, conditionClass, null)) == null) return true;
        try {
            boolean bl = condition.getConditionState();
            condition.dispose();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                condition.dispose();
                throw throwable;
            }
            catch (Exception e) {
                SapphireUiFrameworkPlugin.log(e);
                return false;
            }
        }
    }

    private boolean isForContext(ActionContextsHostDef def) {
        if (!def.getContexts().isEmpty()) {
            for (ActionContextRef ctxt : def.getContexts()) {
                if (!this.context.equalsIgnoreCase((String)ctxt.getContext().getContent())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

