/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.internal.SapphireUiFrameworkPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SapphireCondition {
    private ISapphirePart part;
    private boolean conditionState;
    private final ListenerContext listeners = new ListenerContext();

    public static SapphireCondition create(ISapphirePart part, Class<?> conditionClass, String conditionParameter) {
        try {
            SapphireCondition condition = (SapphireCondition)conditionClass.newInstance();
            condition.init(part, conditionParameter);
            return condition;
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return null;
        }
    }

    public final void init(ISapphirePart part, String parameter) {
        this.part = part;
        this.initCondition(part, parameter);
        this.updateConditionState();
    }

    protected void initCondition(ISapphirePart part, String parameter) {
    }

    public final ISapphirePart getPart() {
        return this.part;
    }

    protected abstract boolean evaluate();

    public final boolean getConditionState() {
        return this.conditionState;
    }

    protected final void updateConditionState() {
        boolean newConditionState;
        try {
            newConditionState = this.evaluate();
        }
        catch (Exception e) {
            SapphireUiFrameworkPlugin.log(e);
            return;
        }
        if (this.conditionState != newConditionState) {
            this.conditionState = newConditionState;
            this.listeners.broadcast();
        }
    }

    public void dispose() {
    }

    public final void attach(Listener listener) {
        this.listeners.attach(listener);
    }

    public final void detach(Listener listener) {
        this.listeners.detach(listener);
    }
}

