/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeName;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;
import org.eclipse.sapphire.ui.def.ServiceDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceDefImpl
extends ModelElement
implements ServiceDef {
    private ReferenceValue<JavaTypeName, JavaType> pImplementation;
    private ModelElementList<ServiceDef.Override> pOverrides;

    public ServiceDefImpl(IModelParticle parent, ModelProperty parentProperty, Resource resource) {
        super(TYPE, parent, parentProperty, resource);
    }

    public ServiceDefImpl(Resource resource) {
        super(TYPE, null, null, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReferenceValue<JavaTypeName, JavaType> getImplementation() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pImplementation == null) {
                this.refresh((ModelProperty)PROP_IMPLEMENTATION, true);
            }
            return this.pImplementation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImplementation(String value) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (value != null && value.equals("")) {
                value = null;
            }
            value = PROP_IMPLEMENTATION.decodeKeywords(value);
            value = ((ValueNormalizationService)this.service((ModelProperty)PROP_IMPLEMENTATION, ValueNormalizationService.class)).normalize(value);
            this.refresh((ModelProperty)PROP_IMPLEMENTATION, true);
            if (!ServiceDefImpl.equal((String)this.pImplementation.getText(false), (String)value)) {
                this.resource().binding(PROP_IMPLEMENTATION).write(value);
                this.refresh((ModelProperty)PROP_IMPLEMENTATION, false);
            }
        }
    }

    @Override
    public void setImplementation(JavaTypeName value) {
        this.setImplementation(value != null ? ((ValueSerializationMasterService)this.service((ModelProperty)PROP_IMPLEMENTATION, ValueSerializationMasterService.class)).encode((Object)value) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelElementList<ServiceDef.Override> getOverrides() {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            if (this.pOverrides == null) {
                this.refresh((ModelProperty)PROP_OVERRIDES, true);
            }
            return this.pOverrides;
        }
    }

    protected void disposeProperties() {
        if (this.pOverrides != null) {
            for (IModelElement element : this.pOverrides) {
                element.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperty(ModelProperty property, boolean force) {
        IModelParticle iModelParticle = this.root();
        synchronized (iModelParticle) {
            property = property.refine((IModelElement)this);
            if (property == PROP_IMPLEMENTATION) {
                if (this.pImplementation != null || force) {
                    ReferenceValue<JavaTypeName, JavaType> oldValue = this.pImplementation;
                    String val = this.resource().binding(PROP_IMPLEMENTATION).read();
                    this.pImplementation = new ReferenceValue((IModelElement)this, PROP_IMPLEMENTATION, ((ValueNormalizationService)this.service((ModelProperty)PROP_IMPLEMENTATION, ValueNormalizationService.class)).normalize(PROP_IMPLEMENTATION.encodeKeywords(val)));
                    this.pImplementation.init();
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_IMPLEMENTATION);
                    if (oldValue == null) {
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_IMPLEMENTATION));
                    } else {
                        if (this.pImplementation.equals(oldValue)) {
                            this.pImplementation = oldValue;
                        } else {
                            if (!ServiceDefImpl.equal((String)this.pImplementation.getText(false), (String)oldValue.getText(false)) || !ServiceDefImpl.equal((String)this.pImplementation.getDefaultText(), (String)oldValue.getDefaultText())) {
                                this.broadcast((Event)new PropertyContentEvent((IModelElement)this, (ModelProperty)PROP_IMPLEMENTATION));
                            }
                            if (!this.pImplementation.validation().equals((Object)oldValue.validation())) {
                                this.broadcast((Event)new PropertyValidationEvent((IModelElement)this, (ModelProperty)PROP_IMPLEMENTATION, oldValue.validation(), this.pImplementation.validation()));
                            }
                        }
                        if (enablementRefreshResult.changed()) {
                            this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_IMPLEMENTATION, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                        }
                    }
                }
            } else if (property == PROP_OVERRIDES) {
                if (this.pOverrides == null) {
                    if (force) {
                        this.pOverrides = new ModelElementList((IModelElement)this, PROP_OVERRIDES);
                        ListBindingImpl binding = this.resource().binding(PROP_OVERRIDES);
                        this.pOverrides.init(binding);
                        this.refreshPropertyEnablement((ModelProperty)PROP_OVERRIDES);
                        this.broadcast((Event)new PropertyInitializationEvent((IModelElement)this, (ModelProperty)PROP_OVERRIDES));
                    }
                } else {
                    ModelElement.EnablementRefreshResult enablementRefreshResult = this.refreshPropertyEnablement((ModelProperty)PROP_OVERRIDES);
                    boolean notified = this.pOverrides.refresh();
                    if (!notified && enablementRefreshResult.changed()) {
                        this.broadcast((Event)new PropertyEnablementEvent((IModelElement)this, (ModelProperty)PROP_OVERRIDES, enablementRefreshResult.before().booleanValue(), enablementRefreshResult.after()));
                    }
                }
            }
        }
    }

    public Object read(ModelProperty property) {
        if ((property = property.refine((IModelElement)this)) == PROP_IMPLEMENTATION) {
            return this.getImplementation();
        }
        if (property == PROP_OVERRIDES) {
            return this.getOverrides();
        }
        return super.read(property);
    }

    public void write(ValueProperty property, Object value) {
        if ((property = (ValueProperty)property.refine((IModelElement)this)) == PROP_IMPLEMENTATION) {
            if (!(value instanceof String)) {
                this.setImplementation((JavaTypeName)value);
            } else {
                this.setImplementation((String)value);
            }
            return;
        }
        super.write(property, value);
    }
}

