/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.internal.tripledes;

public final class TripleDES {
    private DESKey k1;
    private DESKey k2;
    private DESKey k3;

    public TripleDES(byte[] key192Bit) {
        if (key192Bit.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Creating a zero-length triple-DES key");
        }
        if (key192Bit.length < 24) {
            byte[] k = new byte[24];
            int i = 0;
            while (i < 24) {
                System.arraycopy(key192Bit, 0, k, i, Math.min(key192Bit.length, 24 - i));
                i += key192Bit.length;
            }
            key192Bit = k;
        }
        this.k1 = new DESKey(TripleDES.makeLong(key192Bit, 0, 8));
        this.k2 = new DESKey(TripleDES.makeLong(key192Bit, 8, 8));
        this.k3 = new DESKey(TripleDES.makeLong(key192Bit, 16, 8));
    }

    public byte[] encrypt(byte[] plain) {
        if (plain == null || plain.length == 0) {
            return new byte[0];
        }
        int len = plain.length;
        byte[] cipher = new byte[(len + this.plainBlockSize() - 1) / this.plainBlockSize() * this.plainBlockSize()];
        int i = 0;
        while (i < cipher.length) {
            if (i + this.plainBlockSize() <= plain.length) {
                this.encryptBlock(plain, i, cipher, i);
            } else {
                byte[] tmp = new byte[this.plainBlockSize()];
                System.arraycopy(plain, i, tmp, 0, plain.length - i);
                this.encryptBlock(tmp, 0, cipher, i);
            }
            i += this.plainBlockSize();
        }
        return cipher;
    }

    public byte[] decrypt(byte[] cipher) {
        return this.decrypt(cipher, false);
    }

    public byte[] decrypt(byte[] cipher, boolean removeEndingZeros) {
        if (cipher == null || cipher.length == 0) {
            return new byte[0];
        }
        int len = cipher.length;
        if (len % this.plainBlockSize() != 0) {
            throw new IllegalArgumentException("cipher length must be multiple of " + this.plainBlockSize());
        }
        byte[] plain = new byte[len];
        int i = 0;
        while (i < cipher.length) {
            this.decryptBlock(cipher, i, plain, i);
            i += this.plainBlockSize();
        }
        if (removeEndingZeros) {
            int reducedLen = len;
            while (reducedLen > 0 && plain[reducedLen - 1] == 0) {
                --reducedLen;
            }
            if (reducedLen < len) {
                byte[] newPlain = new byte[reducedLen];
                System.arraycopy(plain, 0, newPlain, 0, reducedLen);
                plain = newPlain;
            }
        }
        return plain;
    }

    public void destroy() {
        if (this.k1 != null) {
            this.k1.destroy();
        }
        this.k1 = null;
        if (this.k2 != null) {
            this.k2.destroy();
        }
        this.k2 = null;
        if (this.k3 != null) {
            this.k3.destroy();
        }
        this.k3 = null;
    }

    private int plainBlockSize() {
        return 8;
    }

    private byte[] getKey() {
        byte[] k = new byte[24];
        System.arraycopy(this.k1.getKey(), 0, k, 0, 8);
        System.arraycopy(this.k2.getKey(), 0, k, 8, 8);
        System.arraycopy(this.k3.getKey(), 0, k, 16, 8);
        return k;
    }

    private static long pickBits(long a, byte[] bits) {
        long r = 0L;
        int l = bits.length;
        int b = 0;
        while (b < l) {
            r = r << 1 | a >>> 63 - bits[b] & 1L;
            ++b;
        }
        return r;
    }

    private void encryptBlock(byte[] source, int i, byte[] dest, int j) {
        long block = TripleDES.makeLong(source, i, 8);
        block = TripleDES.pickBits(block, DESKey.IP);
        block = this.k1.subCrypt(block);
        block = this.k2.subDecrypt(block);
        block = this.k3.subCrypt(block);
        block = TripleDES.pickBits(block, DESKey.FP);
        TripleDES.writeBytes(block, dest, j, 8);
    }

    private void decryptBlock(byte[] source, int i, byte[] dest, int j) {
        long block = TripleDES.makeLong(source, i, 8);
        block = TripleDES.pickBits(block, DESKey.IP);
        block = this.k3.subDecrypt(block);
        block = this.k2.subCrypt(block);
        block = this.k1.subDecrypt(block);
        block = TripleDES.pickBits(block, DESKey.FP);
        TripleDES.writeBytes(block, dest, j, 8);
    }

    private static void writeBytes(long a, byte[] dest, int i, int length) {
        int j = i + length - 1;
        while (j >= i) {
            dest[j] = (byte)a;
            a >>>= 8;
            --j;
        }
    }

    private static long makeLong(byte[] buf, int i, int length) {
        long r = 0L;
        length += i;
        int j = i;
        while (j < length) {
            r = r << 8 | (long)buf[j] & 0xFFL;
            ++j;
        }
        return r;
    }

    private static class DESKey {
        private long key;
        private long[] subKeys;
        private static final byte[] PC1;
        private static final byte[] PC2;
        private static final int[] S1;
        private static final int[] S2;
        private static final int[] S3;
        private static final int[] S4;
        private static final int[] S5;
        private static final int[] S6;
        private static final int[] S7;
        private static final int[] S8;
        protected static final byte[] IP;
        protected static final byte[] FP;

        static {
            byte[] byArray = new byte[56];
            byArray[0] = 56;
            byArray[1] = 48;
            byArray[2] = 40;
            byArray[3] = 32;
            byArray[4] = 24;
            byArray[5] = 16;
            byArray[6] = 8;
            byArray[8] = 57;
            byArray[9] = 49;
            byArray[10] = 41;
            byArray[11] = 33;
            byArray[12] = 25;
            byArray[13] = 17;
            byArray[14] = 9;
            byArray[15] = 1;
            byArray[16] = 58;
            byArray[17] = 50;
            byArray[18] = 42;
            byArray[19] = 34;
            byArray[20] = 26;
            byArray[21] = 18;
            byArray[22] = 10;
            byArray[23] = 2;
            byArray[24] = 59;
            byArray[25] = 51;
            byArray[26] = 43;
            byArray[27] = 35;
            byArray[28] = 62;
            byArray[29] = 54;
            byArray[30] = 46;
            byArray[31] = 38;
            byArray[32] = 30;
            byArray[33] = 22;
            byArray[34] = 14;
            byArray[35] = 6;
            byArray[36] = 61;
            byArray[37] = 53;
            byArray[38] = 45;
            byArray[39] = 37;
            byArray[40] = 29;
            byArray[41] = 21;
            byArray[42] = 13;
            byArray[43] = 5;
            byArray[44] = 60;
            byArray[45] = 52;
            byArray[46] = 44;
            byArray[47] = 36;
            byArray[48] = 28;
            byArray[49] = 20;
            byArray[50] = 12;
            byArray[51] = 4;
            byArray[52] = 27;
            byArray[53] = 19;
            byArray[54] = 11;
            byArray[55] = 3;
            PC1 = byArray;
            PC2 = new byte[]{21, 24, 18, 31, 8, 12, 10, 35, 22, 13, 28, 17, 30, 26, 19, 11, 33, 15, 23, 14, 34, 27, 20, 9, 48, 59, 38, 44, 54, 62, 37, 47, 58, 52, 40, 55, 51, 56, 46, 63, 41, 60, 53, 49, 57, 43, 36, 39};
            int[] nArray = new int[64];
            nArray[0] = 0x808200;
            nArray[2] = 32768;
            nArray[3] = 0x808202;
            nArray[4] = 0x808002;
            nArray[5] = 33282;
            nArray[6] = 2;
            nArray[7] = 32768;
            nArray[8] = 512;
            nArray[9] = 0x808200;
            nArray[10] = 0x808202;
            nArray[11] = 512;
            nArray[12] = 0x800202;
            nArray[13] = 0x808002;
            nArray[14] = 0x800000;
            nArray[15] = 2;
            nArray[16] = 514;
            nArray[17] = 0x800200;
            nArray[18] = 0x800200;
            nArray[19] = 33280;
            nArray[20] = 33280;
            nArray[21] = 0x808000;
            nArray[22] = 0x808000;
            nArray[23] = 0x800202;
            nArray[24] = 32770;
            nArray[25] = 0x800002;
            nArray[26] = 0x800002;
            nArray[27] = 32770;
            nArray[29] = 514;
            nArray[30] = 33282;
            nArray[31] = 0x800000;
            nArray[32] = 32768;
            nArray[33] = 0x808202;
            nArray[34] = 2;
            nArray[35] = 0x808000;
            nArray[36] = 0x808200;
            nArray[37] = 0x800000;
            nArray[38] = 0x800000;
            nArray[39] = 512;
            nArray[40] = 0x808002;
            nArray[41] = 32768;
            nArray[42] = 33280;
            nArray[43] = 0x800002;
            nArray[44] = 512;
            nArray[45] = 2;
            nArray[46] = 0x800202;
            nArray[47] = 33282;
            nArray[48] = 0x808202;
            nArray[49] = 32770;
            nArray[50] = 0x808000;
            nArray[51] = 0x800202;
            nArray[52] = 0x800002;
            nArray[53] = 514;
            nArray[54] = 33282;
            nArray[55] = 0x808200;
            nArray[56] = 514;
            nArray[57] = 0x800200;
            nArray[58] = 0x800200;
            nArray[60] = 32770;
            nArray[61] = 33280;
            nArray[63] = 0x808002;
            S1 = nArray;
            int[] nArray2 = new int[64];
            nArray2[0] = 1074282512;
            nArray2[1] = 0x40004000;
            nArray2[2] = 16384;
            nArray2[3] = 540688;
            nArray2[4] = 524288;
            nArray2[5] = 16;
            nArray2[6] = 1074266128;
            nArray2[7] = 0x40004010;
            nArray2[8] = 0x40000010;
            nArray2[9] = 1074282512;
            nArray2[10] = 0x40084000;
            nArray2[11] = 0x40000000;
            nArray2[12] = 0x40004000;
            nArray2[13] = 524288;
            nArray2[14] = 16;
            nArray2[15] = 1074266128;
            nArray2[16] = 540672;
            nArray2[17] = 524304;
            nArray2[18] = 0x40004010;
            nArray2[20] = 0x40000000;
            nArray2[21] = 16384;
            nArray2[22] = 540688;
            nArray2[23] = 0x40080000;
            nArray2[24] = 524304;
            nArray2[25] = 0x40000010;
            nArray2[27] = 540672;
            nArray2[28] = 16400;
            nArray2[29] = 0x40084000;
            nArray2[30] = 0x40080000;
            nArray2[31] = 16400;
            nArray2[33] = 540688;
            nArray2[34] = 1074266128;
            nArray2[35] = 524288;
            nArray2[36] = 0x40004010;
            nArray2[37] = 0x40080000;
            nArray2[38] = 0x40084000;
            nArray2[39] = 16384;
            nArray2[40] = 0x40080000;
            nArray2[41] = 0x40004000;
            nArray2[42] = 16;
            nArray2[43] = 1074282512;
            nArray2[44] = 540688;
            nArray2[45] = 16;
            nArray2[46] = 16384;
            nArray2[47] = 0x40000000;
            nArray2[48] = 16400;
            nArray2[49] = 0x40084000;
            nArray2[50] = 524288;
            nArray2[51] = 0x40000010;
            nArray2[52] = 524304;
            nArray2[53] = 0x40004010;
            nArray2[54] = 0x40000010;
            nArray2[55] = 524304;
            nArray2[56] = 540672;
            nArray2[58] = 0x40004000;
            nArray2[59] = 16400;
            nArray2[60] = 0x40000000;
            nArray2[61] = 1074266128;
            nArray2[62] = 1074282512;
            nArray2[63] = 540672;
            S2 = nArray2;
            int[] nArray3 = new int[64];
            nArray3[0] = 260;
            nArray3[1] = 0x4010100;
            nArray3[3] = 0x4010004;
            nArray3[4] = 0x4000100;
            nArray3[6] = 65796;
            nArray3[7] = 0x4000100;
            nArray3[8] = 65540;
            nArray3[9] = 0x4000004;
            nArray3[10] = 0x4000004;
            nArray3[11] = 65536;
            nArray3[12] = 0x4010104;
            nArray3[13] = 65540;
            nArray3[14] = 0x4010000;
            nArray3[15] = 260;
            nArray3[16] = 0x4000000;
            nArray3[17] = 4;
            nArray3[18] = 0x4010100;
            nArray3[19] = 256;
            nArray3[20] = 65792;
            nArray3[21] = 0x4010000;
            nArray3[22] = 0x4010004;
            nArray3[23] = 65796;
            nArray3[24] = 0x4000104;
            nArray3[25] = 65792;
            nArray3[26] = 65536;
            nArray3[27] = 0x4000104;
            nArray3[28] = 4;
            nArray3[29] = 0x4010104;
            nArray3[30] = 256;
            nArray3[31] = 0x4000000;
            nArray3[32] = 0x4010100;
            nArray3[33] = 0x4000000;
            nArray3[34] = 65540;
            nArray3[35] = 260;
            nArray3[36] = 65536;
            nArray3[37] = 0x4010100;
            nArray3[38] = 0x4000100;
            nArray3[40] = 256;
            nArray3[41] = 65540;
            nArray3[42] = 0x4010104;
            nArray3[43] = 0x4000100;
            nArray3[44] = 0x4000004;
            nArray3[45] = 256;
            nArray3[47] = 0x4010004;
            nArray3[48] = 0x4000104;
            nArray3[49] = 65536;
            nArray3[50] = 0x4000000;
            nArray3[51] = 0x4010104;
            nArray3[52] = 4;
            nArray3[53] = 65796;
            nArray3[54] = 65792;
            nArray3[55] = 0x4000004;
            nArray3[56] = 0x4010000;
            nArray3[57] = 0x4000104;
            nArray3[58] = 260;
            nArray3[59] = 0x4010000;
            nArray3[60] = 65796;
            nArray3[61] = 4;
            nArray3[62] = 0x4010004;
            nArray3[63] = 65792;
            S3 = nArray3;
            int[] nArray4 = new int[64];
            nArray4[0] = -2143285248;
            nArray4[1] = -2147479488;
            nArray4[2] = -2147479488;
            nArray4[3] = 64;
            nArray4[4] = 0x401040;
            nArray4[5] = -2143289280;
            nArray4[6] = -2143289344;
            nArray4[7] = -2147479552;
            nArray4[9] = 0x401000;
            nArray4[10] = 0x401000;
            nArray4[11] = -2143285184;
            nArray4[12] = -2147483584;
            nArray4[14] = 0x400040;
            nArray4[15] = -2143289344;
            nArray4[16] = Integer.MIN_VALUE;
            nArray4[17] = 4096;
            nArray4[18] = 0x400000;
            nArray4[19] = -2143285248;
            nArray4[20] = 64;
            nArray4[21] = 0x400000;
            nArray4[22] = -2147479552;
            nArray4[23] = 4160;
            nArray4[24] = -2143289280;
            nArray4[25] = Integer.MIN_VALUE;
            nArray4[26] = 4160;
            nArray4[27] = 0x400040;
            nArray4[28] = 4096;
            nArray4[29] = 0x401040;
            nArray4[30] = -2143285184;
            nArray4[31] = -2147483584;
            nArray4[32] = 0x400040;
            nArray4[33] = -2143289344;
            nArray4[34] = 0x401000;
            nArray4[35] = -2143285184;
            nArray4[36] = -2147483584;
            nArray4[39] = 0x401000;
            nArray4[40] = 4160;
            nArray4[41] = 0x400040;
            nArray4[42] = -2143289280;
            nArray4[43] = Integer.MIN_VALUE;
            nArray4[44] = -2143285248;
            nArray4[45] = -2147479488;
            nArray4[46] = -2147479488;
            nArray4[47] = 64;
            nArray4[48] = -2143285184;
            nArray4[49] = -2147483584;
            nArray4[50] = Integer.MIN_VALUE;
            nArray4[51] = 4096;
            nArray4[52] = -2143289344;
            nArray4[53] = -2147479552;
            nArray4[54] = 0x401040;
            nArray4[55] = -2143289280;
            nArray4[56] = -2147479552;
            nArray4[57] = 4160;
            nArray4[58] = 0x400000;
            nArray4[59] = -2143285248;
            nArray4[60] = 64;
            nArray4[61] = 0x400000;
            nArray4[62] = 4096;
            nArray4[63] = 0x401040;
            S4 = nArray4;
            int[] nArray5 = new int[64];
            nArray5[0] = 128;
            nArray5[1] = 17039488;
            nArray5[2] = 0x1040000;
            nArray5[3] = 553648256;
            nArray5[4] = 262144;
            nArray5[5] = 128;
            nArray5[6] = 0x20000000;
            nArray5[7] = 0x1040000;
            nArray5[8] = 537133184;
            nArray5[9] = 262144;
            nArray5[10] = 0x1000080;
            nArray5[11] = 537133184;
            nArray5[12] = 553648256;
            nArray5[13] = 553910272;
            nArray5[14] = 262272;
            nArray5[15] = 0x20000000;
            nArray5[16] = 0x1000000;
            nArray5[17] = 0x20040000;
            nArray5[18] = 0x20040000;
            nArray5[20] = 0x20000080;
            nArray5[21] = 553910400;
            nArray5[22] = 553910400;
            nArray5[23] = 0x1000080;
            nArray5[24] = 553910272;
            nArray5[25] = 0x20000080;
            nArray5[27] = 0x21000000;
            nArray5[28] = 17039488;
            nArray5[29] = 0x1000000;
            nArray5[30] = 0x21000000;
            nArray5[31] = 262272;
            nArray5[32] = 262144;
            nArray5[33] = 553648256;
            nArray5[34] = 128;
            nArray5[35] = 0x1000000;
            nArray5[36] = 0x20000000;
            nArray5[37] = 0x1040000;
            nArray5[38] = 553648256;
            nArray5[39] = 537133184;
            nArray5[40] = 0x1000080;
            nArray5[41] = 0x20000000;
            nArray5[42] = 553910272;
            nArray5[43] = 17039488;
            nArray5[44] = 537133184;
            nArray5[45] = 128;
            nArray5[46] = 0x1000000;
            nArray5[47] = 553910272;
            nArray5[48] = 553910400;
            nArray5[49] = 262272;
            nArray5[50] = 0x21000000;
            nArray5[51] = 553910400;
            nArray5[52] = 0x1040000;
            nArray5[54] = 0x20040000;
            nArray5[55] = 0x21000000;
            nArray5[56] = 262272;
            nArray5[57] = 0x1000080;
            nArray5[58] = 0x20000080;
            nArray5[59] = 262144;
            nArray5[61] = 0x20040000;
            nArray5[62] = 17039488;
            nArray5[63] = 0x20000080;
            S5 = nArray5;
            int[] nArray6 = new int[64];
            nArray6[0] = 0x10000008;
            nArray6[1] = 0x10200000;
            nArray6[2] = 8192;
            nArray6[3] = 270540808;
            nArray6[4] = 0x10200000;
            nArray6[5] = 8;
            nArray6[6] = 270540808;
            nArray6[7] = 0x200000;
            nArray6[8] = 0x10002000;
            nArray6[9] = 0x202008;
            nArray6[10] = 0x200000;
            nArray6[11] = 0x10000008;
            nArray6[12] = 0x200008;
            nArray6[13] = 0x10002000;
            nArray6[14] = 0x10000000;
            nArray6[15] = 8200;
            nArray6[17] = 0x200008;
            nArray6[18] = 268443656;
            nArray6[19] = 8192;
            nArray6[20] = 0x202000;
            nArray6[21] = 268443656;
            nArray6[22] = 8;
            nArray6[23] = 270532616;
            nArray6[24] = 270532616;
            nArray6[26] = 0x202008;
            nArray6[27] = 0x10202000;
            nArray6[28] = 8200;
            nArray6[29] = 0x202000;
            nArray6[30] = 0x10202000;
            nArray6[31] = 0x10000000;
            nArray6[32] = 0x10002000;
            nArray6[33] = 8;
            nArray6[34] = 270532616;
            nArray6[35] = 0x202000;
            nArray6[36] = 270540808;
            nArray6[37] = 0x200000;
            nArray6[38] = 8200;
            nArray6[39] = 0x10000008;
            nArray6[40] = 0x200000;
            nArray6[41] = 0x10002000;
            nArray6[42] = 0x10000000;
            nArray6[43] = 8200;
            nArray6[44] = 0x10000008;
            nArray6[45] = 270540808;
            nArray6[46] = 0x202000;
            nArray6[47] = 0x10200000;
            nArray6[48] = 0x202008;
            nArray6[49] = 0x10202000;
            nArray6[51] = 270532616;
            nArray6[52] = 8;
            nArray6[53] = 8192;
            nArray6[54] = 0x10200000;
            nArray6[55] = 0x202008;
            nArray6[56] = 8192;
            nArray6[57] = 0x200008;
            nArray6[58] = 268443656;
            nArray6[60] = 0x10202000;
            nArray6[61] = 0x10000000;
            nArray6[62] = 0x200008;
            nArray6[63] = 268443656;
            S6 = nArray6;
            int[] nArray7 = new int[64];
            nArray7[0] = 0x100000;
            nArray7[1] = 0x2100001;
            nArray7[2] = 33555457;
            nArray7[4] = 1024;
            nArray7[5] = 33555457;
            nArray7[6] = 0x100401;
            nArray7[7] = 34604032;
            nArray7[8] = 34604033;
            nArray7[9] = 0x100000;
            nArray7[11] = 0x2000001;
            nArray7[12] = 1;
            nArray7[13] = 0x2000000;
            nArray7[14] = 0x2100001;
            nArray7[15] = 1025;
            nArray7[16] = 0x2000400;
            nArray7[17] = 0x100401;
            nArray7[18] = 0x100001;
            nArray7[19] = 0x2000400;
            nArray7[20] = 0x2000001;
            nArray7[21] = 0x2100000;
            nArray7[22] = 34604032;
            nArray7[23] = 0x100001;
            nArray7[24] = 0x2100000;
            nArray7[25] = 1024;
            nArray7[26] = 1025;
            nArray7[27] = 34604033;
            nArray7[28] = 0x100400;
            nArray7[29] = 1;
            nArray7[30] = 0x2000000;
            nArray7[31] = 0x100400;
            nArray7[32] = 0x2000000;
            nArray7[33] = 0x100400;
            nArray7[34] = 0x100000;
            nArray7[35] = 33555457;
            nArray7[36] = 33555457;
            nArray7[37] = 0x2100001;
            nArray7[38] = 0x2100001;
            nArray7[39] = 1;
            nArray7[40] = 0x100001;
            nArray7[41] = 0x2000000;
            nArray7[42] = 0x2000400;
            nArray7[43] = 0x100000;
            nArray7[44] = 34604032;
            nArray7[45] = 1025;
            nArray7[46] = 0x100401;
            nArray7[47] = 34604032;
            nArray7[48] = 1025;
            nArray7[49] = 0x2000001;
            nArray7[50] = 34604033;
            nArray7[51] = 0x2100000;
            nArray7[52] = 0x100400;
            nArray7[54] = 1;
            nArray7[55] = 34604033;
            nArray7[57] = 0x100401;
            nArray7[58] = 0x2100000;
            nArray7[59] = 1024;
            nArray7[60] = 0x2000001;
            nArray7[61] = 0x2000400;
            nArray7[62] = 1024;
            nArray7[63] = 0x100001;
            S7 = nArray7;
            int[] nArray8 = new int[64];
            nArray8[0] = 0x8000820;
            nArray8[1] = 2048;
            nArray8[2] = 131072;
            nArray8[3] = 0x8020820;
            nArray8[4] = 0x8000000;
            nArray8[5] = 0x8000820;
            nArray8[6] = 32;
            nArray8[7] = 0x8000000;
            nArray8[8] = 131104;
            nArray8[9] = 0x8020000;
            nArray8[10] = 0x8020820;
            nArray8[11] = 133120;
            nArray8[12] = 0x8020800;
            nArray8[13] = 133152;
            nArray8[14] = 2048;
            nArray8[15] = 32;
            nArray8[16] = 0x8020000;
            nArray8[17] = 0x8000020;
            nArray8[18] = 0x8000800;
            nArray8[19] = 2080;
            nArray8[20] = 133120;
            nArray8[21] = 131104;
            nArray8[22] = 0x8020020;
            nArray8[23] = 0x8020800;
            nArray8[24] = 2080;
            nArray8[27] = 0x8020020;
            nArray8[28] = 0x8000020;
            nArray8[29] = 0x8000800;
            nArray8[30] = 133152;
            nArray8[31] = 131072;
            nArray8[32] = 133152;
            nArray8[33] = 131072;
            nArray8[34] = 0x8020800;
            nArray8[35] = 2048;
            nArray8[36] = 32;
            nArray8[37] = 0x8020020;
            nArray8[38] = 2048;
            nArray8[39] = 133152;
            nArray8[40] = 0x8000800;
            nArray8[41] = 32;
            nArray8[42] = 0x8000020;
            nArray8[43] = 0x8020000;
            nArray8[44] = 0x8020020;
            nArray8[45] = 0x8000000;
            nArray8[46] = 131072;
            nArray8[47] = 0x8000820;
            nArray8[49] = 0x8020820;
            nArray8[50] = 131104;
            nArray8[51] = 0x8000020;
            nArray8[52] = 0x8020000;
            nArray8[53] = 0x8000800;
            nArray8[54] = 0x8000820;
            nArray8[56] = 0x8020820;
            nArray8[57] = 133120;
            nArray8[58] = 133120;
            nArray8[59] = 2080;
            nArray8[60] = 2080;
            nArray8[61] = 131104;
            nArray8[62] = 0x8000000;
            nArray8[63] = 0x8020800;
            S8 = nArray8;
            byte[] byArray2 = new byte[64];
            byArray2[0] = 57;
            byArray2[1] = 49;
            byArray2[2] = 41;
            byArray2[3] = 33;
            byArray2[4] = 25;
            byArray2[5] = 17;
            byArray2[6] = 9;
            byArray2[7] = 1;
            byArray2[8] = 59;
            byArray2[9] = 51;
            byArray2[10] = 43;
            byArray2[11] = 35;
            byArray2[12] = 27;
            byArray2[13] = 19;
            byArray2[14] = 11;
            byArray2[15] = 3;
            byArray2[16] = 61;
            byArray2[17] = 53;
            byArray2[18] = 45;
            byArray2[19] = 37;
            byArray2[20] = 29;
            byArray2[21] = 21;
            byArray2[22] = 13;
            byArray2[23] = 5;
            byArray2[24] = 63;
            byArray2[25] = 55;
            byArray2[26] = 47;
            byArray2[27] = 39;
            byArray2[28] = 31;
            byArray2[29] = 23;
            byArray2[30] = 15;
            byArray2[31] = 7;
            byArray2[32] = 56;
            byArray2[33] = 48;
            byArray2[34] = 40;
            byArray2[35] = 32;
            byArray2[36] = 24;
            byArray2[37] = 16;
            byArray2[38] = 8;
            byArray2[40] = 58;
            byArray2[41] = 50;
            byArray2[42] = 42;
            byArray2[43] = 34;
            byArray2[44] = 26;
            byArray2[45] = 18;
            byArray2[46] = 10;
            byArray2[47] = 2;
            byArray2[48] = 60;
            byArray2[49] = 52;
            byArray2[50] = 44;
            byArray2[51] = 36;
            byArray2[52] = 28;
            byArray2[53] = 20;
            byArray2[54] = 12;
            byArray2[55] = 4;
            byArray2[56] = 62;
            byArray2[57] = 54;
            byArray2[58] = 46;
            byArray2[59] = 38;
            byArray2[60] = 30;
            byArray2[61] = 22;
            byArray2[62] = 14;
            byArray2[63] = 6;
            IP = byArray2;
            byte[] byArray3 = new byte[64];
            byArray3[0] = 39;
            byArray3[1] = 7;
            byArray3[2] = 47;
            byArray3[3] = 15;
            byArray3[4] = 55;
            byArray3[5] = 23;
            byArray3[6] = 63;
            byArray3[7] = 31;
            byArray3[8] = 38;
            byArray3[9] = 6;
            byArray3[10] = 46;
            byArray3[11] = 14;
            byArray3[12] = 54;
            byArray3[13] = 22;
            byArray3[14] = 62;
            byArray3[15] = 30;
            byArray3[16] = 37;
            byArray3[17] = 5;
            byArray3[18] = 45;
            byArray3[19] = 13;
            byArray3[20] = 53;
            byArray3[21] = 21;
            byArray3[22] = 61;
            byArray3[23] = 29;
            byArray3[24] = 36;
            byArray3[25] = 4;
            byArray3[26] = 44;
            byArray3[27] = 12;
            byArray3[28] = 52;
            byArray3[29] = 20;
            byArray3[30] = 60;
            byArray3[31] = 28;
            byArray3[32] = 35;
            byArray3[33] = 3;
            byArray3[34] = 43;
            byArray3[35] = 11;
            byArray3[36] = 51;
            byArray3[37] = 19;
            byArray3[38] = 59;
            byArray3[39] = 27;
            byArray3[40] = 34;
            byArray3[41] = 2;
            byArray3[42] = 42;
            byArray3[43] = 10;
            byArray3[44] = 50;
            byArray3[45] = 18;
            byArray3[46] = 58;
            byArray3[47] = 26;
            byArray3[48] = 33;
            byArray3[49] = 1;
            byArray3[50] = 41;
            byArray3[51] = 9;
            byArray3[52] = 49;
            byArray3[53] = 17;
            byArray3[54] = 57;
            byArray3[55] = 25;
            byArray3[56] = 32;
            byArray3[58] = 40;
            byArray3[59] = 8;
            byArray3[60] = 48;
            byArray3[61] = 16;
            byArray3[62] = 56;
            byArray3[63] = 24;
            FP = byArray3;
        }

        protected DESKey(byte[] key) {
            this.key = TripleDES.makeLong(key, 0, 8);
            this.buildSubKeys();
        }

        protected DESKey(long key) {
            this.key = key;
            this.buildSubKeys();
        }

        protected void destroy() {
            this.key = 0L;
            if (this.subKeys != null && this.subKeys.length > 0) {
                int i = 0;
                while (i < this.subKeys.length) {
                    this.subKeys[i] = 0L;
                    ++i;
                }
            }
            this.subKeys = null;
        }

        protected byte[] getKey() {
            byte[] a = new byte[8];
            TripleDES.writeBytes(this.key, a, 0, 8);
            return a;
        }

        protected long subCrypt(long block) {
            int i = (int)(block >>> 32);
            int r = (int)block;
            int k = 0;
            while (k < 16) {
                int t = i;
                i = r;
                r = t ^ DESKey.f(r, this.subKeys[k]);
                ++k;
            }
            return (long)r << 32 | (long)i & 0xFFFFFFFFL;
        }

        protected void encrypt(byte[] source, int i, byte[] dest, int j) {
            long block = TripleDES.makeLong(source, i, 8);
            block = TripleDES.pickBits(block, DESKey.IP);
            block = this.subCrypt(block);
            block = TripleDES.pickBits(block, DESKey.FP);
            TripleDES.writeBytes(block, dest, j, 8);
        }

        protected long subDecrypt(long block) {
            int i = (int)(block >>> 32);
            int r = (int)block;
            int k = 15;
            while (k >= 0) {
                int t = i;
                i = r;
                r = t ^ DESKey.f(r, this.subKeys[k]);
                --k;
            }
            return (long)r << 32 | (long)i & 0xFFFFFFFFL;
        }

        protected void decrypt(byte[] source, int i, byte[] dest, int j) {
            long block = TripleDES.makeLong(source, i, 8);
            block = TripleDES.pickBits(block, DESKey.IP);
            block = this.subDecrypt(block);
            block = TripleDES.pickBits(block, DESKey.FP);
            TripleDES.writeBytes(block, dest, j, 8);
        }

        private void buildSubKeys() {
            long k = TripleDES.pickBits(this.key, DESKey.PC1);
            this.subKeys = new long[16];
            int i = 0;
            while (i < 16) {
                k = i == 0 || i == 1 || i == 8 || i == 15 ? k << 1 & 0xFFFFFFEFFFFFFEL | k >>> 27 & 0x10000001L : k << 2 & 0xFFFFFFCFFFFFFCL | k >>> 26 & 0x30000003L;
                this.subKeys[i] = TripleDES.pickBits(k, DESKey.PC2);
                ++i;
            }
        }

        private static int f(int r, long k) {
            return S1[(int)((long)(r << 5 & 0x20 | r >>> 27 & 0x1F) ^ k >>> 42 & 0x3FL)] | S2[(int)((long)(r >>> 23 & 0x3F) ^ k >>> 36 & 0x3FL)] | S3[(int)((long)(r >>> 19 & 0x3F) ^ k >>> 30 & 0x3FL)] | S4[(int)((long)(r >>> 15 & 0x3F) ^ k >>> 24 & 0x3FL)] | S5[(int)((long)(r >>> 11 & 0x3F) ^ k >>> 18 & 0x3FL)] | S6[(int)((long)(r >>> 7 & 0x3F) ^ k >>> 12 & 0x3FL)] | S7[(int)((long)(r >>> 3 & 0x3F) ^ k >>> 6 & 0x3FL)] | S8[(int)((long)(r >>> 31 & 1 | r << 1 & 0x3E) ^ k & 0x3FL)];
        }
    }
}

