/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.helper;

import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.http.servletfilter.FilterConfigInjection;
import org.eclipse.scout.http.servletfilter.security.SecureHttpServletRequestWrapper;

public class HttpAuthJaasFilter
implements Filter {
    private FilterConfigInjection m_injection;

    public void init(FilterConfig config0) throws ServletException {
        this.m_injection = new FilterConfigInjection(config0, this.getClass());
    }

    public void destroy() {
        this.m_injection = null;
    }

    public void doFilter(ServletRequest in, ServletResponse out, FilterChain chain) throws IOException, ServletException {
        Principal principal;
        if (this.isSubjectSet()) {
            chain.doFilter(in, out);
            return;
        }
        FilterConfigInjection.FilterConfig config = this.m_injection.getConfig(in);
        if (!config.isActive()) {
            chain.doFilter(in, out);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)in;
        HttpServletResponse res = (HttpServletResponse)out;
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null || subject.isReadOnly()) {
            subject = new Subject();
        }
        if ((principal = req.getUserPrincipal()) != null && !StringUtility.hasText((String)principal.getName())) {
            principal = null;
            String name = req.getRemoteUser();
            if (StringUtility.hasText((String)name)) {
                principal = new SimplePrincipal(name);
            }
        }
        if (principal == null) {
            res.sendError(403);
            return;
        }
        subject.getPrincipals().add(principal);
        subject.setReadOnly();
        this.continueChainWithPrincipal(subject, req, res, chain);
    }

    private boolean isSubjectSet() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            return false;
        }
        if (subject.getPrincipals().size() == 0) {
            return false;
        }
        String name = subject.getPrincipals().iterator().next().getName();
        return name != null && name.trim().length() != 0;
    }

    private void continueChainWithPrincipal(Subject subject, final HttpServletRequest req, final HttpServletResponse res, final FilterChain chain) throws IOException, ServletException {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    Principal principal = Subject.getSubject(AccessController.getContext()).getPrincipals().iterator().next();
                    SecureHttpServletRequestWrapper secureReq = new SecureHttpServletRequestWrapper(req, principal);
                    chain.doFilter((ServletRequest)secureReq, (ServletResponse)res);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof ServletException) {
                throw (ServletException)t;
            }
            throw new ServletException(t);
        }
    }
}

