/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.adapters;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.scout.commons.StringUtility;

public final class CalendarAdapter
extends XmlAdapter<String, Calendar> {
    public String marshal(Calendar calendar) throws Exception {
        if (calendar == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = this.toGregorianCalendar(calendar);
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = factory.newXMLGregorianCalendar(gregorianCalendar);
        return xmlCalendar.toXMLFormat();
    }

    public Calendar unmarshal(String rawValue) throws Exception {
        if (!StringUtility.hasText((String)rawValue)) {
            return null;
        }
        DatatypeFactory factory = DatatypeFactory.newInstance();
        XMLGregorianCalendar xmlCalendar = factory.newXMLGregorianCalendar(rawValue);
        return xmlCalendar.toGregorianCalendar();
    }

    private GregorianCalendar toGregorianCalendar(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        GregorianCalendar gCal = (GregorianCalendar)GregorianCalendar.getInstance(calendar.getTimeZone());
        gCal.setTimeInMillis(calendar.getTimeInMillis());
        return gCal;
    }
}

