/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.handler;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public class LogHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LogHandler.class);
    private int m_logLevel;

    public LogHandler() {
        this.initConfig();
    }

    protected void initConfig() {
        this.setLogLevel(this.getConfiguredLogLevel());
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        this.handleLogMessageInternal(context);
        return true;
    }

    public final boolean handleFault(SOAPMessageContext context) {
        this.handleLogMessageInternal(context);
        return true;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public final void close(MessageContext messageContext) {
    }

    private void handleLogMessageInternal(SOAPMessageContext context) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            context.getMessage().writeTo((OutputStream)bos);
            bos.close();
            boolean outbound = (Boolean)TypeCastUtility.castValue((Object)context.get((Object)"javax.xml.ws.handler.message.outbound"), Boolean.TYPE);
            this.handleLogMessage(outbound ? DirectionType.Out : DirectionType.In, bos.toString("UTF-8"), context);
        }
        catch (Exception e) {
            LOG.error("Error occured while logging SOAP message.", (Throwable)e);
        }
    }

    protected void handleLogMessage(DirectionType directionType, String soapMessage, SOAPMessageContext context) {
        String logMessage = "WS SOAP [service=" + context.get((Object)"javax.xml.ws.wsdl.service") + ", port=" + context.get((Object)"javax.xml.ws.wsdl.port") + ", operation=" + context.get((Object)"javax.xml.ws.wsdl.operation") + ", direction=" + (Object)((Object)directionType) + ", message=" + soapMessage + "]";
        switch (this.getLogLevel()) {
            case 2: {
                LOG.warn(logMessage);
                break;
            }
            case 4: {
                LOG.debug(logMessage);
                break;
            }
            case 5: {
                LOG.trace(logMessage);
                break;
            }
            default: {
                LOG.info(logMessage);
            }
        }
    }

    public int getLogLevel() {
        return this.m_logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.m_logLevel = logLevel;
    }

    @Order(value=10.0)
    @ConfigProperty(value="INTEGER")
    protected int getConfiguredLogLevel() {
        return 3;
    }

    public static enum DirectionType {
        In,
        Out;

    }
}

