/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.services.ui.page;

import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.services.model.ws.project.ServiceNlsProjectProvider;
import org.eclipse.scout.nls.sdk.services.ui.action.TextProviderServiceNewAction;
import org.eclipse.scout.nls.sdk.services.ui.page.TextServiceNodePage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.type.PackageContentChangedListener;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.INodeVisitor;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class TextServiceTablePage
extends AbstractPage {
    private PackageContentChangedListener m_packageContentListener;
    private IPackageFragment m_textServicePackage;

    public TextServiceTablePage() {
        this.setName(Texts.get((String)"TextProviderServices"));
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor((String)"texts.png"));
    }

    public void unloadPage() {
        if (this.m_packageContentListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.m_packageContentListener);
            this.m_packageContentListener = null;
        }
    }

    public void refresh(boolean clearCache) {
        super.refresh(clearCache);
    }

    public IScoutBundle getScoutResource() {
        return (IScoutBundle)super.getScoutResource();
    }

    public String getPageId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isFolder() {
        return true;
    }

    public int accept(INodeVisitor visitor) {
        return this.visitChildren(visitor);
    }

    public void loadChildrenImpl() {
        this.m_textServicePackage = this.getScoutResource().getPackageFragment(this.getScoutResource().getPackageName(".services.common.text"));
        this.m_packageContentListener = new PackageContentChangedListener((IPage)this, this.m_textServicePackage);
        JavaCore.addElementChangedListener((IElementChangedListener)this.m_packageContentListener);
        try {
            IType[] services = ServiceNlsProjectProvider.getRegisteredTextProviderTypes();
            ITypeFilter filter = TypeFilters.getClassesInProject((IJavaProject)this.getScoutResource().getJavaProject());
            IType[] iTypeArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (filter.accept(type)) {
                    new TextServiceNodePage(this, type);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            NlsCore.logWarning((String)"Could not get the text provider service types.", (Throwable)e);
        }
    }

    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{TextProviderServiceNewAction.class};
    }
}

