/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.project.AbstractNlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.model.workspace.project.NlsProjectEvent;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.AbstractTranslationResource;
import org.eclipse.scout.nls.sdk.model.workspace.translationResource.ITranslationResource;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.nls.sdk.simple.model.ws.NlsType;
import org.eclipse.scout.nls.sdk.simple.model.ws.translationfile.PlatformTranslationFile;
import org.eclipse.scout.nls.sdk.simple.model.ws.translationfile.WorkspaceTranslationFile;
import org.eclipse.scout.nls.sdk.simple.ui.dialog.language.TranslationFileNewDialog;
import org.eclipse.scout.nls.sdk.simple.ui.dialog.language.TranslationFileNewModel;
import org.eclipse.scout.nls.sdk.ui.action.INewLanguageContext;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class SimpleNlsProject
extends AbstractNlsProject {
    private NlsType m_nlsClass;
    private PropertyChangeListener m_nlsClassPropertyListener = new P_NlsClassPropertyChangeListener();
    private static final Pattern PATTERN = Pattern.compile("^([^_]*)_[0-9]+\\.[0-9]+\\.[0-9]+(\\.[^.]+)?\\.jar$");

    public SimpleNlsProject(NlsType type) {
        super(type.getType());
        this.m_nlsClass = type;
        this.getNlsType().addPropertyChangeListener(this.m_nlsClassPropertyListener);
        this.updateTranslationResourceLocation();
        this.setSuperType(this.m_nlsClass.getSuperType());
    }

    public ITranslationResource[] loadTranslationResources() throws CoreException {
        if (this.getNlsType().getType().isReadOnly()) {
            String bundleId = this.getPluginId((IJavaElement)this.getNlsType().getType());
            if (bundleId == null) {
                NlsCore.logWarning((String)("could not find bundle: " + bundleId));
                return new ITranslationResource[0];
            }
            return this.loadTranslationFilesFromPlatform(this.getNlsType(), bundleId);
        }
        return this.loadTranslationFilesWorkspace(this.getNlsType());
    }

    private String getPluginId(IJavaElement type) {
        if (type.isReadOnly()) {
            IJavaElement root = type.getAncestor(3);
            String bundleId = null;
            if (root != null) {
                Matcher matcher = PATTERN.matcher(root.getElementName());
                if (matcher.matches()) {
                    bundleId = matcher.group(1);
                } else if ("bin".equals(root.getElementName())) {
                    bundleId = root.getPath().toFile().getParentFile().getName();
                }
            }
            return bundleId;
        }
        return type.getAncestor(2).getElementName();
    }

    private ITranslationResource[] loadTranslationFilesWorkspace(NlsType nlsType) throws CoreException {
        ArrayList<WorkspaceTranslationFile> translationFiles = new ArrayList<WorkspaceTranslationFile>();
        if (nlsType != null && TypeUtility.exists((IJavaElement)nlsType.getType()) && nlsType.getTranslationsFolderName() != null && nlsType.getTranslationsPrefix() != null) {
            Path translationPath = new Path(nlsType.getTranslationsFolderName());
            for (IFile file : NlsSdkSimple.getAllTranslations(nlsType.getJavaProject().getProject(), (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                translationFiles.add(new WorkspaceTranslationFile(file));
            }
            List<IProject> workspaceFragments = NlsSdkSimple.getWorkspaceFragments(nlsType.getHostPluginId());
            for (IProject fragment : workspaceFragments) {
                for (IFile file : NlsSdkSimple.getAllTranslations(fragment, (IPath)translationPath, nlsType.getTranslationsPrefix())) {
                    translationFiles.add(new WorkspaceTranslationFile(file));
                }
            }
        }
        return translationFiles.toArray(new ITranslationResource[translationFiles.size()]);
    }

    private ITranslationResource[] loadTranslationFilesFromPlatform(NlsType nlsType, String bundleId) throws CoreException {
        ArrayList<PlatformTranslationFile> translationFiles = new ArrayList<PlatformTranslationFile>();
        Bundle b = Platform.getBundle((String)bundleId);
        if (b == null) {
            NlsCore.logWarning((String)("Bundle " + bundleId + " could not be found in the platform. Will be ignored."));
        } else {
            Enumeration eee = b.findEntries(nlsType.getTranslationsFolderName(), String.valueOf(nlsType.getTranslationsPrefix()) + "*.properties", false);
            if (eee != null) {
                while (eee.hasMoreElements()) {
                    Object o = eee.nextElement();
                    if (!(o instanceof URL)) continue;
                    InputStream is = null;
                    URL url = (URL)o;
                    try {
                        try {
                            is = url.openStream();
                            translationFiles.add(new PlatformTranslationFile(is, NlsSdkSimple.getLanguage(url.getFile())));
                        }
                        catch (IOException e) {
                            NlsCore.logError((String)("could not load NLS files of bundle '" + bundleId + "'"), (Throwable)e);
                            if (is == null) continue;
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {}
                        }
                        throw throwable;
                    }
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return (ITranslationResource[])translationFiles.toArray(new AbstractTranslationResource[translationFiles.size()]);
    }

    private void createTranslationFile(Language language, INlsFolder folder, IProgressMonitor monitor) throws CoreException {
        String fileName = NlsSdkSimple.getLocalizedPropertiesFileName(this.getNlsType().getTranslationsPrefix(), language);
        IFile file = folder.getFolder().getFile((IPath)new Path(fileName));
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, monitor);
        }
        this.addTranslationResource((ITranslationResource)new WorkspaceTranslationFile(file), monitor);
    }

    public INewLanguageContext getTranslationCreationContext() {
        return new INewLanguageContext(){
            private final TranslationFileNewModel m_model;
            {
                this.m_model = new TranslationFileNewModel(SimpleNlsProject.this);
            }

            public boolean interactWithUi(Shell s) {
                TranslationFileNewDialog dialog = new TranslationFileNewDialog(s, this.m_model);
                return dialog.open() == 0;
            }

            public void execute(IProgressMonitor monitor) {
                try {
                    SimpleNlsProject.this.createTranslationFile(this.m_model.getLanguage(), this.m_model.getFolder(), (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    NlsCore.logError((String)"Unable to create new language.", (Throwable)e);
                }
            }
        };
    }

    private void setSuperType(IType superType) {
        if (superType != null) {
            try {
                this.setParent(NlsCore.getNlsWorkspace().getNlsProject(new Object[]{superType}));
            }
            catch (CoreException coreException) {
                NlsCore.logError((String)("parent of NLS project could not be found. Looked for type '" + superType.getFullyQualifiedName() + "'"));
            }
        }
    }

    public NlsType getNlsType() {
        return this.m_nlsClass;
    }

    private class P_NlsClassPropertyChangeListener
    implements PropertyChangeListener {
        private P_NlsClassPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("translationFilePrefix".equals(evt.getPropertyName()) || "translationFolderName".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.resetCache();
                SimpleNlsProject.this.updateTranslationResourceLocation();
                SimpleNlsProject.this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)SimpleNlsProject.this, 16));
            } else if ("superType".equals(evt.getPropertyName())) {
                SimpleNlsProject.this.resetCache();
                SimpleNlsProject.this.setSuperType(SimpleNlsProject.this.getNlsType().getSuperType());
                SimpleNlsProject.this.fireNlsProjectEvent(new NlsProjectEvent((INlsProject)SimpleNlsProject.this, 16));
            }
        }
    }
}

