/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.bookmark.internal;

import java.io.Serializable;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

public final class TestBookmarkUtility {
    private TestBookmarkUtility() {
    }

    public static void main(String[] args) {
        TestBookmarkUtility.test(null);
        TestBookmarkUtility.test(new String[0]);
        TestBookmarkUtility.test(new String[1]);
        TestBookmarkUtility.test(new String[1][0]);
        TestBookmarkUtility.test(new String[0][1]);
        TestBookmarkUtility.test(new String[][]{{"aaa", "bbb"}, {"ccc"}});
        TestBookmarkUtility.test(new int[]{3, 2, 1});
        TestBookmarkUtility.test(new Bookmark[]{new Bookmark()});
        TestBookmarkUtility.test(new SerializablePrimaryKey(1234L));
        TestBookmarkUtility.test(new UnSerializablePrimaryKey(1234L));
        TestBookmarkUtility.test(new UnSerializablePrimaryKeyWithToString(1234L));
        TestBookmarkUtility.test(new SerializablePrimaryKey[]{new SerializablePrimaryKey(1234L)});
        TestBookmarkUtility.test(new UnSerializablePrimaryKey[]{new UnSerializablePrimaryKey(1234L)});
        TestBookmarkUtility.test(new UnSerializablePrimaryKeyWithToString[]{new UnSerializablePrimaryKeyWithToString(1234L)});
    }

    public static void test(Object a) {
        Object b = BookmarkUtility.makeSerializableKey(a, false);
        System.out.println("Input:  " + (a != null ? a.getClass() : null) + " " + VerboseUtility.dumpObject((Object)a));
        System.out.println("Output: " + (b != null ? b.getClass() : null) + " " + VerboseUtility.dumpObject((Object)b));
        System.out.println();
    }

    private static class SerializablePrimaryKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final long m_id;

        public SerializablePrimaryKey(long id) {
            this.m_id = id;
        }
    }

    private static class UnSerializablePrimaryKey {
        private final long m_id;

        public UnSerializablePrimaryKey(long id) {
            this.m_id = id;
        }
    }

    private static class UnSerializablePrimaryKeyWithToString {
        private final long m_id;

        public UnSerializablePrimaryKeyWithToString(long id) {
            this.m_id = id;
        }

        public String toString() {
            return "UnSerializablePrimaryKeyWithToString [m_id=" + this.m_id + "]";
        }
    }
}

