/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.lookup;

import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.lookup.BatchSplit;
import org.eclipse.scout.rt.client.servicetunnel.ServiceTunnelUtility;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupNormalizer;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-3.0f)
public class BatchLookupServiceClientProxy
extends AbstractService
implements IBatchLookupService {
    public LookupRow[][] getBatchDataByKey(BatchLookupCall batch) throws ProcessingException {
        LookupCall[] allCalls = batch.getCallBatch();
        int i = 0;
        while (i < allCalls.length) {
            if (allCalls[i] != null && allCalls[i].getKey() == null) {
                allCalls[i] = null;
            }
            ++i;
        }
        BatchSplit split = new BatchSplit(allCalls);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i2 = 0;
            while (i2 < calls.length) {
                resultArray[i2] = cache.getDataByKey(calls[i2]);
                ++i2;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            BatchLookupNormalizer normalizer = new BatchLookupNormalizer();
            LookupCall[] normCallArray = normalizer.normalizeCalls(split.getRemoteCalls());
            LookupRow[][] normResultArray = this.getTargetService().getBatchDataByKey(new BatchLookupCall(normCallArray));
            LookupRow[][] resultArray = normalizer.denormalizeResults(normResultArray);
            split.setRemoteResults(resultArray);
        }
        LookupRow[][] results = split.getCombinedResults();
        int i3 = 0;
        while (i3 < results.length) {
            if (results[i3] == null) {
                results[i3] = LookupRow.EMPTY_ARRAY;
            }
            ++i3;
        }
        return results;
    }

    public LookupRow[][] getBatchDataByText(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = cache.getDataByText(calls[i]);
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByText(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public LookupRow[][] getBatchDataByAll(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = cache.getDataByAll(calls[i]);
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByAll(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    public LookupRow[][] getBatchDataByRec(BatchLookupCall batch) throws ProcessingException {
        BatchSplit split = new BatchSplit(batch);
        if (split.getLocalCallCount() > 0) {
            BatchLookupResultCache cache = new BatchLookupResultCache();
            LookupCall[] calls = split.getLocalCalls();
            LookupRow[][] resultArray = new LookupRow[calls.length][];
            int i = 0;
            while (i < calls.length) {
                resultArray[i] = cache.getDataByRec(calls[i]);
                ++i;
            }
            split.setLocalResults(resultArray);
        }
        if (split.getRemoteCallCount() > 0) {
            LookupRow[][] resultArray = this.getTargetService().getBatchDataByRec(new BatchLookupCall(split.getRemoteCalls()));
            split.setRemoteResults(resultArray);
        }
        return split.getCombinedResults();
    }

    private IBatchLookupService getTargetService() {
        return ServiceTunnelUtility.createProxy(IBatchLookupService.class, ClientSyncJob.getCurrentSession().getServiceTunnel());
    }
}

