/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui;

import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.ClientSessionThreadLocal;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.shared.data.basic.BoundsSpec;
import org.eclipse.scout.rt.shared.services.common.prefs.IUserPreferencesStorageService;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.Preferences;

public class ClientUIPreferences {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ClientUIPreferences.class);
    private static final String TABLE_CUSTOMIZER_DATA = "table.customizer.data.";
    private static final String TABLE_COLUMN_UIINDEX = "table.column.viewIndex.";
    private static final String TABLE_COLUMN_WIDTH = "table.column.width.";
    private static final String TABLE_COLUMN_VISIBLE = "table.column.visible.";
    private static final String TABLE_COLUMN_SORT_INDEX = "table.column.sortIndex.";
    private static final String TABLE_COLUMN_SORT_ASC = "table.column.sortAsc.";
    private static final String TABLE_COLUMN_SORT_EXPLICIT = "table.column.sortExplicit.";
    private static final String APPLICATION_WINDOW_MAXIMIZED = "application.window.maximized";
    private static final String APPLICATION_WINDOW_BOUNDS = "application.window.bounds";
    private static final String CALENDAR_DISPLAY_MODE = "calendar.display.mode";
    private static final String CALENDAR_DISPLAY_CONDENSED = "calendar.display.condensed";
    private static final String DESKTOP_COLUMN_SPLITS = "desktop.columnSplits";
    private static final String FORM_BOUNDS = "form.bounds.";
    @Deprecated
    private static final String NLS_LOCALE_ISO = "nls_locale_iso";
    @Deprecated
    private static final String NLS_LOCALE_LANGUAGE = "locale.language";
    @Deprecated
    private static final String NLS_LOCALE_COUNTRY = "locale.country";
    private final IClientSession m_session;
    private Preferences m_env;

    public static ClientUIPreferences getInstance() {
        return new ClientUIPreferences(ClientSessionThreadLocal.get());
    }

    public static ClientUIPreferences getInstance(IClientSession session) {
        return new ClientUIPreferences(session);
    }

    @Deprecated
    public ClientUIPreferences() {
        this(ClientSessionThreadLocal.get());
    }

    private ClientUIPreferences(IClientSession session) {
        this.m_session = session;
        if (this.m_session == null) {
            LOG.error("No scout client session context", (Throwable)new Exception("Calling client preferences from outside a scout client session job"));
        }
        this.load();
    }

    public Rectangle getFormBounds(IForm form) {
        String key = form.computeCacheBoundsKey();
        if (key == null) {
            return null;
        }
        key = String.valueOf(this.getUserAgentPrefix()) + FORM_BOUNDS + key;
        String value = this.m_env.get(key, "");
        if (StringUtility.isNullOrEmpty((String)value)) {
            key = this.getLegacyFormBoundsKey(form);
            value = this.m_env.get(key, "");
        }
        if (!StringUtility.isNullOrEmpty((String)value)) {
            try {
                StringTokenizer tok = new StringTokenizer(value, ",");
                Rectangle r = new Rectangle(new Integer(tok.nextToken()), new Integer(tok.nextToken()), new Integer(tok.nextToken()), new Integer(tok.nextToken()));
                return r;
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return null;
    }

    public void setFormBounds(IForm form, Rectangle bounds) {
        String key = form.computeCacheBoundsKey();
        if (key == null) {
            return;
        }
        key = String.valueOf(this.getUserAgentPrefix()) + FORM_BOUNDS + key;
        if (bounds == null) {
            this.m_env.remove(key);
        } else {
            this.m_env.put(key, String.valueOf(bounds.x) + "," + bounds.y + "," + bounds.width + "," + bounds.height);
        }
        this.flush();
    }

    private String getLegacyFormBoundsKey(IForm form) {
        String key = form.computeCacheBoundsKey();
        if (key == null) {
            return null;
        }
        if (!key.startsWith("form.bounds")) {
            key = "form.bounds_" + key;
        }
        return key;
    }

    private String getUserAgentPrefix() {
        UserAgent currentUserAgent = null;
        currentUserAgent = this.m_session != null ? this.m_session.getUserAgent() : UserAgentUtility.getCurrentUserAgent();
        if (currentUserAgent == null) {
            return "";
        }
        String uiLayer = null;
        if (!UiLayer.UNKNOWN.equals((Object)currentUserAgent.getUiLayer())) {
            uiLayer = currentUserAgent.getUiLayer().getIdentifier();
        }
        String uiDeviceType = null;
        if (!UiDeviceType.UNKNOWN.equals((Object)currentUserAgent.getUiDeviceType())) {
            uiDeviceType = currentUserAgent.getUiDeviceType().getIdentifier();
        }
        return StringUtility.concatenateTokens((String[])new String[]{uiLayer, ".", uiDeviceType, "."});
    }

    public int[] getSplitterPosition(ISplitBox splitBox) {
        String baseKey = splitBox.getCacheSplitterPositionPropertyName();
        if (baseKey == null) {
            return null;
        }
        String key = String.valueOf(this.getUserAgentPrefix()) + baseKey;
        int[] value = this.getPropertyIntArray(key);
        if (value == null) {
            value = this.getPropertyIntArray(baseKey);
        }
        return value;
    }

    public void setSplitterPosition(ISplitBox splitBox, int[] weights) {
        String key = splitBox.getCacheSplitterPositionPropertyName();
        if (key == null) {
            return;
        }
        key = String.valueOf(this.getUserAgentPrefix()) + key;
        this.setPropertyIntArray(key, weights);
    }

    public String getTableKey(ITable t) {
        String key = t.getClass().getName();
        String context = t.getUserPreferenceContext();
        if (context != null) {
            key = String.valueOf(key) + "#" + context;
        }
        return key;
    }

    @Deprecated
    public Object getTableCustomizerData(String customizerKey, Bundle loaderBundle) {
        return this.getTableCustomizerData(customizerKey);
    }

    public Object getTableCustomizerData(String customizerKey) {
        String key = TABLE_CUSTOMIZER_DATA + customizerKey;
        byte[] serialData = this.m_env.getByteArray(key, null);
        if (serialData != null) {
            try {
                Object customizerData = SerializationUtility.createObjectSerializer().deserialize(serialData, null);
                return customizerData;
            }
            catch (Throwable t) {
                LOG.error("Failed reading custom table data for " + key + ": " + t);
                this.m_env.remove(key);
                return null;
            }
        }
        return null;
    }

    public void setTableCustomizerData(String customizerKey, Object customizerData) {
        String key = TABLE_CUSTOMIZER_DATA + customizerKey;
        if (customizerData != null) {
            try {
                byte[] data = SerializationUtility.createObjectSerializer().serialize(customizerData);
                this.m_env.putByteArray(key, data);
            }
            catch (Throwable t) {
                LOG.error("Failed storing custom table data for " + key, t);
                this.m_env.remove(key);
            }
        } else {
            this.m_env.remove(key);
        }
        this.flush();
    }

    public String getColumnKey(IColumn c) {
        String key = c.getColumnId();
        if (c.getTable() != null) {
            key = String.valueOf(this.getTableKey(c.getTable())) + "#" + key;
        }
        return key;
    }

    public void setTableColumnPreferences(IColumn col) {
        this.setTableColumnPreferences(col, true);
    }

    public void setTableColumnPreferences(IColumn col, boolean flush) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_UIINDEX + keySuffix;
        int viewIndex = col.getVisibleColumnIndexHint();
        boolean visible = col.isVisibleInternal();
        int width = col.getWidth();
        int sortIndex = col.getSortIndex();
        boolean sortUp = col.isSortAscending();
        boolean sortExplicit = col.isSortExplicit();
        if (viewIndex >= 0) {
            this.m_env.put(key, "" + viewIndex);
        } else {
            this.m_env.remove(key);
        }
        key = TABLE_COLUMN_VISIBLE + keySuffix;
        if (!visible) {
            this.m_env.put(key, "no");
        } else {
            this.m_env.put(key, "yes");
        }
        key = String.valueOf(this.getUserAgentPrefix()) + TABLE_COLUMN_WIDTH + keySuffix;
        if (width >= 0) {
            this.m_env.put(key, "" + width);
        } else {
            this.m_env.remove(key);
        }
        key = TABLE_COLUMN_SORT_INDEX + keySuffix;
        if (sortIndex >= 0) {
            this.m_env.put(key, "" + sortIndex);
        } else {
            this.m_env.put(key, "-1");
        }
        key = TABLE_COLUMN_SORT_ASC + keySuffix;
        if (sortIndex >= 0 && sortUp) {
            this.m_env.put(key, "true");
        } else {
            this.m_env.put(key, "false");
        }
        key = TABLE_COLUMN_SORT_EXPLICIT + keySuffix;
        if (sortExplicit) {
            this.m_env.put(key, "true");
        } else {
            this.m_env.put(key, "false");
        }
        if (flush) {
            this.flush();
        }
    }

    public void updateTableColumnOrder(List<IColumn<?>> columnList, int[] visibleColumnIndexHints) {
        if (columnList.size() != visibleColumnIndexHints.length) {
            throw new IllegalArgumentException("columnList.size=" + columnList.size() + " hints.length=" + visibleColumnIndexHints.length);
        }
        int i = 0;
        while (i < visibleColumnIndexHints.length) {
            IColumn<?> c = columnList.get(i);
            int viewIndex = visibleColumnIndexHints[i];
            String keySuffix = this.getColumnKey(c);
            String key = TABLE_COLUMN_UIINDEX + keySuffix;
            if (viewIndex >= 0) {
                this.m_env.put(key, "" + viewIndex);
            } else {
                this.m_env.remove(key);
            }
            ++i;
        }
        this.flush();
    }

    public void removeTableColumnPreferences(IColumn col) {
        this.removeTableColumnPreferences(col, true, true, true, true);
    }

    public void removeTableColumnPreferences(IColumn col, boolean visibility, boolean order, boolean sorting, boolean widths) {
        this.removeTableColumnPreferences(col, visibility, order, sorting, widths, true);
    }

    private void removeTableColumnPreferences(IColumn col, boolean visibility, boolean order, boolean sorting, boolean widths, boolean flush) {
        if (col != null) {
            String keySuffix = this.getColumnKey(col);
            if (visibility) {
                this.m_env.remove(TABLE_COLUMN_VISIBLE + keySuffix);
            }
            if (order) {
                this.m_env.remove(TABLE_COLUMN_UIINDEX + keySuffix);
            }
            if (sorting) {
                this.m_env.remove(TABLE_COLUMN_SORT_INDEX + keySuffix);
                this.m_env.remove(TABLE_COLUMN_SORT_ASC + keySuffix);
                this.m_env.remove(TABLE_COLUMN_SORT_EXPLICIT + keySuffix);
            }
            if (widths) {
                this.m_env.remove(String.valueOf(this.getUserAgentPrefix()) + TABLE_COLUMN_WIDTH + keySuffix);
            }
            if (flush) {
                this.flush();
            }
        }
    }

    public void removeAllTableColumnPreferences(ITable table, boolean visibility, boolean order, boolean sorting, boolean widths) {
        if (table == null) {
            return;
        }
        IColumn<?>[] iColumnArray = table.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn<?> col = iColumnArray[n2];
            this.removeTableColumnPreferences(col, visibility, order, sorting, widths, false);
            ++n2;
        }
        this.flush();
    }

    public void setAllTableColumnPreferences(ITable table) {
        if (table == null) {
            return;
        }
        IColumn<?>[] iColumnArray = table.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn<?> col = iColumnArray[n2];
            if (col.isDisplayable()) {
                this.setTableColumnPreferences(col, false);
            }
            ++n2;
        }
        this.flush();
    }

    public boolean hasTableColumnPreferences(ITable table) {
        if (table != null) {
            IColumn<?>[] iColumnArray = table.getColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn<?> col = iColumnArray[n2];
                String keySuffix = this.getColumnKey(col);
                if (this.m_env.get(TABLE_COLUMN_VISIBLE + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_env.get(TABLE_COLUMN_UIINDEX + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_env.get(TABLE_COLUMN_SORT_INDEX + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_env.get(TABLE_COLUMN_SORT_ASC + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_env.get(TABLE_COLUMN_SORT_EXPLICIT + keySuffix, null) != null) {
                    return true;
                }
                if (this.m_env.get(TABLE_COLUMN_WIDTH + keySuffix, null) != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public int getTableColumnWidth(IColumn col, int defaultWidth) {
        String keySuffix = this.getColumnKey(col);
        String baseKey = TABLE_COLUMN_WIDTH + keySuffix;
        String key = String.valueOf(this.getUserAgentPrefix()) + baseKey;
        String value = this.m_env.get(key, null);
        if (value == null) {
            value = this.m_env.get(baseKey, null);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return defaultWidth;
    }

    public boolean getTableColumnVisible(IColumn col, boolean defaultValue) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_VISIBLE + keySuffix;
        String value = this.m_env.get(key, null);
        if (value != null) {
            Boolean b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            return b != null ? b : defaultValue;
        }
        return defaultValue;
    }

    public int getTableColumnViewIndex(IColumn col, int defaultIndex) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_UIINDEX + keySuffix;
        String value = this.m_env.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return defaultIndex;
    }

    public int getTableColumnSortIndex(IColumn col, int defaultValue) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_SORT_INDEX + keySuffix;
        String value = this.m_env.get(key, null);
        if (value != null) {
            Integer i = (Integer)TypeCastUtility.castValue((Object)value, Integer.class);
            return i;
        }
        return defaultValue;
    }

    public boolean getTableColumnSortAscending(IColumn col, boolean defaultValue) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_SORT_ASC + keySuffix;
        String value = this.m_env.get(key, null);
        if (value != null) {
            Boolean b = (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            return b != null ? b : defaultValue;
        }
        return defaultValue;
    }

    public Boolean getTableColumnSortExplicit(IColumn col) {
        String keySuffix = this.getColumnKey(col);
        String key = TABLE_COLUMN_SORT_EXPLICIT + keySuffix;
        String value = this.m_env.get(key, null);
        if (value != null) {
            return (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
        }
        return null;
    }

    public void setApplicationWindowPreferences(BoundsSpec r, boolean maximized) {
        if (r != null) {
            String value = r.x + "," + r.y + "," + r.width + "," + r.height;
            this.m_env.put(APPLICATION_WINDOW_BOUNDS, value);
        } else {
            this.m_env.remove(APPLICATION_WINDOW_BOUNDS);
        }
        if (maximized) {
            this.m_env.put(APPLICATION_WINDOW_MAXIMIZED, "yes");
        } else {
            this.m_env.remove(APPLICATION_WINDOW_MAXIMIZED);
        }
        this.flush();
    }

    public boolean getApplicationWindowMaximized() {
        String key = APPLICATION_WINDOW_MAXIMIZED;
        String value = this.m_env.get(key, null);
        if (value != null) {
            return value.equalsIgnoreCase("yes");
        }
        return false;
    }

    public BoundsSpec getApplicationWindowBounds() {
        String key = APPLICATION_WINDOW_BOUNDS;
        String value = this.m_env.get(key, null);
        if (value != null) {
            try {
                StringTokenizer tok = new StringTokenizer(value, ",");
                BoundsSpec r = new BoundsSpec(new Integer(tok.nextToken()).intValue(), new Integer(tok.nextToken()).intValue(), new Integer(tok.nextToken()).intValue(), new Integer(tok.nextToken()).intValue());
                return r;
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return null;
    }

    public void setCalendarPreferences(int displayMode, boolean displayCondensed) {
        this.m_env.put(CALENDAR_DISPLAY_MODE, "" + displayMode);
        this.m_env.put(CALENDAR_DISPLAY_CONDENSED, "" + displayCondensed);
        this.flush();
    }

    public int getCalendarDisplayMode(int defaultValue) {
        String key = CALENDAR_DISPLAY_MODE;
        String value = this.m_env.get(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public boolean getCalendarDisplayCondensed(boolean defaultValue) {
        String key = CALENDAR_DISPLAY_CONDENSED;
        String value = this.m_env.get(key, null);
        if (value != null) {
            try {
                return (Boolean)TypeCastUtility.castValue((Object)value, Boolean.class);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return defaultValue;
    }

    public int getPropertyInteger(String propName, int defaultValue, boolean setDefaultAsProperty) {
        String value = this.m_env.get(propName, null);
        if (value != null) {
            try {
                return (Integer)TypeCastUtility.castValue((Object)value, Integer.class);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
                if (setDefaultAsProperty) {
                    this.setPropertyInteger(propName, defaultValue);
                }
            }
        } else if (setDefaultAsProperty) {
            this.setPropertyInteger(propName, defaultValue);
        }
        return defaultValue;
    }

    public void setPropertyInteger(String propName, int value) {
        this.m_env.put(propName, "" + value);
        this.flush();
    }

    public int[] getPropertyIntArray(String propName) {
        String strVal = this.m_env.get(propName, null);
        if (!StringUtility.hasText((String)strVal)) {
            return null;
        }
        String[] split = strVal.split(";");
        int[] val = new int[split.length];
        int i = 0;
        while (i < split.length) {
            val[i] = Integer.parseInt(split[i]);
            ++i;
        }
        return val;
    }

    public void setPropertyIntArray(String propName, int[] value) {
        StringBuilder builder = new StringBuilder();
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                builder.append(value[i]);
                if (i != value.length - 1) {
                    builder.append(";");
                }
                ++i;
            }
        }
        this.m_env.put(propName, builder.toString());
        this.flush();
    }

    public Double getPropertyDouble(String propName) {
        String value = this.m_env.get(propName, null);
        if (value != null) {
            try {
                return (Double)TypeCastUtility.castValue((Object)value, Double.class);
            }
            catch (Exception e) {
                LOG.warn("value=" + value, (Throwable)e);
            }
        }
        return null;
    }

    public void setPropertyDouble(String propName, Double value) {
        this.m_env.put(propName, "" + value);
        this.flush();
    }

    public int[][] getDesktopColumnSplits(int rowCount, int colCount) {
        int[] a = this.getPropertyIntArray(DESKTOP_COLUMN_SPLITS);
        if (a != null && a.length == rowCount * colCount) {
            int[][] splits = new int[rowCount][colCount];
            int index = 0;
            int r = 0;
            while (r < rowCount) {
                int c = 0;
                while (c < colCount) {
                    splits[r][c] = a[index];
                    ++index;
                    ++c;
                }
                ++r;
            }
            return splits;
        }
        return null;
    }

    @Deprecated
    public Locale getLocale() {
        String strLegacy = this.m_env.get(NLS_LOCALE_ISO, null);
        if (strLegacy != null) {
            this.m_env.remove(NLS_LOCALE_ISO);
            this.m_env.put(NLS_LOCALE_LANGUAGE, strLegacy);
            this.flush();
        }
        String strLanguage = this.m_env.get(NLS_LOCALE_LANGUAGE, null);
        String strCountry = this.m_env.get(NLS_LOCALE_COUNTRY, null);
        if (strLanguage != null && strCountry != null) {
            return new Locale(strLanguage, strCountry);
        }
        if (strLanguage != null) {
            return new Locale(strLanguage, ClientUIPreferences.getHostLocale().getCountry());
        }
        return null;
    }

    @Deprecated
    public void setLocale(Locale locale) {
        if (locale != null) {
            this.m_env.put(NLS_LOCALE_LANGUAGE, locale.getLanguage());
            this.m_env.put(NLS_LOCALE_COUNTRY, locale.getCountry());
        } else {
            this.m_env.remove(NLS_LOCALE_LANGUAGE);
            this.m_env.remove(NLS_LOCALE_COUNTRY);
        }
        this.flush();
    }

    @Deprecated
    public static Locale getHostLocale() {
        return Locale.getDefault();
    }

    public void setDesktopColumnSplits(int[][] splits) {
        if (splits != null) {
            int rowCount = splits.length;
            int colCount = splits[0].length;
            int[] a = new int[rowCount * colCount];
            int index = 0;
            int r = 0;
            while (r < rowCount) {
                int c = 0;
                while (c < colCount) {
                    a[index] = splits[r][c];
                    ++index;
                    ++c;
                }
                ++r;
            }
            this.setPropertyIntArray(DESKTOP_COLUMN_SPLITS, a);
        }
    }

    protected void load() {
        if (this.m_session == null || ClientSessionThreadLocal.get() == this.m_session) {
            this.m_env = ((IUserPreferencesStorageService)SERVICES.getService(IUserPreferencesStorageService.class)).loadPreferences();
        } else {
            ClientAsyncJob job = new ClientAsyncJob("Load user preferences", this.m_session){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    ClientUIPreferences.this.m_env = ((IUserPreferencesStorageService)SERVICES.getService(IUserPreferencesStorageService.class)).loadPreferences();
                }
            };
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.m_env == null) {
            throw new IllegalStateException("Could not load preferences in client job");
        }
    }

    protected void flush() {
        try {
            this.m_env.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

