/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columnfilter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.serialization.SerializationUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.BooleanColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ColumnFilterForm;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ComparableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.StringColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.TableColumnFilterEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.TableColumnFilterListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class DefaultTableColumnFilterManager
implements ITableColumnFilterManager,
ITableRowFilter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(DefaultTableColumnFilterManager.class);
    private final ITable m_table;
    private final Map<IColumn, ITableColumnFilter> m_filterMap;
    private final EventListenerList m_listenerList;
    private boolean m_enabled;

    public DefaultTableColumnFilterManager(ITable table) {
        this.m_table = table;
        this.m_filterMap = Collections.synchronizedMap(new HashMap());
        this.m_listenerList = new EventListenerList();
        this.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.m_enabled != enabled) {
            this.m_enabled = enabled;
            this.m_table.removeRowFilter(this);
            if (this.m_enabled) {
                this.m_table.addRowFilter(this);
            }
        }
    }

    @Override
    public <T> ITableColumnFilter<T> getFilter(IColumn<T> col) {
        return this.m_filterMap.get(col);
    }

    @Override
    public void reset() throws ProcessingException {
        try {
            this.m_table.setTableChanging(true);
            for (IColumn col : this.m_filterMap.keySet()) {
                this.m_table.getColumnSet().updateColumn(col);
            }
            this.m_filterMap.clear();
            this.m_table.applyRowFilters();
            this.fireFiltersReset();
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    @Override
    public void showFilterForm(IColumn col, boolean showAsPopupDialog) throws ProcessingException {
        ITableColumnFilter<Boolean> filter = this.m_filterMap.get(col);
        boolean created = false;
        if (filter == null) {
            created = true;
            if (col instanceof ISmartColumn) {
                filter = new StringColumnFilter(col);
            } else if (String.class.isAssignableFrom(col.getDataType())) {
                filter = new StringColumnFilter(col);
            } else if (Boolean.class.isAssignableFrom(col.getDataType())) {
                filter = new BooleanColumnFilter(col);
            } else if (Comparable.class.isAssignableFrom(col.getDataType())) {
                filter = new ComparableColumnFilter(col);
            }
        }
        if (filter != null) {
            ColumnFilterForm f = new ColumnFilterForm();
            if (showAsPopupDialog) {
                f.setDisplayHint(12);
            }
            f.setModal(true);
            f.setColumnFilter(filter);
            f.startModify();
            f.waitFor();
            if (f.isFormStored()) {
                if (filter.isEmpty()) {
                    this.m_filterMap.remove(col);
                    if (!created) {
                        this.fireFilterRemoved(col);
                    }
                } else {
                    this.m_filterMap.put(col, filter);
                    if (created) {
                        this.fireFilterAdded(col);
                    } else {
                        this.fireFilterChanged(col);
                    }
                }
                this.m_table.getColumnSet().updateColumn(col);
                this.m_table.applyRowFilters();
            }
        }
    }

    @Override
    public boolean accept(ITableRow row) {
        for (ITableColumnFilter f : this.m_filterMap.values()) {
            if (f.accept(row)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<String> getDisplayTexts() {
        ArrayList<String> list = new ArrayList<String>();
        for (ITableColumnFilter filter : this.m_filterMap.values()) {
            if (filter == null || filter.isEmpty()) continue;
            list.add(String.valueOf(ScoutTexts.get((String)"Column", (String[])new String[0])) + " \"" + filter.getColumn().getHeaderCell().getText() + "\"");
        }
        return list;
    }

    @Override
    public Collection<ITableColumnFilter> getFilters() {
        return this.m_filterMap.values();
    }

    @Override
    public void refresh() {
        ArrayList<ITableColumnFilter> data = new ArrayList<ITableColumnFilter>();
        data.addAll(this.m_filterMap.values());
        this.m_filterMap.clear();
        for (ITableColumnFilter filter : data) {
            this.m_filterMap.put(filter.getColumn(), filter);
            this.m_table.getColumnSet().updateColumn(filter.getColumn());
        }
        this.m_table.applyRowFilters();
    }

    @Override
    public byte[] getSerializedFilter(IColumn col) {
        ITableColumnFilter filter = this.m_filterMap.get(col);
        if (filter != null) {
            try {
                filter.setColumn(null);
                byte[] byArray = SerializationUtility.createObjectSerializer().serialize((Object)filter);
                return byArray;
            }
            catch (Throwable t) {
                LOG.error("Failed storing filter data for " + t);
            }
            finally {
                filter.setColumn(col);
            }
        }
        return null;
    }

    @Override
    public void setSerializedFilter(byte[] filterData, IColumn col) {
        try {
            if (col != null) {
                ITableColumnFilter filter = (ITableColumnFilter)SerializationUtility.createObjectSerializer().deserialize(filterData, ITableColumnFilter.class);
                filter.setColumn(col);
                this.m_filterMap.put(col, filter);
            }
            this.m_table.applyRowFilters();
        }
        catch (Throwable t) {
            LOG.error("Failed reading filter data: " + t);
        }
    }

    @Override
    public void addListener(TableColumnFilterListener listener) {
        this.m_listenerList.add(TableColumnFilterListener.class, (EventListener)listener);
    }

    @Override
    public void removeListener(TableColumnFilterListener listener) {
        this.m_listenerList.remove(TableColumnFilterListener.class, (EventListener)listener);
    }

    private void fireFilterAdded(IColumn<?> column) throws ProcessingException {
        this.fireFilterEvent(new TableColumnFilterEvent(this.m_table, 10, column));
    }

    private void fireFilterChanged(IColumn<?> column) throws ProcessingException {
        this.fireFilterEvent(new TableColumnFilterEvent(this.m_table, 20, column));
    }

    private void fireFilterRemoved(IColumn<?> column) throws ProcessingException {
        this.fireFilterEvent(new TableColumnFilterEvent(this.m_table, 30, column));
    }

    private void fireFiltersReset() {
        try {
            this.fireFilterEvent(new TableColumnFilterEvent(this.m_table, 40));
        }
        catch (ProcessingException e) {
            LOG.warn(null, (Throwable)e);
        }
    }

    private void fireFilterEvent(TableColumnFilterEvent e) throws ProcessingException {
        TableColumnFilterListener[] listeners = (TableColumnFilterListener[])this.m_listenerList.getListeners(TableColumnFilterListener.class);
        if (listeners != null && listeners.length > 0) {
            ProcessingException pe = null;
            TableColumnFilterListener[] tableColumnFilterListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    TableColumnFilterListener listener = tableColumnFilterListenerArray[n2];
                    try {
                        listener.tableColumnFilterChanged(e);
                    }
                    catch (ProcessingException ex) {
                        if (pe == null) {
                            pe = ex;
                        }
                    }
                    catch (Throwable t) {
                        if (pe != null) break block7;
                        pe = new ProcessingException("Unexpected", t);
                    }
                }
                ++n2;
            }
            if (pe != null) {
                throw pe;
            }
        }
    }
}

