/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.listbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.services.lookup.FormFieldProvisioningContext;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTableRowBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBoxFilterBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.ActiveOrCheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.CheckedRowsFilter;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBox;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.IListBoxUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractListBox<T>
extends AbstractValueField<T[]>
implements IListBox<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractListBox.class);
    private ITable m_table;
    private IListBoxUIFacade m_uiFacade;
    private LookupCall m_lookupCall;
    private Class<? extends ICodeType> m_codeTypeClass;
    private boolean m_valueTableSyncActive;
    private ITableRowFilter m_checkedRowsFilter;
    private ITableRowFilter m_activeRowsFilter;
    private IFormField[] m_fields;

    public AbstractListBox() {
        this(true);
    }

    public AbstractListBox(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=240.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="lookupCall")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="codeType")
    protected Class<? extends ICodeType> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAutoLoad() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFilterActiveRows() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFilterCheckedRows() {
        return false;
    }

    @Override
    @ConfigPropertyValue(value="1.0")
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    private Class<? extends IFormField>[] getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IFormField.class);
    }

    @ConfigOperation
    @Order(value=250.0)
    protected void execPrepareLookup(LookupCall call) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=260.0)
    protected void execFilterLookupResult(LookupCall call, List<LookupRow> result) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=230.0)
    protected LookupRow[] execLoadTableData() throws ProcessingException {
        LookupRow[] data;
        if (this.getLookupCall() != null) {
            LookupCall call = ((ILookupCallProvisioningService)SERVICES.getService(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new FormFieldProvisioningContext(this));
            this.prepareLookupCall(call);
            data = call.getDataByAll();
            data = this.filterLookupResult(call, data);
        } else {
            data = new LookupRow[]{};
            data = this.filterLookupResult(null, data);
        }
        return data;
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execPopulateTable() throws ProcessingException {
        LookupRow[] data = null;
        if (!this.isMasterRequired() || this.getMasterValue() != null) {
            data = this.execLoadTableData();
        }
        ITableRow[] rows = new ITableRow[data != null ? data.length : 0];
        if (data != null) {
            int i = 0;
            while (i < data.length) {
                rows[i] = this.getTableRowBuilder().createTableRow(data[i]);
                ++i;
            }
        }
        this.getTable().replaceRows(rows);
    }

    private Class<? extends ITable> getConfiguredTable() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        Class[] f = ConfigurationUtility.filterClasses((Class[])dca, ITable.class);
        if (f.length == 1) {
            return f[0];
        }
        Class[] classArray = f;
        int n = f.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (c.getDeclaringClass() != AbstractListBox.class) {
                return c;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void execChangedMasterValue(Object newMasterValue) throws ProcessingException {
        this.setValue(null);
        this.loadListBoxData();
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = this.createUIFacade();
        this.m_fields = new IFormField[0];
        super.initConfig();
        this.setFilterActiveRows(this.getConfiguredFilterActiveRows());
        this.setFilterActiveRowsValue(TriState.TRUE);
        this.setFilterCheckedRows(this.getConfiguredFilterCheckedRows());
        this.setFilterCheckedRowsValue(this.getConfiguredFilterCheckedRows());
        try {
            this.m_table = (ITable)ConfigurationUtility.newInnerInstance((Object)this, this.getConfiguredTable());
            if (this.m_table instanceof AbstractTable) {
                ((AbstractTable)this.m_table).setContainerInternal(this);
            }
            this.updateActiveRowsFilter();
            this.updateCheckedRowsFilter();
            this.m_table.addTableListener(new TableAdapter(){

                @Override
                public void tableChanged(TableEvent e) {
                    switch (e.getType()) {
                        case 103: {
                            if (AbstractListBox.this.getTable().isCheckable()) break;
                            AbstractListBox.this.syncTableToValue();
                            break;
                        }
                        case 101: {
                            if (!AbstractListBox.this.getTable().isCheckable()) break;
                            AbstractListBox.this.syncTableToValue();
                        }
                    }
                }
            });
            if (this.m_table.getDefaultIconId() == null && this.getConfiguredIconId() != null) {
                this.m_table.setDefaultIconId(this.getConfiguredIconId());
            }
            this.m_table.setEnabled(this.isEnabled());
        }
        catch (Exception e) {
            LOG.warn(null, (Throwable)e);
        }
        if (this.getConfiguredLookupCall() != null) {
            try {
                LookupCall call = this.getConfiguredLookupCall().newInstance();
                this.setLookupCall(call);
            }
            catch (Exception e) {
                LOG.warn(null, (Throwable)e);
            }
        }
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (AbstractListBox.this.m_table != null) {
                    String name = e.getPropertyName();
                    if ("enabled".equals(name)) {
                        AbstractListBox.this.m_table.setEnabled(AbstractListBox.this.isEnabled());
                    } else if ("filterCheckedRowsValue".equals(name)) {
                        AbstractListBox.this.updateCheckedRowsFilter();
                    } else if ("filterActiveRowsValue".equals(name)) {
                        AbstractListBox.this.updateActiveRowsFilter();
                    }
                }
            }
        });
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        Class<IFormField>[] fieldArray = this.getConfiguredFields();
        int i = 0;
        while (i < fieldArray.length) {
            try {
                IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, fieldArray[i]);
                fieldList.add(f);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + fieldArray[i].getName(), t));
            }
            ++i;
        }
        for (IFormField f : fieldList) {
            f.setParentFieldInternal(this);
        }
        this.m_fields = fieldList.toArray(new IFormField[0]);
    }

    public ListBoxFilterBox getListBoxFilterBox() {
        return this.getFieldByClass((Class)ListBoxFilterBox.class);
    }

    @Override
    protected void initFieldInternal() throws ProcessingException {
        this.getTable().initTable();
        if (this.getConfiguredAutoLoad()) {
            try {
                this.setValueChangeTriggerEnabled(false);
                this.loadListBoxData();
            }
            finally {
                this.setValueChangeTriggerEnabled(true);
            }
        }
        super.initFieldInternal();
    }

    @Override
    protected void disposeFieldInternal() {
        super.disposeFieldInternal();
        this.getTable().disposeTable();
    }

    public AbstractTableRowBuilder getTableRowBuilder() {
        return new P_TableRowBuilder();
    }

    protected IListBoxUIFacade createUIFacade() {
        return new P_ListBoxUIFacade();
    }

    @Override
    public IListBoxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public final ITable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isFilterCheckedRows() {
        return this.propertySupport.getPropertyBool("filterCheckedRows");
    }

    @Override
    public void setFilterCheckedRows(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRows", b);
    }

    @Override
    public boolean getFilterCheckedRowsValue() {
        return this.propertySupport.getPropertyBool("filterCheckedRowsValue");
    }

    @Override
    public void setFilterCheckedRowsValue(boolean b) {
        this.propertySupport.setPropertyBool("filterCheckedRowsValue", b);
    }

    @Override
    public boolean isFilterActiveRows() {
        return this.propertySupport.getPropertyBool("filterActiveRows");
    }

    @Override
    public void setFilterActiveRows(boolean b) {
        this.propertySupport.setPropertyBool("filterActiveRows", b);
    }

    @Override
    public TriState getFilterActiveRowsValue() {
        return (TriState)this.propertySupport.getProperty("filterActiveRowsValue");
    }

    @Override
    public void setFilterActiveRowsValue(TriState t) {
        if (t == null) {
            t = TriState.TRUE;
        }
        this.propertySupport.setProperty("filterActiveRowsValue", (Object)t);
    }

    private void updateActiveRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_activeRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_activeRowsFilter);
                this.m_activeRowsFilter = null;
            }
            this.m_activeRowsFilter = new ActiveOrCheckedRowsFilter(this.getActiveColumnInternal(), this.getFilterActiveRowsValue());
            this.getTable().addRowFilter(this.m_activeRowsFilter);
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    private void updateCheckedRowsFilter() {
        try {
            this.getTable().setTableChanging(true);
            if (this.m_checkedRowsFilter != null) {
                this.getTable().removeRowFilter(this.m_checkedRowsFilter);
                this.m_checkedRowsFilter = null;
            }
            if (this.getFilterCheckedRowsValue()) {
                this.m_checkedRowsFilter = new CheckedRowsFilter();
                this.getTable().addRowFilter(this.m_checkedRowsFilter);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
        }
    }

    @Override
    public void loadListBoxData() throws ProcessingException {
        if (this.getTable() != null) {
            try {
                this.m_valueTableSyncActive = true;
                this.getTable().setTableChanging(true);
                this.execPopulateTable();
            }
            finally {
                this.getTable().setTableChanging(false);
                this.m_valueTableSyncActive = false;
            }
            this.syncValueToTable();
        }
    }

    @Override
    public final void prepareLookupCall(LookupCall call) throws ProcessingException {
        this.prepareLookupCallInternal(call);
        this.execPrepareLookup(call);
    }

    private LookupRow[] filterLookupResult(LookupCall call, LookupRow[] data) throws ProcessingException {
        ArrayList<Object> result = data != null ? new ArrayList<LookupRow>(Arrays.asList(data)) : new ArrayList();
        this.execFilterLookupResult(call, result);
        int len = 0;
        for (LookupRow r : result) {
            if (r == null) continue;
            ++len;
        }
        LookupRow[] a = new LookupRow[len];
        int index = 0;
        for (LookupRow r : result) {
            if (r == null) continue;
            a[index] = r;
            ++index;
        }
        return a;
    }

    private void prepareLookupCallInternal(LookupCall call) {
        call.setActive(TriState.UNDEFINED);
        if (this.getMasterValue() != null || this.getLookupCall() == null || this.getLookupCall().getMaster() == null) {
            call.setMaster(this.getMasterValue());
        }
    }

    @Override
    public final LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    @Override
    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
    }

    @Override
    protected void valueChangedInternal() {
        super.valueChangedInternal();
        this.syncValueToTable();
    }

    @Override
    protected String formatValueInternal(T[] validValue) {
        if (validValue == null || validValue.length == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        ITableRow[] rows = this.getKeyColumnInternal().findRows(validValue);
        int i = 0;
        while (i < rows.length) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.getTextColumnInternal().getValue(rows[i]));
            ++i;
        }
        return b.toString();
    }

    @Override
    protected T[] validateValueInternal(T[] rawValue) throws ProcessingException {
        ITable table;
        Object[] validValue = rawValue;
        if (validValue != null && validValue.length == 0) {
            validValue = null;
        }
        if ((table = this.getTable()) != null && validValue != null && (table.isCheckable() && !table.isMultiCheck() || !table.isCheckable() && !table.isMultiSelect()) && validValue.length > 1) {
            LOG.warn(String.valueOf(this.getClass().getName()) + " only accepts a single value. Got " + Arrays.toString(validValue) + ". Using only first value.");
            Object[] newArray = (Object[])Array.newInstance(validValue.getClass().getComponentType(), 1);
            newArray[0] = validValue[0];
            validValue = newArray;
        }
        return validValue;
    }

    @Override
    public T getSingleValue() {
        Object[] a = (Object[])this.getValue();
        if (a != null && a.length > 0) {
            return (T)a[0];
        }
        return null;
    }

    @Override
    public void setSingleValue(T value) {
        if (value == null) {
            this.setValue(null);
        } else {
            Object[] array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 1);
            array[0] = value;
            this.setValue(array);
        }
    }

    @Override
    public int getCheckedKeyCount() {
        Object[] keys = (Object[])this.getValue();
        if (keys != null) {
            return keys.length;
        }
        return 0;
    }

    @Override
    public T getCheckedKey() {
        T[] a = this.getCheckedKeys();
        if (a != null && a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public T[] getCheckedKeys() {
        return (Object[])this.getValue();
    }

    @Override
    public LookupRow getCheckedLookupRow() {
        LookupRow[] a = this.getCheckedLookupRows();
        if (a != null && a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public LookupRow[] getCheckedLookupRows() {
        LookupRow[] lookupRows = null;
        ITableRow[] tableRows = this.getTable().getCheckedRows();
        if (tableRows != null) {
            lookupRows = new LookupRow[tableRows.length];
            int i = 0;
            while (i < tableRows.length) {
                ICell cell = tableRows[i].getCell(1);
                lookupRows[i] = new LookupRow(tableRows[i].getCellValue(0), cell.getText(), cell.getIconId(), cell.getTooltipText(), cell.getBackgroundColor(), cell.getForegroundColor(), cell.getFont(), cell.isEnabled());
                ++i;
            }
        }
        return lookupRows;
    }

    @Override
    public void checkKey(T key) {
        if (key == null) {
            this.checkKeys(null);
        } else {
            Object[] array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 1);
            array[0] = key;
            this.checkKeys(array);
        }
    }

    @Override
    public void checkKeys(T[] keys) {
        this.setValue(keys);
    }

    @Override
    public void uncheckAllKeys() {
        this.checkKeys(null);
    }

    @Override
    public T[] getUncheckedKeys() {
        Object[] array;
        HashSet<Object> set = new HashSet<Object>();
        Object[] a = (Object[])this.getInitValue();
        if (a != null) {
            set.addAll(Arrays.asList(a));
        }
        if ((a = this.getCheckedKeys()) != null) {
            set.removeAll(Arrays.asList(a));
        }
        if ((a = set.toArray(array = (Object[])Array.newInstance(this.getHolderType().getComponentType(), 0))) != null && a.length == 0) {
            a = null;
        }
        return a;
    }

    @Override
    public void checkAllKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues());
    }

    @Override
    public void checkAllActiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(true)));
    }

    @Override
    public void uncheckAllInactiveKeys() {
        this.checkKeys(this.getKeyColumnInternal().getValues(this.getActiveColumnInternal().findRows(false)));
    }

    private IColumn<T> getKeyColumnInternal() {
        return this.getTable().getColumnSet().getColumn(0);
    }

    private IColumn<String> getTextColumnInternal() {
        return this.getTable().getColumnSet().getColumn(1);
    }

    private IColumn<Boolean> getActiveColumnInternal() {
        return this.getTable().getColumnSet().getColumn(2);
    }

    private void syncValueToTable() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            ITableRow row;
            this.m_valueTableSyncActive = true;
            this.getTable().setTableChanging(true);
            T[] checkedKeys = this.getCheckedKeys();
            ITableRow[] checkedRows = this.getKeyColumnInternal().findRows(checkedKeys);
            ITableRow[] iTableRowArray = this.getTable().getRows();
            int n = iTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                row = iTableRowArray[n2];
                row.setChecked(false);
                ++n2;
            }
            iTableRowArray = checkedRows;
            n = checkedRows.length;
            n2 = 0;
            while (n2 < n) {
                row = iTableRowArray[n2];
                row.setChecked(true);
                ++n2;
            }
            if (!this.getTable().isCheckable()) {
                this.getTable().selectRows(checkedRows, false);
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
    }

    private void syncTableToValue() {
        if (this.m_valueTableSyncActive) {
            return;
        }
        try {
            this.m_valueTableSyncActive = true;
            this.m_table.setTableChanging(true);
            ITableRow[] checkedRows = this.getTable().isCheckable() ? this.getTable().getCheckedRows() : this.getTable().getSelectedRows();
            this.checkKeys(this.getKeyColumnInternal().getValues(checkedRows));
            if (!this.getTable().isCheckable()) {
                ITableRow[] iTableRowArray = this.m_table.getRows();
                int n = iTableRowArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITableRow row = iTableRowArray[n2];
                    row.setChecked(row.isSelected());
                    ++n2;
                }
            }
        }
        finally {
            this.getTable().setTableChanging(false);
            this.m_valueTableSyncActive = false;
        }
        if (!this.m_table.getUIFacade().isUIProcessing()) {
            this.updateActiveRowsFilter();
        }
        this.updateCheckedRowsFilter();
    }

    public <F extends IFormField> F getFieldByClass(final Class<F> c) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == c) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (F)((IFormField)found.getValue());
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    public <X extends IFormField> X getFieldById(final String id, final Class<X> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (X)((IFormField)found.getValue());
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.length;
    }

    @Override
    public int getFieldIndex(IFormField f) {
        int i = 0;
        while (i < this.m_fields.length) {
            if (this.m_fields[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IFormField[] getFields() {
        IFormField[] a = new IFormField[this.m_fields.length];
        System.arraycopy(this.m_fields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i] instanceof ICompositeField ? !((ICompositeField)f[i]).visitFields(visitor, startLevel + 1) : !visitor.visitField(f[i], startLevel, index)) {
                return false;
            }
            ++index;
            ++i;
        }
        return true;
    }

    @Override
    public final int getGridColumnCount() {
        return 1;
    }

    @Override
    public final int getGridRowCount() {
        return 1;
    }

    @Override
    public void rebuildFieldGrid() {
        GridData gd = this.getListBoxFilterBox().getGridDataHints();
        gd.x = 0;
        gd.y = 0;
        this.getListBoxFilterBox().setGridDataInternal(gd);
    }

    public class DefaultListBoxTable
    extends AbstractTable {
        @Override
        @ConfigPropertyValue(value="true")
        protected boolean getConfiguredAutoResizeColumns() {
            return true;
        }

        @Override
        @ConfigPropertyValue(value="false")
        protected boolean getConfiguredHeaderVisible() {
            return false;
        }

        @Override
        @ConfigPropertyValue(value="false")
        protected boolean getConfiguredMultiSelect() {
            return false;
        }

        @Override
        @ConfigPropertyValue(value="true")
        protected boolean getConfiguredCheckable() {
            return true;
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.KeyColumn getKeyColumn() {
            return this.getColumnSet().getColumnByClass(KeyColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.TextColumn getTextColumn() {
            return this.getColumnSet().getColumnByClass(TextColumn.class);
        }

        public org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox$DefaultListBoxTable.ActiveColumn getActiveColumn() {
            return this.getColumnSet().getColumnByClass(ActiveColumn.class);
        }

        @Order(value=3.0)
        public class ActiveColumn
        extends AbstractBooleanColumn {
            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }
        }

        @Order(value=1.0)
        public class KeyColumn
        extends AbstractColumn<T> {
            @Override
            protected boolean getConfiguredPrimaryKey() {
                return true;
            }

            @Override
            protected boolean getConfiguredDisplayable() {
                return false;
            }

            @Override
            public Class<T> getDataType() {
                return TypeCastUtility.getGenericsParameterClass(AbstractListBox.this.getClass(), IListBox.class);
            }
        }

        @Order(value=2.0)
        public class TextColumn
        extends AbstractStringColumn {
        }
    }

    @Order(value=1.0)
    public class ListBoxFilterBox
    extends AbstractListBoxFilterBox {
        @Override
        protected IListBox getListBox() {
            return AbstractListBox.this;
        }
    }

    protected class P_ListBoxUIFacade
    implements IListBoxUIFacade {
        protected P_ListBoxUIFacade() {
        }
    }

    private class P_TableRowBuilder
    extends AbstractTableRowBuilder {
        private P_TableRowBuilder() {
        }

        @Override
        protected ITableRow createEmptyTableRow() {
            return new TableRow(AbstractListBox.this.getTable().getColumnSet());
        }

        @Override
        public ITableRow createTableRow(LookupRow dataRow) throws ProcessingException {
            TableRow tableRow = (TableRow)super.createTableRow(dataRow);
            AbstractListBox.this.getKeyColumnInternal().setValue(tableRow, dataRow.getKey());
            AbstractListBox.this.getTextColumnInternal().setValue(tableRow, dataRow.getText());
            AbstractListBox.this.getActiveColumnInternal().setValue(tableRow, Boolean.valueOf(dataRow.isActive()));
            Cell cell = tableRow.getCellForUpdate(1);
            cell.setEnabled(dataRow.isEnabled());
            if (!dataRow.isActive()) {
                if (cell.getFont() == null) {
                    cell.setFont(FontSpec.parse((String)"italic"));
                }
                AbstractListBox.this.getTextColumnInternal().setValue(tableRow, String.valueOf(dataRow.getText()) + " (" + ScoutTexts.get((String)"InactiveState", (String[])new String[0]) + ")");
            }
            return tableRow;
        }
    }
}

