/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.longfield;

import java.text.ParsePosition;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.ILongField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.AbstractNumberField;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractLongField
extends AbstractNumberField<Long>
implements ILongField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractLongField.class);

    public AbstractLongField() {
        this(true);
    }

    public AbstractLongField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="LONG")
    @Order(value=250.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="minValue")
    protected Long getConfiguredMinimumValue() {
        return null;
    }

    @ConfigProperty(value="LONG")
    @Order(value=260.0)
    @ConfigPropertyValue(value="null")
    @ValidationRule(value="maxValue")
    protected Long getConfiguredMaximumValue() {
        return null;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinValue(this.getConfiguredMinimumValue());
        this.setMaxValue(this.getConfiguredMaximumValue());
    }

    @Override
    protected Long parseValueInternal(String text) throws ProcessingException {
        Long retVal = null;
        if ((text = text == null ? "" : text.trim()).length() > 0) {
            ParsePosition p = new ParsePosition(0);
            Number n = this.createNumberFormat().parse(text, p);
            if (p.getErrorIndex() >= 0 || p.getIndex() != text.length()) {
                throw new ProcessingException(ScoutTexts.get((String)"InvalidNumberMessageX", (String[])new String[]{text}));
            }
            retVal = new Long(n.longValue());
        }
        return retVal;
    }
}

