/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.LocaleThreadLocal;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField;

public abstract class AbstractDoubleColumn
extends AbstractColumn<Double>
implements IDoubleColumn {
    private String m_format;
    private boolean m_groupingUsed;
    private int m_maxFractionDigits;
    private int m_minFractionDigits;
    private boolean m_percent;
    private int m_multiplier;
    private NumberFormat m_fmt;

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="STRING")
    @Order(value=140.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=150.0)
    @ConfigPropertyValue(value="2")
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    @ConfigPropertyValue(value="2")
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=170.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=190.0)
    @ConfigPropertyValue(value="1")
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setPercent(this.getConfiguredPercent());
        this.setMultiplier(this.getConfiguredMultiplier());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        this.m_fmt = null;
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setMinFractionDigits(int i) {
        if (i > this.getMaxFractionDigits()) {
            this.m_maxFractionDigits = i;
        }
        this.m_minFractionDigits = i;
        this.m_fmt = null;
    }

    @Override
    public int getMinFractionDigits() {
        return this.m_minFractionDigits;
    }

    @Override
    public void setMaxFractionDigits(int i) {
        if (i < this.getMinFractionDigits()) {
            this.m_minFractionDigits = i;
        }
        this.m_maxFractionDigits = i;
        this.m_fmt = null;
    }

    @Override
    public int getMaxFractionDigits() {
        return this.m_maxFractionDigits;
    }

    @Override
    public void setGroupingUsed(boolean b) {
        this.m_groupingUsed = b;
        this.m_fmt = null;
    }

    @Override
    public boolean isGroupingUsed() {
        return this.m_groupingUsed;
    }

    @Override
    public void setPercent(boolean b) {
        this.m_percent = b;
        this.m_fmt = null;
    }

    @Override
    public boolean isPercent() {
        return this.m_percent;
    }

    @Override
    public void setMultiplier(int i) {
        this.m_multiplier = i;
        this.m_fmt = null;
    }

    @Override
    public int getMultiplier() {
        return this.m_multiplier;
    }

    @Override
    protected Double parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Double validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Double) {
            validValue = (Double)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).doubleValue();
        } else {
            throw new ProcessingException("invalid Double value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractDoubleField f = new AbstractDoubleField(){};
        f.setFormat(this.getFormat());
        f.setMaxFractionDigits(this.getMaxFractionDigits());
        f.setMinFractionDigits(this.getMinFractionDigits());
        f.setFractionDigits(this.getNumberFormat().getMaximumFractionDigits());
        f.setMultiplier(this.getMultiplier());
        f.setGroupingUsed(this.isGroupingUsed());
        f.setPercent(this.isPercent());
        return f;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getNumberFormat().format((Double)cell.getValue()));
        } else {
            cell.setText("");
        }
    }

    @Override
    public NumberFormat getNumberFormat() {
        if (this.m_fmt == null) {
            this.m_fmt = this.isPercent() ? NumberFormat.getPercentInstance(LocaleThreadLocal.get()) : NumberFormat.getNumberInstance(LocaleThreadLocal.get());
            if (this.m_fmt instanceof DecimalFormat) {
                ((DecimalFormat)this.m_fmt).setMultiplier(this.getMultiplier());
                if (this.getFormat() != null) {
                    ((DecimalFormat)this.m_fmt).applyPattern(this.getFormat());
                } else {
                    this.m_fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                    this.m_fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                    this.m_fmt.setGroupingUsed(this.isGroupingUsed());
                }
            } else {
                this.m_fmt.setMinimumFractionDigits(this.getMinFractionDigits());
                this.m_fmt.setMaximumFractionDigits(this.getMaxFractionDigits());
                this.m_fmt.setGroupingUsed(this.isGroupingUsed());
            }
        }
        return this.m_fmt;
    }
}

