/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.DefaultFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.FormFieldInjectionThreadLocal;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractCompositeField
extends AbstractFormField
implements ICompositeField {
    private IFormField[] m_fields;
    private Map<Class<?>, Class<? extends IFormField>> m_formFieldReplacements;

    public AbstractCompositeField() {
        this(true);
    }

    public AbstractCompositeField(boolean callInitializer) {
        super(callInitializer);
    }

    protected Class<? extends IFormField>[] getConfiguredFields() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IFormField.class);
    }

    @Override
    protected boolean execCalculateVisible() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initConfig() {
        void var5_11;
        this.m_fields = new IFormField[0];
        super.initConfig();
        Class<? extends IFormField>[] fieldArray = this.getConfiguredFields();
        DefaultFormFieldInjection injectedFields = null;
        ArrayList<Class<? extends IFormField>> configuredFields = new ArrayList<Class<? extends IFormField>>();
        Class<? extends IFormField>[] classArray = fieldArray;
        int n = fieldArray.length;
        boolean n2 = false;
        while (var5_11 < n) {
            Class<? extends IFormField> clazz = classArray[var5_11];
            if (ConfigurationUtility.isInjectFieldAnnotationPresent(clazz)) {
                if (injectedFields == null) {
                    injectedFields = new DefaultFormFieldInjection(this);
                }
                injectedFields.addField(clazz);
            } else {
                configuredFields.add(clazz);
            }
            ++var5_11;
        }
        ArrayList<IFormField> fieldList = new ArrayList<IFormField>();
        try {
            if (injectedFields != null) {
                FormFieldInjectionThreadLocal.push(injectedFields);
            }
            this.filterFieldsInternal(configuredFields);
            for (Class clazz : configuredFields) {
                try {
                    IFormField f = (IFormField)ConfigurationUtility.newInnerInstance((Object)this, (Class)clazz);
                    fieldList.add(f);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("field: " + clazz.getName(), t));
                }
            }
            this.injectFieldsInternal(fieldList);
        }
        finally {
            if (injectedFields != null) {
                this.m_formFieldReplacements = injectedFields.getReplacementMapping();
                FormFieldInjectionThreadLocal.pop(injectedFields);
            }
        }
        for (IFormField iFormField : fieldList) {
            iFormField.setParentFieldInternal(this);
        }
        IFormField[] iFormFieldArray = this.m_fields = fieldList.toArray(new IFormField[fieldList.size()]);
        int n3 = this.m_fields.length;
        int n4 = 0;
        while (n4 < n3) {
            IFormField iFormField = iFormFieldArray[n4];
            iFormField.addPropertyChangeListener(new P_FieldPropertyChangeListener());
            ++n4;
        }
        this.handleFieldVisibilityChanged();
    }

    protected void filterFieldsInternal(List<Class<? extends IFormField>> fieldList) {
        FormFieldInjectionThreadLocal.filterFields(this, fieldList);
    }

    protected void injectFieldsInternal(List<IFormField> fieldList) {
        FormFieldInjectionThreadLocal.injectFields(this, fieldList);
    }

    @Override
    public void setFormInternal(IForm form) {
        super.setFormInternal(form);
        if (form instanceof AbstractForm) {
            ((AbstractForm)form).registerFormFieldReplacementsInternal(this.m_formFieldReplacements);
        }
        IFormField[] a = this.m_fields;
        int i = 0;
        while (i < a.length) {
            IFormField f = a[i];
            f.setFormInternal(form);
            ++i;
        }
    }

    @Override
    public int getFieldIndex(IFormField f) {
        int i = 0;
        while (i < this.m_fields.length) {
            if (this.m_fields[i] == f) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getFieldCount() {
        return this.m_fields.length;
    }

    @Override
    public IFormField getFieldById(final String id) {
        final Holder found = new Holder(IFormField.class);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (IFormField)found.getValue();
    }

    @Override
    public <T extends IFormField> T getFieldById(final String id, final Class<T> type) {
        final Holder found = new Holder(type);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (type.isAssignableFrom(field.getClass()) && field.getFieldId().equals(id)) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    @Override
    public <T extends IFormField> T getFieldByClass(Class<T> c) {
        final Class<T> formFieldClass = this.getReplacingFieldClass(c);
        final Holder found = new Holder(c);
        IFormFieldVisitor v = new IFormFieldVisitor(){

            @Override
            public boolean visitField(IFormField field, int level, int fieldIndex) {
                if (field.getClass() == formFieldClass) {
                    found.setValue((Object)field);
                }
                return found.getValue() == null;
            }
        };
        this.visitFields(v, 0);
        return (T)((IFormField)found.getValue());
    }

    private <T extends IFormField> Class<? extends T> getReplacingFieldClass(Class<T> c) {
        Class<? extends IFormField> replacementFieldClass;
        Map<Class<?>, Class<IFormField>> mapping;
        IForm form = this.getForm();
        if (form instanceof AbstractForm && (mapping = ((AbstractForm)form).getFormFieldReplacementsInternal()) != null && (replacementFieldClass = mapping.get(c)) != null) {
            return replacementFieldClass;
        }
        return c;
    }

    @Override
    public IFormField[] getFields() {
        IFormField[] a = new IFormField[this.m_fields.length];
        System.arraycopy(this.m_fields, 0, a, 0, a.length);
        return a;
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        int index = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i] instanceof ICompositeField ? !((ICompositeField)f[i]).visitFields(visitor, startLevel + 1) : (f[i] instanceof IWrappedFormField ? !((IWrappedFormField)f[i]).visitFields(visitor, startLevel + 1) : !visitor.visitField(f[i], startLevel, index))) {
                return false;
            }
            ++index;
            ++i;
        }
        return true;
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isSaveNeeded()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected void execMarkSaved() throws ProcessingException {
        super.execMarkSaved();
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.markSaved();
            ++n2;
        }
    }

    @Override
    protected boolean execIsEmpty() throws ProcessingException {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (!f.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void setMandatory(boolean b) {
        IFormField[] iFormFieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            f.setMandatory(b);
            ++n2;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        IFormField[] iFormFieldArray = this.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.getEnabledPermission() == null) {
                f.setEnabledGranted(b);
            }
            ++n2;
        }
    }

    @Override
    public void setVisibleGranted(boolean b) {
        super.setVisibleGranted(b);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.isInitialized()) {
            IFormField[] iFormFieldArray = this.m_fields;
            int n = this.m_fields.length;
            int n2 = 0;
            while (n2 < n) {
                IFormField f = iFormFieldArray[n2];
                f.setEnabled(b);
                ++n2;
            }
        }
    }

    protected void handleFieldVisibilityChanged() {
        int visCount = 0;
        IFormField[] f = this.m_fields;
        int i = 0;
        while (i < f.length) {
            if (f[i].isVisible()) {
                ++visCount;
            }
            ++i;
        }
        this.setVisibleFieldCount(visCount);
        this.calculateVisibleInternal();
    }

    @Override
    public void rebuildFieldGrid() {
    }

    private void setVisibleFieldCount(int n) {
        this.propertySupport.setPropertyInt("visibleFieldCount", n);
    }

    protected int getVisibleFieldCount() {
        return this.propertySupport.getPropertyInt("visibleFieldCount");
    }

    private class P_FieldPropertyChangeListener
    implements PropertyChangeListener {
        private P_FieldPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractCompositeField.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractCompositeField.this.checkSaveNeeded();
            } else if (e.getPropertyName().equals("empty")) {
                AbstractCompositeField.this.checkEmpty();
            }
        }
    }
}

