/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.htmlfield;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import javax.swing.text.html.HTMLDocument;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlField;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.IHtmlFieldUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractHtmlField
extends AbstractValueField<String>
implements IHtmlField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractHtmlField.class);
    private IHtmlFieldUIFacade m_uiFacade;
    private boolean m_htmlEditor;
    private boolean m_scrollBarEnabled;
    private RemoteFile[] m_attachments;
    private Boolean m_monitorSpelling = null;

    public AbstractHtmlField() {
        this(true);
    }

    public AbstractHtmlField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=230.0)
    @ConfigPropertyValue(value="Integer.MAX_VALUE")
    @ValidationRule(value="maxLength")
    protected int getConfiguredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredHtmlEditor() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredScrollBarEnabled() {
        return false;
    }

    @ConfigOperation
    @Order(value=230.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
        LOG.info("execHyperlinkAction " + url + " (in " + this.getClass().getName() + ")");
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.setAttachments(new RemoteFile[0]);
        super.initConfig();
        this.m_htmlEditor = this.getConfiguredHtmlEditor();
        this.m_scrollBarEnabled = this.getConfiguredScrollBarEnabled();
        this.setMaxLength(this.getConfiguredMaxLength());
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        if (this.isInitialized()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public void doHyperlinkAction(URL url) throws ProcessingException {
        this.execHyperlinkAction(url, url.getPath(), url != null && url.getHost().equals("local"));
    }

    public void setValueFromURL(URL url, String encoding) throws ProcessingException {
        if (url != null) {
            try {
                this.setValue(IOUtility.getContent((Reader)new InputStreamReader(url.openStream(), encoding)));
            }
            catch (ProcessingException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ProcessingException("URL " + url, t);
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getPlainText() {
        String s = (String)this.getValue();
        if (s != null) {
            return HTMLUtility.getPlainText((HTMLDocument)HTMLUtility.toHtmlDocument((String)s));
        }
        return "";
    }

    @Override
    public boolean isHtmlEditor() {
        return this.m_htmlEditor;
    }

    @Override
    protected String validateValueInternal(String rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue = super.validateValueInternal(rawValue);
        if (validValue != null && validValue.length() == 0) {
            validValue = null;
        }
        if (validValue != null && validValue.length() > this.getMaxLength()) {
            validValue = validValue.substring(0, this.getMaxLength());
        }
        return validValue;
    }

    @Override
    public IHtmlFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        return text;
    }

    @Override
    public void insertImage(String imageUrl) {
        if (imageUrl != null) {
            this.propertySupport.firePropertyChange("insertImage", null, (Object)imageUrl);
        }
    }

    @Override
    public RemoteFile[] getAttachments() {
        return this.m_attachments;
    }

    @Override
    public void setAttachments(RemoteFile[] attachments) {
        this.m_attachments = attachments;
    }

    @Override
    public boolean isScrollBarEnabled() {
        return this.m_scrollBarEnabled;
    }

    @Override
    public void setScrollToAnchor(String anchorName) {
        this.propertySupport.setPropertyString("scrollToPosition", anchorName);
    }

    @Override
    public String getScrollToAnchor() {
        return this.propertySupport.getPropertyString("scrollToPosition");
    }

    @Override
    public void scrollToEnd() {
        this.propertySupport.setPropertyAlwaysFire("scrollToEnd", null);
    }

    @Override
    public boolean isSpellCheckEnabled() {
        return this.isEnabled() && this.isEnabledGranted() && !(this.getForm() instanceof ISearchForm);
    }

    @Override
    public Boolean isSpellCheckAsYouTypeEnabled() {
        return this.m_monitorSpelling;
    }

    public void setSpellCheckAsYouTypeEnabled(boolean monitorSpelling) {
        this.m_monitorSpelling = new Boolean(monitorSpelling);
    }

    private class P_UIFacade
    implements IHtmlFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String htmlText) {
            if (AbstractHtmlField.this.isHtmlEditor()) {
                if (htmlText != null && htmlText.length() == 0) {
                    htmlText = null;
                }
                return AbstractHtmlField.this.parseValue(htmlText);
            }
            return true;
        }

        @Override
        public void setAttachmentsFromUI(RemoteFile[] attachments) {
            AbstractHtmlField.this.setAttachments(attachments);
        }

        @Override
        public void fireHyperlinkActionFromUI(URL url) {
            try {
                AbstractHtmlField.this.doHyperlinkAction(url);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }
}

