/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.splitbox;

import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractCompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitBox;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.ISplitboxUIFacade;
import org.eclipse.scout.rt.client.ui.form.fields.splitbox.internal.SplitBoxGrid;

public abstract class AbstractSplitBox
extends AbstractCompositeField
implements ISplitBox {
    private SplitBoxGrid m_grid;
    private ISplitboxUIFacade m_uiFacade;
    private boolean m_cacheSplitterPosition;
    private String m_cacheSplitterPositionPropertyName;

    public AbstractSplitBox() {
        this(true);
    }

    public AbstractSplitBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSplitHorizontal() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSplitterEnabled() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=340.0)
    @ConfigPropertyValue(value="0.5")
    protected double getConfiguredSplitterPosition() {
        return 0.5;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=355.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredCacheSplitterPosition() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=360.0)
    @ConfigPropertyValue(value="getClass().getName")
    protected String getConfiguredCacheSplitterPositionPropertyName() {
        return this.getClass().getName();
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        this.m_grid = new SplitBoxGrid(this);
        super.initConfig();
        this.setSplitHorizontal(this.getConfiguredSplitHorizontal());
        this.setSpliterEnabled(this.getConfiguredSplitterEnabled());
        this.setSplitterPosition(this.getConfiguredSplitterPosition());
        this.setCacheSplitterPosition(this.getConfiguredCacheSplitterPosition());
        this.setCacheSplitterPositionPropertyName(this.getConfiguredCacheSplitterPositionPropertyName());
    }

    @Override
    public void rebuildFieldGrid() {
        this.m_grid.validate();
        if (this.isInitialized() && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    protected void handleFieldVisibilityChanged() {
        super.handleFieldVisibilityChanged();
        if (this.isInitialized()) {
            this.rebuildFieldGrid();
        }
    }

    @Override
    public final int getGridColumnCount() {
        return this.m_grid.getGridColumnCount();
    }

    @Override
    public final int getGridRowCount() {
        return this.m_grid.getGridRowCount();
    }

    @Override
    public boolean isSplitHorizontal() {
        return this.propertySupport.getPropertyBool("splitHorizontal");
    }

    @Override
    public void setSplitHorizontal(boolean horizontal) {
        this.propertySupport.setPropertyBool("splitHorizontal", horizontal);
    }

    @Override
    public boolean isSplitterEnabled() {
        return this.propertySupport.getPropertyBool("splitterEnabled");
    }

    @Override
    public void setSpliterEnabled(boolean enabled) {
        this.propertySupport.setPropertyBool("splitterEnabled", enabled);
    }

    @Override
    public double getSplitterPosition() {
        return this.propertySupport.getPropertyDouble("splitterPosition");
    }

    @Override
    public void setSplitterPosition(double position) {
        this.propertySupport.setPropertyAlwaysFire("splitterPosition", (Object)position);
    }

    @Override
    public boolean isCacheSplitterPosition() {
        return this.m_cacheSplitterPosition;
    }

    @Override
    public void setCacheSplitterPosition(boolean b) {
        this.m_cacheSplitterPosition = b;
    }

    @Override
    public String getCacheSplitterPositionPropertyName() {
        return this.m_cacheSplitterPositionPropertyName;
    }

    @Override
    public void setCacheSplitterPositionPropertyName(String propName) {
        this.m_cacheSplitterPositionPropertyName = propName;
    }

    @Override
    public ISplitboxUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements ISplitboxUIFacade {
        private P_UIFacade() {
        }
    }
}

