/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.view;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;
import org.eclipse.scout.rt.server.admin.html.AdminSession;
import org.eclipse.scout.rt.server.admin.html.view.DefaultView;
import org.eclipse.scout.rt.server.admin.html.widget.table.HtmlComponent;
import org.eclipse.scout.rt.server.admin.inspector.ReflectServiceInventory;
import org.eclipse.scout.rt.server.admin.inspector.ServiceInspector;
import org.eclipse.scout.rt.server.internal.Activator;
import org.eclipse.scout.rt.shared.security.UpdateServiceConfigurationPermission;
import org.eclipse.scout.rt.shared.services.common.security.ACCESS;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.service.ServiceUtility;

public class ServicesView
extends DefaultView {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServicesView.class);
    private ServiceInspector[] m_serviceInspectors;
    private ServiceInspector m_selectedService;

    public ServicesView(AdminSession as) {
        super(as);
    }

    @Override
    public boolean isVisible() {
        return ACCESS.check((Permission)new UpdateServiceConfigurationPermission());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void activated() {
        this.m_serviceInspectors = null;
        a = Activator.getDefault();
        if (a != null) {
            SERVICES.getService(String.class);
            context = a.getBundle().getBundleContext();
            try {
                refs = context.getAllServiceReferences(null, null);
                if (refs != null) {
                    try {
                        list = new ArrayList<ServiceInspector>(refs.length);
                        var8_5 = refs;
                        var7_6 = refs.length;
                        var6_7 = 0;
                        while (var6_7 < var7_6) {
                            ref = var8_5[var6_7];
                            s = context.getService(ref);
                            if (s != null) {
                                list.add(new ServiceInspector(s));
                            }
                            ++var6_7;
                        }
                        this.m_serviceInspectors = list.toArray(new ServiceInspector[list.size()]);
                    }
                    finally {
                        var14_12 = refs;
                        var13_14 = refs.length;
                        var12_16 = 0;
                        ** while (var12_16 < var13_14)
                    }
lbl-1000:
                    // 1 sources

                    {
                        ref = var14_12[var12_16];
                        context.ungetService(ref);
                        ++var12_16;
                        continue;
lbl35:
                        // 1 sources

                    }
                }
            }
            catch (Exception v0) {}
        }
    }

    @Override
    public void produceTitle(HtmlComponent p) {
        p.print("Services");
    }

    @Override
    public void produceBody(HtmlComponent p) {
        p.startTable(0, 5, 5);
        p.startTableRow();
        p.startTableCell();
        this.renderServiceTables(p);
        p.startTableCell();
        if (this.m_selectedService != null) {
            this.renderServiceDetail(p, this.m_selectedService);
        }
        p.endTableCell();
        p.endTableRow();
        p.endTable();
    }

    private void renderServiceTables(HtmlComponent p) {
        TreeMap<CompositeObject, ArrayList<ServiceInspector>> servicesMap = new TreeMap<CompositeObject, ArrayList<ServiceInspector>>();
        if (this.m_serviceInspectors != null) {
            ServiceInspector[] serviceInspectorArray = this.m_serviceInspectors;
            int n = this.m_serviceInspectors.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceInspector inspector = serviceInspectorArray[n2];
                String serviceName = inspector.getService().getClass().getSimpleName();
                String sectionName = null;
                try {
                    int sectionOrder;
                    if (serviceName.matches(".*ProcessService")) {
                        sectionOrder = 1;
                        sectionName = "Process Services";
                    } else if (serviceName.matches(".*OutlineService")) {
                        sectionOrder = 2;
                        sectionName = "Outline Services";
                    } else if (serviceName.matches(".*LookupService")) {
                        sectionOrder = 3;
                        sectionName = "Lookup Services";
                    } else {
                        Class topInterface;
                        Class[] serviceInterfaces = ServiceUtility.getInterfacesHierarchy(inspector.getService().getClass(), Object.class);
                        Class clazz = topInterface = serviceInterfaces.length > 0 ? serviceInterfaces[serviceInterfaces.length - 1] : null;
                        if (topInterface != null && topInterface.getPackage() != null && topInterface.getPackage().getName().indexOf(".common.") >= 0) {
                            sectionOrder = 4;
                            sectionName = "Common Services";
                        } else {
                            sectionOrder = 5;
                            sectionName = "Other Services";
                        }
                    }
                    CompositeObject key = new CompositeObject(new Object[]{sectionOrder, sectionName});
                    ArrayList<ServiceInspector> list = (ArrayList<ServiceInspector>)servicesMap.get(key);
                    if (list == null) {
                        list = new ArrayList<ServiceInspector>();
                        servicesMap.put(key, list);
                    }
                    list.add(inspector);
                }
                catch (Throwable throwable) {
                    LOG.warn("Failed inspecting service " + inspector.getService().getClass());
                }
                ++n2;
            }
        }
        for (Map.Entry e : servicesMap.entrySet()) {
            String sectionName = (String)((CompositeObject)e.getKey()).getComponent(1);
            Collection list = (Collection)e.getValue();
            this.renderServiceTable(p, sectionName, list);
            p.p();
        }
    }

    private void renderServiceTable(HtmlComponent p, String sectionName, Collection<ServiceInspector> serviceInspectors) {
        TreeMap<String, ServiceInspector> sortMap = new TreeMap<String, ServiceInspector>();
        for (ServiceInspector inspector : serviceInspectors) {
            String s = inspector.getService().getClass().getName();
            sortMap.put(s, inspector);
        }
        p.p(sectionName);
        p.startListBox("listBox", 1, true);
        p.listBoxOption(" ", new AbstractHtmlAction("selectService.choose"){

            @Override
            public void run() {
            }
        }, false);
        for (ServiceInspector serviceInspector : sortMap.values()) {
            boolean selected = this.m_selectedService != null && this.m_selectedService.getService() == serviceInspector.getService();
            final ServiceInspector finalServiceInspector = serviceInspector;
            p.listBoxOption(serviceInspector.getService().getClass().getName(), new AbstractHtmlAction("selectService2." + serviceInspector.getService().getClass().getName()){

                @Override
                public void run() {
                    ServicesView.this.m_selectedService = finalServiceInspector;
                }
            }, selected);
        }
        p.endListBox();
    }

    private void renderServiceRow(HtmlComponent p, final ServiceInspector service) {
        boolean selected = this.m_selectedService != null && this.m_selectedService.getService() == service.getService();
        p.startTableRow();
        p.startTableCell();
        String serviceId = service.getService().getClass().getSimpleName();
        if (selected) {
            p.bold(serviceId);
        } else {
            p.linkAction(serviceId, new AbstractHtmlAction("selectService." + service.getService().getClass().getName()){

                @Override
                public void run() {
                    ServicesView.this.m_selectedService = service;
                }
            });
        }
        p.endTableCell();
        p.endTableRow();
    }

    private void renderServiceDetail(HtmlComponent p, ServiceInspector service) {
        ReflectServiceInventory inv;
        p.bold(service.getService().getClass().getSimpleName());
        p.p();
        try {
            inv = service.buildInventory();
        }
        catch (Throwable t) {
            p.raw("<font color=red>Inventory failed: " + t + "</font>");
            return;
        }
        this.renderHierarchy(p, service, inv);
        this.renderProperties(p, service, inv);
        this.renderOperations(p, service, inv);
        this.renderStates(p, service, inv);
    }

    private void renderHierarchy(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        Class c;
        Class<?> serviceClass = service.getService().getClass();
        ArrayList interfaceHierarchy = new ArrayList();
        Class<?>[] classArray = serviceClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c2 = classArray[n2];
            interfaceHierarchy.addAll(Arrays.asList(ServiceUtility.getInterfacesHierarchy(c2, Object.class)));
            ++n2;
        }
        if (interfaceHierarchy.size() == 0) {
            interfaceHierarchy.addAll(Arrays.asList(ServiceUtility.getInterfacesHierarchy(serviceClass, Object.class)));
        }
        interfaceHierarchy.add(serviceClass);
        ArrayList classHierarchy = new ArrayList();
        Class<?> test = service.getService().getClass();
        while (test != null) {
            if (Object.class.isAssignableFrom(test)) {
                classHierarchy.add(0, test);
            }
            test = test.getSuperclass();
        }
        p.pBold("Hierarchy");
        p.startTable(1, 0, 4);
        p.startTableRow();
        p.tableHeaderCell("Interfaces");
        p.tableHeaderCell("Classes");
        p.endTableRow();
        p.startTableRow();
        p.startTableCell();
        String prefix = "";
        Iterator it = interfaceHierarchy.iterator();
        while (it.hasNext()) {
            c = (Class)it.next();
            p.print(String.valueOf(prefix) + c.getName());
            if (!it.hasNext()) continue;
            p.br();
            prefix = String.valueOf(prefix) + "&nbsp;&nbsp;";
        }
        p.endTableCell();
        p.startTableCell();
        prefix = "";
        it = classHierarchy.iterator();
        while (it.hasNext()) {
            c = (Class)it.next();
            p.print(String.valueOf(prefix) + c.getName());
            if (!it.hasNext()) continue;
            p.br();
            prefix = String.valueOf(prefix) + "&nbsp;&nbsp;";
        }
        p.endTableCell();
        p.endTableRow();
        p.endTable();
    }

    private void renderProperties(HtmlComponent p, final ServiceInspector service, ReflectServiceInventory inv) {
        PropertyDescriptor[] properties = inv.getProperties();
        if (properties.length > 0) {
            p.pBold("Properties (" + properties.length + ")");
            p.startTable(1, 0, 4);
            p.startTableRow();
            p.tableHeaderCell("Property name");
            p.tableHeaderCell("Value");
            p.endTableRow();
            PropertyDescriptor[] propertyDescriptorArray = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                boolean editable;
                PropertyDescriptor desc = propertyDescriptorArray[n2];
                String propName = desc.getName();
                String propValue = "[value not available]";
                if (desc.getReadMethod() != null) {
                    try {
                        propValue = this.formatPropertyValue(desc, desc.getReadMethod().invoke(service.getService(), null));
                    }
                    catch (Exception exception) {}
                }
                boolean bl = editable = desc.getWriteMethod() != null;
                if (editable) {
                    final PropertyDescriptor finalDesc = desc;
                    p.startForm(new AbstractHtmlAction("changeProp." + service.getService().getClass().getName() + "." + desc.getName()){

                        @Override
                        public void run() {
                            String propText = this.getFormParameter("value", "");
                            if (propText.length() == 0) {
                                propText = null;
                            }
                            try {
                                service.changeProperty(finalDesc, propText);
                            }
                            catch (Exception e) {
                                LOG.error("setting " + finalDesc.getName() + "=" + propText, (Throwable)e);
                            }
                        }
                    });
                }
                p.startTableRow();
                p.tableCell(propName);
                p.startTableCell();
                if (editable) {
                    p.formTextArea("value", this.getPropertyDisplayValue(propName, propValue));
                    p.formSubmit("Change");
                } else {
                    p.print(this.getPropertyDisplayValue(propName, propValue));
                }
                p.endTableCell();
                p.endTableRow();
                if (editable) {
                    p.endForm();
                }
                ++n2;
            }
            p.endTable();
        }
    }

    private void renderOperations(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        Method[] operations = inv.getOperations();
        if (operations.length > 0) {
            p.pBold("Operations (" + operations.length + ")");
            p.startTable(1, 0, 4);
            p.startTableRow();
            p.tableHeaderCell("Operation");
            p.tableHeaderCell("Detail");
            p.endTableRow();
            Method[] methodArray = operations;
            int n = operations.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                p.startTableRow();
                p.tableCell(m.getName());
                p.tableCell(String.valueOf(this.createSignature(m.getReturnType())) + " " + m.getName() + "(" + this.createSignature(m.getParameterTypes()) + ")");
                p.endTableRow();
                ++n2;
            }
            p.endTable();
        }
    }

    private void renderStates(HtmlComponent p, ServiceInspector service, ReflectServiceInventory inv) {
        String[] states = inv.getStates();
        if (states.length > 0) {
            p.pBold("State");
            p.raw("<pre>");
            String[] stringArray = states;
            int n = states.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                p.print(s);
                p.br();
                ++n2;
            }
            p.raw("</pre>");
        }
    }

    private String getPropertyDisplayValue(String propertyName, String propertyValue) {
        if (this.isPropertySuppressed(propertyName)) {
            return "***";
        }
        return propertyValue;
    }

    private boolean isPropertySuppressed(String propertyName) {
        return propertyName != null && propertyName.toLowerCase().contains("password");
    }

    private String formatPropertyValue(PropertyDescriptor p, Object value) {
        Object formattedValue = value;
        return StringUtility.valueOf((Object)formattedValue);
    }

    private String createSignature(Class c) {
        if (c == null) {
            return "void";
        }
        return this.createSignature(new Class[]{c});
    }

    private String createSignature(Class[] a) {
        StringBuffer sig = new StringBuffer();
        Class[] classArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Class c = classArray[n2];
            if (sig.length() > 0) {
                sig.append(", ");
            }
            sig.append(c.getSimpleName());
            ++n2;
        }
        return sig.toString();
    }
}

