/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.admin.html.widget.table;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.server.admin.html.AbstractHtmlAction;

public class HtmlComponent {
    protected String m_baseURL;
    protected HttpServletRequest m_req;
    protected HttpServletResponse m_res;
    protected StringWriter m_writer;
    protected PrintWriter out;
    protected Map<String, AbstractHtmlAction> m_actionMap;
    protected AbstractHtmlAction m_invokedAction;

    public HtmlComponent(HttpServletRequest req, HttpServletResponse res) {
        this.m_req = req;
        this.m_res = res;
        this.m_baseURL = String.valueOf(this.m_req.getContextPath()) + this.m_req.getServletPath();
        this.m_writer = new StringWriter();
        this.out = new PrintWriter((Writer)this.m_writer, true);
        this.m_actionMap = new HashMap<String, AbstractHtmlAction>();
    }

    public HtmlComponent(HtmlComponent other) {
        this.m_req = other.m_req;
        this.m_res = other.m_res;
        this.m_baseURL = other.m_baseURL;
        this.m_invokedAction = other.m_invokedAction;
        this.m_writer = new StringWriter();
        this.out = new PrintWriter((Writer)this.m_writer, true);
        this.m_actionMap = new HashMap<String, AbstractHtmlAction>();
    }

    public void append(HtmlComponent other) {
        this.out.print(other.getProducedHtml());
        this.m_actionMap.putAll(other.m_actionMap);
    }

    public void setInvokedAction(AbstractHtmlAction invokedAction) {
        this.m_invokedAction = invokedAction;
    }

    public AbstractHtmlAction getInvokedAction() {
        return this.m_invokedAction;
    }

    private String buildActionId(AbstractHtmlAction action) {
        return action.getUid();
    }

    public HttpServletRequest getRequest() {
        return this.m_req;
    }

    public HttpServletResponse getResponse() {
        return this.m_res;
    }

    public Map<String, AbstractHtmlAction> getActionMap() {
        return this.m_actionMap;
    }

    public String getProducedHtml() {
        return this.m_writer.toString();
    }

    public void linkAction(String actionName, AbstractHtmlAction action) {
        this.startLinkAction(action);
        this.print(actionName);
        this.endLinkAction();
    }

    public void startLinkAction(AbstractHtmlAction action) {
        String actionId = this.buildActionId(action);
        this.m_actionMap.put(actionId, action);
        String u = String.valueOf(this.m_baseURL) + "?actionId=" + actionId + "#focus";
        this.out.print("<a href='" + u + "'>");
    }

    public void endLinkAction() {
        this.out.print("</a>");
    }

    public void startForm(AbstractHtmlAction action) {
        String actionId = this.buildActionId(action);
        this.m_actionMap.put(actionId, action);
        String u = this.m_baseURL;
        this.out.print("<form action='" + u + "' method='get'>");
        this.out.print("<input type='hidden' name='actionId' value='" + actionId + "'>");
    }

    public void formTextArea(String fieldName, String value) {
        if (value == null) {
            value = "";
        }
        int valueLen = value.length();
        int cols = 50;
        int rows = 1;
        rows = Math.max(rows, (valueLen + cols - 1) / cols);
        rows = Math.max(rows, StringUtility.getLineCount((String)value));
        this.out.print("<textarea rows=" + rows + " cols=" + cols + " name='" + fieldName + "'>");
        this.print(value);
        this.out.print("</textarea>");
    }

    public void startListBox(String fieldName, int size, boolean actionOnClick) {
        this.out.print("<select name=\"" + fieldName + "\" size=\"" + size + "\"");
        if (actionOnClick) {
            this.out.print(" onchange=\"javascript:window.location.href='" + this.m_baseURL + "?actionId='+this.value+'#focus';\"");
        }
        this.out.print(">");
    }

    public void radioBoxOption(String fieldName, String text, AbstractHtmlAction action, boolean selected) {
        String actionId = this.buildActionId(action);
        this.m_actionMap.put(actionId, action);
        this.out.print("<input type=\"radio\" name=\"" + fieldName + "\" value=\"" + actionId + "\" " + (selected ? " checked=\"checked\" " : "") + " onchange=\"javascript:window.location.href='" + this.m_baseURL + "?actionId='+this.value+'#focus';\">" + this.javaToHtml(text) + "</input>");
    }

    public void listBoxOption(String text, String value, boolean selected) {
        this.out.print("<option" + (selected ? " selected" : "") + " value=\"" + value + "\">" + this.javaToHtml(text) + "</option>");
    }

    public void listBoxOption(String text, AbstractHtmlAction action, boolean selected) {
        String actionId = this.buildActionId(action);
        this.m_actionMap.put(actionId, action);
        this.out.print("<option" + (selected ? " selected" : "") + " value=\"" + actionId + "\">" + this.javaToHtml(text) + "</option>");
    }

    public void endListBox() {
        this.out.print("</select>");
    }

    public void formSubmit(String value) {
        this.out.print("<input type=submit value='" + value + "'>");
    }

    public void endForm() {
        this.out.print("</form>");
    }

    public void print(String s) {
        this.out.print(this.javaToHtml(s));
    }

    public void printNoBreak(String s) {
        s = this.javaToHtml(s);
        s = s.replaceAll(" ", "&nbsp;");
        this.out.print(s);
    }

    public void br() {
        this.out.print("<br>");
    }

    public void focusAnchor() {
        this.out.print("<a name=\"focus\"></a>");
    }

    public void bold(String text) {
        this.out.print("<b>");
        this.print(text);
        this.out.print("</b>");
    }

    public void pBold(String text) {
        this.out.print("<p><b>");
        this.print(text);
        this.out.print("</b></p>");
    }

    public void pItalic(String text) {
        this.out.print("<p><i>");
        this.print(text);
        this.out.print("</i></p>");
    }

    public void p(String text) {
        this.out.print("<p>");
        this.print(text);
        this.out.print("</p>");
    }

    public void p() {
        this.out.print("<p>");
    }

    public void raw(String s) {
        this.out.print(s);
    }

    public void startTable() {
        this.startTable(0);
    }

    public void startTable(int border) {
        this.startTable(border, 0, 0);
    }

    public void startTable(int border, int cellspacing, int cellpadding) {
        this.startTable(border, cellspacing, cellpadding, null);
    }

    public void startTable(int border, int cellspacing, int cellpadding, String width) {
        this.out.print("<table");
        if (border >= 0) {
            this.out.print(" border=" + border);
        }
        if (cellspacing >= 0) {
            this.out.print(" cellspacing=" + cellspacing);
        }
        if (cellpadding >= 0) {
            this.out.print(" cellpadding=" + cellpadding);
        }
        if (width != null) {
            this.out.print(" width='" + width + "'");
        }
        this.out.print(">");
    }

    public void endTable() {
        this.out.print("</table>");
    }

    public void startTableRow() {
        this.out.print("<tr>");
    }

    public void endTableRow() {
        this.out.println("</tr>");
    }

    public void spacingRow(int columnCount) {
        this.out.print("<tr>");
        this.out.print("<td colspan=\"" + columnCount + "\">");
        this.out.print("&nbsp;");
        this.out.print("</td>");
        this.out.println("</tr>");
    }

    public void startTableCell() {
        this.startTableCell(1, 1);
    }

    public void startTableCell(int rows, int cols) {
        this.startTableCell(rows, cols, null);
    }

    public void startTableCell(int rows, int cols, String color) {
        this.out.print("<td");
        if (rows > 1) {
            this.out.print(" rowspan=" + rows);
        }
        if (cols > 1) {
            this.out.print(" colspan=" + cols);
        }
        if (color != null) {
            this.out.print(" bgcolor='#" + color + "'");
        }
        this.out.print(">");
    }

    public void endTableCell() {
        this.out.print("</td>");
    }

    public void tableCell(String content) {
        this.tableCell(content, 1, 1);
    }

    public void tableCell(String content, int rows, int cols) {
        this.tableCell(content, 1, 1, null);
    }

    public void tableCell(String content, int rows, int cols, String color) {
        this.startTableCell(rows, cols, color);
        if (content == null || content.trim().length() == 0) {
            this.out.print("&nbsp;");
        } else {
            this.print(content);
        }
        this.endTableCell();
    }

    public void tableHeaderCell(String content) {
        this.out.print("<th>");
        if (content == null || content.trim().length() == 0) {
            this.out.print("&nbsp;");
        } else {
            this.print(content);
        }
        this.out.print("</th>");
    }

    public String javaToHtml(String s) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }
}

