/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.scout.rt.server.ThreadContext;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;

public class SingleUserFilter
implements IClientNotificationFilter {
    private static final long serialVersionUID = 1L;
    private String m_userId;
    private long m_validUntil;

    public SingleUserFilter(String userId, long timeout) {
        this.m_userId = userId;
        this.m_validUntil = System.currentTimeMillis() + timeout;
    }

    public String getUserId() {
        return this.m_userId;
    }

    @Override
    public boolean isActive() {
        return System.currentTimeMillis() <= this.m_validUntil;
    }

    @Override
    public boolean isMulticast() {
        return false;
    }

    @Override
    public boolean accept() {
        return this.m_userId != null && this.m_userId.equalsIgnoreCase(ThreadContext.getServerSession().getUserId());
    }

    public int hashCode() {
        return this.m_userId != null ? this.m_userId.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            SingleUserFilter o = (SingleUserFilter)obj;
            return o.m_userId == this.m_userId || o.m_userId != null && o.m_userId.equals(this.m_userId);
        }
        return false;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(this.getClass().getSimpleName());
        b.append("[");
        b.append(this.m_userId);
        b.append(", validUntil=" + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date(this.m_validUntil)));
        b.append("]");
        return b.toString();
    }
}

