/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.pop3;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.pop3.IPOP3MessageVisitor;

public class POP3Adapter {
    public static final String TRASH_FOLDER_NAME = "Trash";
    private boolean m_useSSL;
    private String m_host;
    private int m_port;
    private String m_username;
    private String m_password;
    private String m_defaultFolderName;
    private Store m_store;
    private HashMap<String, Folder> m_cachedFolders = new HashMap();
    private boolean m_connected = false;

    public POP3Adapter() {
    }

    public POP3Adapter(String host, int port, String username, String password) {
        this();
        this.m_host = host;
        this.m_port = port;
        this.m_username = username;
        this.m_password = password;
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
        super.finalize();
    }

    public String[] getUnseenMessageSubjects() throws ProcessingException {
        return this.getUnseenMessageSubjects(this.getDefaultFolderName());
    }

    public String[] getUnseenMessageSubjects(String folderName) throws ProcessingException {
        this.connect();
        ArrayList<Message> messages = new ArrayList<Message>();
        Folder folder = null;
        String[] subjects = null;
        try {
            folder = this.findFolder(folderName);
            if (folder != null) {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
                Message[] m = folder.getMessages();
                int i = 0;
                while (i < Array.getLength(m)) {
                    Message item = m[i];
                    if (!item.isSet(Flags.Flag.SEEN)) {
                        messages.add(item);
                        item.setFlag(Flags.Flag.DELETED, true);
                    }
                    ++i;
                }
                subjects = new String[messages.size()];
                Message[] messageArray = messages.toArray(new Message[messages.size()]);
                int i2 = 0;
                while (i2 < messages.size()) {
                    subjects[i2] = messageArray[i2].getSubject();
                    ++i2;
                }
                folder.close(true);
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
        return subjects;
    }

    public Message[] getUnseenMessages(final Flags.Flag markAfterRead) throws ProcessingException {
        final ArrayList list = new ArrayList();
        this.visitUnseenMessages(this.getDefaultFolderName(), new IPOP3MessageVisitor(){

            @Override
            public boolean visit(Message m) throws MessagingException {
                list.add(m);
                m.setFlag(markAfterRead, true);
                return true;
            }
        });
        return list.toArray(new Message[list.size()]);
    }

    public void visitUnseenMessages(String folderName, IPOP3MessageVisitor visitor) throws ProcessingException {
        this.connect();
        Folder folder = null;
        try {
            folder = this.findFolder(folderName);
            if (folder != null) {
                if (!folder.isOpen()) {
                    folder.open(2);
                }
                int count = folder.getMessageCount();
                int i = 0;
                while (i < count) {
                    boolean ok;
                    Message m = folder.getMessage(i + 1);
                    if (!m.isSet(Flags.Flag.SEEN) && !(ok = visitor.visit(m))) break;
                    ++i;
                }
                folder.close(true);
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException("reading folder " + folderName, (Throwable)e);
        }
    }

    protected void connect() throws ProcessingException {
        try {
            final Properties props = new Properties();
            props.setProperty("mail.pop3.host", this.getHost());
            props.setProperty("mail.pop3.user", this.getUsername());
            props.setProperty("mail.pop3.password", this.getPassword());
            props.setProperty("mail.pop3.port", "" + this.getPort());
            props.setProperty("mail.pop3.auth", "" + this.isUseSSL());
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(props.getProperty("mail.pop3.user"), props.getProperty("mail.pop3.password"));
                }
            });
            this.m_store = session.getStore("pop3");
            this.m_store.connect();
        }
        catch (Exception e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    protected Folder findFolder(String name) throws ProcessingException {
        return this.findFolder(name, false);
    }

    protected Folder findFolder(String name, boolean createNonExisting) throws ProcessingException {
        this.connect();
        Folder folder = this.m_cachedFolders.get(name);
        if (folder == null) {
            try {
                Folder f = this.m_store.getFolder(name);
                if (f.exists()) {
                    folder = f;
                } else if (createNonExisting) {
                    f.create(3);
                    folder = f;
                }
                if (folder != null) {
                    folder.open(2);
                    this.m_cachedFolders.put(name, folder);
                }
            }
            catch (MessagingException e) {
                throw new ProcessingException("could not open folder: " + name, (Throwable)e);
            }
        }
        return folder;
    }

    public void closeConnection() throws ProcessingException {
        if (this.isConnected()) {
            ArrayList<MessagingException> exceptions = new ArrayList<MessagingException>();
            for (Folder folder : this.m_cachedFolders.values()) {
                try {
                    try {
                        folder.close(true);
                    }
                    catch (MessagingException e) {
                        exceptions.add(e);
                        try {
                            folder.close(false);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        folder.close(false);
                    }
                    catch (Throwable throwable2) {}
                    throw throwable;
                }
                try {
                    folder.close(false);
                }
                catch (Throwable throwable) {}
            }
            try {
                this.m_store.close();
            }
            catch (MessagingException e) {
                exceptions.add(e);
            }
            if (exceptions.size() > 0) {
                throw new ProcessingException(((MessagingException)((Object)exceptions.get(0))).getMessage());
            }
            this.m_cachedFolders.clear();
            this.m_connected = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAttachments(Message message, boolean includingInlineAttachments) throws ProcessingException {
        this.connect();
        try {
            Object content = message.getContent();
            if (!(content instanceof Multipart)) {
                return false;
            }
            Multipart multipart = (Multipart)content;
            int i = 0;
            while (true) {
                if (i >= multipart.getCount()) {
                    return false;
                }
                if (multipart.getBodyPart(i).getDisposition().equalsIgnoreCase("attachment")) {
                    return true;
                }
                if (includingInlineAttachments && multipart.getBodyPart(i).getDisposition().equalsIgnoreCase("inline")) {
                    return true;
                }
                ++i;
            }
        }
        catch (MessagingException me) {
            throw new ProcessingException("could not read message!", (Throwable)me);
        }
        catch (IOException ioe) {
            throw new ProcessingException("could not read message content!", (Throwable)ioe);
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public String getDefaultFolderName() {
        return this.m_defaultFolderName;
    }

    public void setDefaultFolderName(String defaultFolderName) {
        this.m_defaultFolderName = defaultFolderName;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public boolean isUseSSL() {
        return this.m_useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.m_useSSL = useSSL;
    }

    public void setUseSSL(String s) {
        this.m_useSSL = StringUtility.parseBoolean((String)s, (boolean)true);
    }
}

