/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.servlet.test;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.security.auth.Subject;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.http.servletfilter.HttpServletEx;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.services.common.session.IServerSessionRegistryService;
import org.eclipse.scout.rt.shared.services.common.test.BasicTestContext;
import org.eclipse.scout.rt.shared.services.common.test.ITest;
import org.eclipse.scout.rt.shared.services.common.test.ITestContext;
import org.eclipse.scout.rt.shared.services.common.test.TestStatus;
import org.eclipse.scout.rt.shared.services.common.test.TestUtility;
import org.eclipse.scout.service.SERVICES;

public class TestServlet
extends HttpServletEx {
    private static final long serialVersionUID = 1L;
    private Class<? extends IServerSession> m_serverSessionClass;
    private String m_runAs;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String qname = config.getInitParameter("session");
        if (qname == null) {
            throw new ServletException("Expected init-param \"session\"");
        }
        String runAs = config.getInitParameter("runAs");
        if (runAs == null) {
            throw new ServletException("Expected init-param \"runAs\"");
        }
        int i = qname.lastIndexOf(46);
        try {
            this.m_serverSessionClass = Platform.getBundle((String)qname.substring(0, i)).loadClass(qname);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Loading class " + qname, (Throwable)e);
        }
        this.m_runAs = runAs;
    }

    public void destroy() {
        this.m_serverSessionClass = null;
        this.m_runAs = null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        IServerSession serverSession;
        res.setContentType("text/html");
        final BasicTestContext ctx = new BasicTestContext();
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new SimplePrincipal(this.m_runAs));
        try {
            serverSession = ((IServerSessionRegistryService)SERVICES.getService(IServerSessionRegistryService.class)).newServerSession(this.m_serverSessionClass, subject);
        }
        catch (ProcessingException e) {
            e.printStackTrace(new PrintStream((OutputStream)res.getOutputStream(), true));
            return;
        }
        IStatus status = new ServerJob("Test", serverSession, subject){

            @Override
            protected IStatus runTransaction(IProgressMonitor monitor) throws Exception {
                ITest[] tests = (ITest[])SERVICES.getServices(ITest.class);
                TestUtility.runTests((ITestContext)ctx, (ITest[])tests);
                return Status.OK_STATUS;
            }
        }.runNow((IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            status.getException().printStackTrace(new PrintStream((OutputStream)res.getOutputStream(), true));
        }
        StringBuffer records = new StringBuffer();
        for (TestStatus s : ctx.getStatusList()) {
            String severityColor;
            this.getTestRecordTemplate();
            switch (s.getSeverity()) {
                case 1: {
                    severityColor = "00ff00";
                    break;
                }
                case 2: {
                    severityColor = "ffff00";
                    break;
                }
                case 4: {
                    severityColor = "ff0000";
                    break;
                }
                case 16: {
                    severityColor = "880000";
                    break;
                }
                default: {
                    severityColor = "ffffff";
                }
            }
            String product = StringUtility.htmlEncode((String)s.getProduct(), (boolean)true);
            String title = StringUtility.htmlEncode((String)s.getTitle(), (boolean)true);
            String subTitle = StringUtility.htmlEncode((String)s.getSubTitle(), (boolean)true);
            String message = StringUtility.htmlEncode((String)s.getMessage(), (boolean)true);
            if (s.getCause() != null) {
                StringWriter w = new StringWriter();
                s.getCause().printStackTrace(new PrintWriter((Writer)w, true));
                String detail = "<textarea rows=\"4\" cols=\"80\">" + StringUtility.htmlEncode((String)w.toString(), (boolean)true) + "</textarea>";
                message = String.valueOf(message) + "<br>" + detail;
            }
            records.append(MessageFormat.format(this.getTestRecordTemplate(), severityColor, product, title, subTitle, message));
        }
        String date = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date());
        String page = MessageFormat.format(this.getPageTemplate(), date, ctx.getSeverityCount(1), ctx.getSeverityCount(2), ctx.getSeverityCount(4), ctx.getSeverityCount(16), records.toString());
        res.getOutputStream().print(page);
    }

    protected String getPageTemplate() {
        return "<html><body>\n<h1>Automated Test Run</h1>\n<h3>{0}</h3>\n<table border=\"0\">\n<tr><td>{1}</td><td>Success</td></tr>\n<tr><td>{2}</td><td>Warnings</td></tr>\n<tr><td>{3}</td><td>Errors</td></tr>\n<tr><td>{4}</td><td>Fatals</td></tr>\n</table>\n<hr>\n<table border=\"1\">\n{5}</table>\n</body></html>";
    }

    protected String getTestRecordTemplate() {
        return "<tr>\n<td bgcolor=\"{0}\" valign=\"top\">\n<b>{1}</b>\n</td>\n<td valign=\"top\">\n<b>{2}</b>\n</td>\n<td valign=\"top\">\n{3}\n</td>\n<td valign=\"top\">\n{4}\n</td>\n</tr>\n";
    }
}

