/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.data.model;

import java.util.List;
import org.eclipse.scout.rt.shared.data.model.EntityPath;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelEntity;

public final class AttributePath {
    private final EntityPath m_entityPath;
    private final IDataModelAttribute m_attribute;

    public AttributePath(List<IDataModelEntity> entityPath, IDataModelAttribute attribute) {
        this(entityPath != null && entityPath.size() > 0 ? new EntityPath(entityPath) : null, attribute);
    }

    public AttributePath(EntityPath entityPath, IDataModelAttribute attribute) {
        this.m_entityPath = entityPath == null || entityPath.size() == 0 ? EntityPath.EMPTY : entityPath;
        this.m_attribute = attribute;
    }

    public EntityPath getEntityPath() {
        return this.m_entityPath;
    }

    public IDataModelAttribute getAttribute() {
        return this.m_attribute;
    }

    public int hashCode() {
        return this.m_entityPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AttributePath)) {
            return false;
        }
        AttributePath other = (AttributePath)obj;
        return this.m_entityPath.equals(other.m_entityPath) && this.m_attribute == other.m_attribute;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.m_entityPath.toString() + "#" + this.m_attribute.getClass().getSimpleName() + "(" + this.m_attribute.getText() + ")]";
    }
}

