/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.context;

import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.beans.BasicPropertySupport;

public class SharedVariableMap
implements Serializable,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private int m_version;
    private HashMap<String, Object> m_variables;
    private transient BasicPropertySupport m_propertySupport;

    public SharedVariableMap() {
        this.m_version = 0;
        this.m_variables = new HashMap();
        this.m_propertySupport = new BasicPropertySupport((Object)this);
    }

    public SharedVariableMap(SharedVariableMap map) {
        this.m_version = map.m_version;
        this.m_variables = new HashMap<String, Object>(map.m_variables);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public void updateInternal(SharedVariableMap newMap) {
        if (newMap.getVersion() != this.getVersion()) {
            this.m_variables = new HashMap<String, Object>(newMap.m_variables);
            this.m_version = newMap.getVersion();
        }
    }

    public int getVersion() {
        return this.m_version;
    }

    private void mapChanged() {
        ++this.m_version;
        if (this.m_propertySupport != null) {
            this.m_propertySupport.firePropertyChange("values", null, new HashMap<String, Object>(this.m_variables));
        }
    }

    @Override
    public void clear() {
        this.m_variables.clear();
        this.mapChanged();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m_variables.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m_variables.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(this.m_variables.entrySet());
    }

    @Override
    public Object get(Object key) {
        return this.m_variables.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.m_variables.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.m_variables.keySet());
    }

    @Override
    public Object put(String key, Object value) {
        Object o = this.m_variables.put(key, value);
        this.mapChanged();
        return o;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.m_variables.putAll(m);
        this.mapChanged();
    }

    @Override
    public Object remove(Object key) {
        Object o = this.m_variables.remove(key);
        this.mapChanged();
        return o;
    }

    @Override
    public int size() {
        return this.m_variables.size();
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(this.m_variables.values());
    }

    public String toString() {
        return this.m_variables.toString();
    }
}

